/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility.generator.io;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

class FormattedWriter {
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final String indent = "    ";
    private StringBuffer _buffer;
    private int _initialIndents = 0;

    FormattedWriter() {
    }

    private StringBuffer getBuffer() {
        if (this._buffer == null) {
            this._buffer = new StringBuffer();
        }
        return this._buffer;
    }

    public String toString() {
        return this.getBuffer().toString();
    }

    void writeComments(String[] stringArray) {
        int n = stringArray != null ? stringArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.writeln("// " + (string != null ? string : ""));
            ++n2;
        }
    }

    private void _write(int n, String string) {
        StringBuffer stringBuffer = this.getBuffer();
        if (!string.equals(lineSeparator)) {
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(indent);
                ++n2;
            }
        }
        stringBuffer.append(string);
    }

    void write(int n, String string) {
        this._write(n + this._initialIndents, string);
    }

    void write(String string) {
        this._write(0, string);
    }

    void writeln(int n, String string) {
        if (this._initialIndents > 0) {
            this._write(this._initialIndents, "");
        }
        this._write(n, string + lineSeparator);
    }

    void writeln(String string) {
        this.writeln(0, string);
    }

    void writeln() {
        this.writeln(0, "");
    }

    void writeList(int n, List list, boolean bl) {
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.indent(n, iterator.next().toString());
                if (!bl) continue;
                this.writeln();
            }
            if (!bl) {
                this.writeln();
            }
        }
    }

    void writeList(int n, List list) {
        this.writeList(n, list, false);
    }

    void writeList(List list) {
        this.writeList(0, list);
    }

    private void indent(int n, String string) {
        if (string.indexOf(lineSeparator) != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, lineSeparator, true);
            while (stringTokenizer.hasMoreTokens()) {
                this.write(n, stringTokenizer.nextToken());
            }
        } else {
            this.write(n, string);
        }
    }
}

