/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.model;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import java.util.ArrayList;

public class LocalFieldDesc
extends FieldDesc {
    public transient ArrayList columnDescs;
    private Boolean primitiveMappedToNullableColumn;
    private Object discriminatorValue;
    private MappingValidator floatValidator = new FloatValidator();
    private MappingValidator doubleValidator = new DoubleValidator();
    private MappingValidator bigDecimalValidator = new BigDecimalValidator();

    public LocalFieldDesc() {
        this.sqlProperties |= 0x20;
    }

    public Object getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public void setDiscriminatorValue(Object object) {
        this.discriminatorValue = object;
    }

    public boolean isPrimitiveMappedToNullableColumn() {
        if (this.primitiveMappedToNullableColumn == null) {
            boolean bl = this.getType().isPrimitive();
            int n = 0;
            while (n < this.columnDescs.size() && bl) {
                ColumnElement columnElement = (ColumnElement)this.columnDescs.get(n);
                bl = columnElement.isNullable();
                ++n;
            }
            this.primitiveMappedToNullableColumn = new Boolean(bl);
        }
        return this.primitiveMappedToNullableColumn;
    }

    protected void initializeConcurrencyCheckProperty(Class clazz) {
        super.initializeConcurrencyCheckProperty(clazz);
        if (this.getEnumType() == 7 || this.getEnumType() == 17) {
            if (!this.checkExactMapping(this.floatValidator)) {
                this.sqlProperties &= 0xFFFFFFFE;
            }
        } else if (this.getEnumType() == 8 || this.getEnumType() == 18) {
            if (!this.checkExactMapping(this.doubleValidator)) {
                this.sqlProperties &= 0xFFFFFFFE;
            }
        } else if (this.getEnumType() == 19 && !this.checkExactMapping(this.bigDecimalValidator)) {
            this.sqlProperties &= 0xFFFFFFFE;
        }
    }

    private boolean checkExactMapping(MappingValidator mappingValidator) {
        boolean bl = true;
        int n = 0;
        while (n < this.columnDescs.size() && bl) {
            ColumnElement columnElement = (ColumnElement)this.columnDescs.get(n);
            bl = mappingValidator.accept(columnElement);
            ++n;
        }
        return bl;
    }

    private static class BigDecimalValidator
    implements MappingValidator {
        private BigDecimalValidator() {
        }

        public boolean accept(ColumnElement columnElement) {
            int n = columnElement.getType();
            Integer n2 = columnElement.getScale();
            boolean bl = false;
            switch (n) {
                case 2: 
                case 3: {
                    if (n2 != null) break;
                    bl = true;
                }
            }
            return bl;
        }
    }

    private static class DoubleValidator
    implements MappingValidator {
        private DoubleValidator() {
        }

        public boolean accept(ColumnElement columnElement) {
            int n = columnElement.getType();
            Integer n2 = columnElement.getScale();
            boolean bl = false;
            switch (n) {
                case 2: 
                case 3: {
                    if (n2 != null) break;
                    bl = true;
                    break;
                }
                case 6: 
                case 8: {
                    bl = true;
                }
            }
            return bl;
        }
    }

    private static class FloatValidator
    implements MappingValidator {
        private FloatValidator() {
        }

        public boolean accept(ColumnElement columnElement) {
            int n = columnElement.getType();
            Integer n2 = columnElement.getScale();
            boolean bl = false;
            switch (n) {
                case 2: 
                case 3: {
                    if (n2 != null) break;
                    bl = true;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    bl = true;
                }
            }
            return bl;
        }
    }

    static interface MappingValidator {
        public boolean accept(ColumnElement var1);
    }
}

