/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.util;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.ColumnPairElement;
import com.sun.forte4j.modules.dbmodel.DBIdentifier;
import com.sun.forte4j.modules.dbmodel.DBMemberElement;
import com.sun.forte4j.modules.dbmodel.ForeignKeyElement;
import com.sun.forte4j.modules.dbmodel.KeyElement;
import com.sun.forte4j.modules.dbmodel.SchemaElement;
import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.forte4j.modules.dbmodel.UniqueKeyElement;
import com.sun.forte4j.modules.dbmodel.util.NameUtil;
import com.sun.forte4j.modules.dbmodel.util.SQLTypeUtil;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingMemberElement;
import com.sun.jdo.api.persistence.model.mapping.MappingReferenceKeyElement;
import com.sun.jdo.api.persistence.model.mapping.MappingRelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingTableElement;
import com.sun.jdo.api.persistence.model.util.LogHelperModel;
import com.sun.jdo.api.persistence.model.util.ModelValidationException;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class ModelValidator {
    private Model _model;
    private String _className;
    private ClassLoader _classLoader;
    private ResourceBundle _messages;

    public ModelValidator(Model model, String string, ResourceBundle resourceBundle) {
        this(model, string, null, resourceBundle);
    }

    public ModelValidator(Model model, String string, ClassLoader classLoader, ResourceBundle resourceBundle) {
        this._model = model;
        this._className = string;
        this._classLoader = classLoader;
        this._messages = resourceBundle;
    }

    public Model getModel() {
        return this._model;
    }

    public String getClassName() {
        return this._className;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    protected ResourceBundle getMessages() {
        return this._messages;
    }

    public boolean parseCheck() {
        Iterator iterator = this.getBasicValidationList().iterator();
        try {
            while (iterator.hasNext()) {
                ((ValidationComponent)iterator.next()).validate();
            }
        }
        catch (ModelValidationException modelValidationException) {
            LogHelperModel.getLogger().log(400, "model.parse_error", modelValidationException);
            return false;
        }
        return true;
    }

    public Collection fullValidationCheck() {
        ArrayList<ModelValidationException> arrayList = new ArrayList<ModelValidationException>();
        Iterator iterator = this.getFullValidationList().iterator();
        while (iterator.hasNext()) {
            try {
                ((ValidationComponent)iterator.next()).validate();
            }
            catch (ModelValidationException modelValidationException) {
                arrayList.add(modelValidationException);
            }
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public Collection getBasicValidationList() {
        ArrayList<ValidationComponent> arrayList = new ArrayList<ValidationComponent>();
        String string = this.getClassName();
        arrayList.add(this.createClassExistenceComponent(string));
        arrayList.add(this.createClassPersistenceComponent(string));
        arrayList.addAll(this.getDatabaseValidationList());
        arrayList.addAll(this.getFieldsValidationList());
        return Collections.unmodifiableCollection(arrayList);
    }

    public Collection getFullValidationList() {
        ArrayList<ValidationComponent> arrayList = new ArrayList<ValidationComponent>(this.getBasicValidationList());
        String string = this.getClassName();
        PersistenceClassElement persistenceClassElement = this.getPersistenceClass(string);
        if (persistenceClassElement != null) {
            PersistenceFieldElement[] persistenceFieldElementArray = persistenceClassElement.getFields();
            int n = persistenceFieldElementArray != null ? persistenceFieldElementArray.length : 0;
            arrayList.add(this.createSerializableClassComponent(string));
            arrayList.add(this.createKeyClassComponent(persistenceClassElement.getKeyClass()));
            arrayList.add(this.createClassMappingComponent(persistenceClassElement));
            arrayList.add(this.createKeyColumnMappingComponent(persistenceClassElement));
            int n2 = 0;
            while (n2 < n) {
                PersistenceFieldElement persistenceFieldElement = persistenceFieldElementArray[n2];
                arrayList.add(this.createFieldCardinalityComponent(persistenceFieldElement));
                arrayList.add(this.createFieldMappingComponent(persistenceFieldElement));
                arrayList.add(this.createFieldBlobMappingComponent(persistenceFieldElement));
                arrayList.addAll(this.getRelatedClassValidationList(persistenceFieldElement));
                ++n2;
            }
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    private Collection getDatabaseValidationList() {
        ArrayList<ValidationComponent> arrayList = new ArrayList<ValidationComponent>();
        String string = this.getClassName();
        MappingClassElement mappingClassElement = this.getMappingClass(string);
        if (mappingClassElement != null) {
            Object object;
            MappingMemberElement mappingMemberElement;
            ArrayList arrayList2 = mappingClassElement.getTables();
            int n = arrayList2 != null ? arrayList2.size() : 0;
            MappingMemberElement mappingMemberElement2 = null;
            Iterator iterator = null;
            arrayList.add(this.createSchemaExistenceComponent(string));
            int n2 = 0;
            while (n2 < n) {
                mappingMemberElement = (MappingTableElement)arrayList2.get(n2);
                arrayList.add(this.createTableExistenceComponent(mappingMemberElement.getTable()));
                if (n2 == 0) {
                    mappingMemberElement2 = mappingMemberElement;
                    arrayList.add(this.createPrimaryTableComponent((MappingTableElement)mappingMemberElement2));
                } else {
                    object = this.findReferenceKey((MappingTableElement)mappingMemberElement2, (MappingTableElement)mappingMemberElement);
                    if (object != null) {
                        iterator = object.getColumnPairNames().iterator();
                        while (iterator.hasNext()) {
                            arrayList.add(this.createColumnExistenceComponent((String)iterator.next()));
                        }
                    }
                }
                ++n2;
            }
            iterator = mappingClassElement.getFields().iterator();
            while (iterator.hasNext()) {
                mappingMemberElement = (MappingFieldElement)iterator.next();
                object = new ArrayList();
                Iterator iterator2 = null;
                if (this.isRelationship(mappingMemberElement)) {
                    ((ArrayList)object).addAll(((MappingRelationshipElement)mappingMemberElement).getAssociatedColumns());
                }
                ((ArrayList)object).addAll(mappingMemberElement.getColumns());
                iterator2 = ((ArrayList)object).iterator();
                while (iterator2.hasNext()) {
                    arrayList.add(this.createColumnExistenceComponent((String)iterator2.next(), (MappingFieldElement)mappingMemberElement));
                }
            }
        }
        return arrayList;
    }

    private Collection getFieldsValidationList() {
        ArrayList<ValidationComponent> arrayList = new ArrayList<ValidationComponent>();
        Model model = this.getModel();
        String string = this.getClassName();
        PersistenceClassElement persistenceClassElement = this.getPersistenceClass(string);
        if (persistenceClassElement != null) {
            Object object;
            Comparable comparable;
            PersistenceFieldElement[] persistenceFieldElementArray = persistenceClassElement.getFields();
            int n = persistenceFieldElementArray != null ? persistenceFieldElementArray.length : 0;
            Iterator iterator = this.getMappingClass(string).getFields().iterator();
            int n2 = 0;
            while (n2 < n) {
                comparable = persistenceFieldElementArray[n2];
                arrayList.add(this.createFieldExistenceComponent(comparable));
                if (model.hasField(string, ((PersistenceElement)comparable).getName())) {
                    arrayList.add(this.createFieldPersistenceComponent((PersistenceFieldElement)comparable));
                    arrayList.add(this.createFieldPersistenceTypeComponent((PersistenceFieldElement)comparable));
                    arrayList.add(this.createFieldConsistencyComponent((PersistenceFieldElement)comparable));
                    if (this.isLegalRelationship((PersistenceFieldElement)comparable)) {
                        object = (RelationshipElement)comparable;
                        arrayList.add(this.createElementClassComponent((RelationshipElement)object));
                        arrayList.add(this.createRelatedClassMatchesComponent((RelationshipElement)object));
                        arrayList.add(this.createDefaultFetchGroupComponent((RelationshipElement)object));
                    }
                }
                ++n2;
            }
            while (iterator.hasNext()) {
                comparable = (MappingFieldElement)iterator.next();
                object = comparable.getName();
                if (persistenceClassElement.getField((String)object) == null) {
                    arrayList.add(this.createFieldExistenceComponent(comparable));
                    if (model.hasField(string, (String)object)) {
                        arrayList.add(this.createFieldConsistencyComponent((MappingFieldElement)comparable));
                    }
                }
                if (this.isRelationship(comparable)) continue;
                arrayList.add(this.createColumnOverlapComponent((MappingFieldElement)comparable));
                arrayList.add(this.createFieldDefaultFetchGroupComponent((MappingFieldElement)comparable));
            }
        }
        return arrayList;
    }

    private Collection getRelatedClassValidationList(PersistenceFieldElement persistenceFieldElement) {
        String string = this.getRelatedClass(persistenceFieldElement);
        ArrayList<ValidationComponent> arrayList = new ArrayList<ValidationComponent>();
        if (string != null && this.getModel().hasField(this.getClassName(), persistenceFieldElement.getName())) {
            MappingClassElement mappingClassElement = this.getMappingClass(string);
            arrayList.add(this.createClassExistenceComponent(string, persistenceFieldElement));
            arrayList.add(this.createClassPersistenceComponent(string, persistenceFieldElement));
            arrayList.add(this.createSchemaExistenceComponent(string, persistenceFieldElement));
            arrayList.add(this.createRelatedSchemaMatchesComponent(string, persistenceFieldElement));
            if (mappingClassElement != null) {
                ArrayList arrayList2 = mappingClassElement.getTables();
                MappingTableElement mappingTableElement = null;
                if (arrayList2 != null && arrayList2.size() > 0) {
                    mappingTableElement = (MappingTableElement)arrayList2.get(0);
                    arrayList.add(this.createTableExistenceComponent(mappingTableElement.getTable(), persistenceFieldElement));
                }
                if (this.isRelationship(persistenceFieldElement)) {
                    RelationshipElement relationshipElement = (RelationshipElement)persistenceFieldElement;
                    MappingFieldElement mappingFieldElement = this.getMappingClass(this.getClassName()).getField(persistenceFieldElement.getName());
                    arrayList.add(this.createInverseFieldComponent(relationshipElement));
                    arrayList.add(this.createInverseMappingComponent(relationshipElement));
                    if (mappingFieldElement != null && this.isRelationship(mappingFieldElement)) {
                        MappingRelationshipElement mappingRelationshipElement = (MappingRelationshipElement)mappingFieldElement;
                        ArrayList arrayList3 = mappingRelationshipElement.getAssociatedColumns();
                        Iterator iterator = null;
                        if (arrayList3 == null || arrayList3.size() == 0) {
                            arrayList3 = mappingRelationshipElement.getColumns();
                        }
                        if (arrayList3 != null) {
                            iterator = arrayList3.iterator();
                            while (iterator.hasNext()) {
                                arrayList.add(this.createRelatedTableMatchesComponent(string, persistenceFieldElement, mappingTableElement, (String)iterator.next()));
                            }
                        }
                    }
                }
            }
        }
        return arrayList;
    }

    protected ValidationComponent createClassExistenceComponent(final String string, final PersistenceFieldElement persistenceFieldElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (string == null || !ModelValidator.this.getModel().hasClass(string, ModelValidator.this.getClassLoader())) {
                    throw ModelValidator.this.constructClassException(string, persistenceFieldElement, "util.validation.class_not_found");
                }
            }
        };
    }

    protected ValidationComponent createClassExistenceComponent(String string) {
        return this.createClassExistenceComponent(string, null);
    }

    protected ValidationComponent createClassPersistenceComponent(final String string, final PersistenceFieldElement persistenceFieldElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                Model model = ModelValidator.this.getModel();
                if (string != null && model.hasClass(string, ModelValidator.this.getClassLoader())) {
                    String string2 = null;
                    if (!ModelValidator.this.isPersistent(string)) {
                        string2 = "util.validation.class_not_persistence_capable";
                    } else if (!model.isPersistenceCapableAllowed(string)) {
                        string2 = "util.validation.class_not_allowed";
                    }
                    if (string2 != null) {
                        throw ModelValidator.this.constructClassException(string, persistenceFieldElement, string2);
                    }
                }
            }
        };
    }

    protected ValidationComponent createClassPersistenceComponent(String string) {
        return this.createClassPersistenceComponent(string, null);
    }

    protected ValidationComponent createFieldExistenceComponent(final String string) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (!ModelValidator.this.getModel().hasField(ModelValidator.this.getClassName(), string)) {
                    throw ModelValidator.this.constructFieldException(string, "util.validation.field_not_found");
                }
            }
        };
    }

    protected ValidationComponent createFieldExistenceComponent(Object object) {
        return this.createFieldExistenceComponent(object.toString());
    }

    protected ValidationComponent createFieldPersistenceComponent(final PersistenceFieldElement persistenceFieldElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                boolean bl = 0 == persistenceFieldElement.getPersistenceType();
                String string = persistenceFieldElement.getName();
                if (bl && !ModelValidator.this.isPersistentAllowed(ModelValidator.this.getClassName(), string)) {
                    throw ModelValidator.this.constructFieldException(string, "util.validation.field_persistent_not_allowed");
                }
            }
        };
    }

    protected ValidationComponent createFieldConsistencyComponent(final PersistenceFieldElement persistenceFieldElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                String string = persistenceFieldElement.getName();
                String string2 = ModelValidator.this.getClassName();
                boolean bl = ModelValidator.this.isPersistentAllowed(string2, string);
                if (bl) {
                    boolean bl2;
                    MappingFieldElement mappingFieldElement;
                    MappingClassElement mappingClassElement = ModelValidator.this.getMappingClass(string2);
                    MappingFieldElement mappingFieldElement2 = mappingFieldElement = mappingClassElement != null ? mappingClassElement.getField(string) : null;
                    if (mappingFieldElement != null && (bl2 = ModelValidator.this.isLegalRelationship(persistenceFieldElement)) != ModelValidator.this.isRelationship(mappingFieldElement)) {
                        throw ModelValidator.this.constructFieldException(string, "util.validation.field_type_inconsistent");
                    }
                }
            }
        };
    }

    protected ValidationComponent createFieldConsistencyComponent(final MappingFieldElement mappingFieldElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (mappingFieldElement != null) {
                    PersistenceFieldElement persistenceFieldElement;
                    String string = mappingFieldElement.getName();
                    PersistenceClassElement persistenceClassElement = ModelValidator.this.getPersistenceClass(ModelValidator.this.getClassName());
                    PersistenceFieldElement persistenceFieldElement2 = persistenceFieldElement = persistenceClassElement != null ? persistenceClassElement.getField(string) : null;
                    if (persistenceFieldElement == null) {
                        throw ModelValidator.this.constructFieldException(string, "util.validation.field_model_inconsistent");
                    }
                }
            }
        };
    }

    protected ValidationComponent createFieldPersistenceTypeComponent(final PersistenceFieldElement persistenceFieldElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                String string = persistenceFieldElement.getName();
                String string2 = ModelValidator.this.getClassName();
                boolean bl = ModelValidator.this.isPersistentAllowed(string2, string);
                if (bl) {
                    boolean bl2 = ModelValidator.this.isRelationship(persistenceFieldElement);
                    boolean bl3 = ModelValidator.this.shouldBeRelationship(persistenceFieldElement);
                    if (bl2 && !bl3) {
                        throw ModelValidator.this.constructFieldException(string, "util.validation.field_relationship_not_allowed");
                    }
                    if (!bl2 && bl3) {
                        throw ModelValidator.this.constructFieldException(string, "util.validation.field_type_not_allowed");
                    }
                }
            }
        };
    }

    protected ValidationComponent createFieldCardinalityComponent(final PersistenceFieldElement persistenceFieldElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (ModelValidator.this.isLegalRelationship(persistenceFieldElement)) {
                    ForeignKeyElement foreignKeyElement;
                    RelationshipElement relationshipElement = (RelationshipElement)persistenceFieldElement;
                    String string = persistenceFieldElement.getName();
                    boolean bl = !ModelValidator.this.isCollection(ModelValidator.this.getClassName(), string);
                    int n = bl ? 1 : relationshipElement.getUpperBound();
                    int n2 = relationshipElement.getLowerBound();
                    MappingRelationshipElement mappingRelationshipElement = null;
                    if (n2 < 0 || n <= 0 || n2 > n) {
                        throw ModelValidator.this.constructFieldException(string, "util.validation.cardinality_invalid");
                    }
                    mappingRelationshipElement = ModelValidator.this.getMappingRelationship(relationshipElement);
                    if (bl && n2 != 1 && mappingRelationshipElement != null && !ModelValidator.this.isJoin(mappingRelationshipElement) && (foreignKeyElement = this.getMatchingFK(mappingRelationshipElement)) != null && this.hasNonNullableColumn(foreignKeyElement)) {
                        throw ModelValidator.this.constructFieldException(string, "util.validation.lower_bound_invalid");
                    }
                }
            }

            private boolean hasNonNullableColumn(ForeignKeyElement foreignKeyElement) {
                ColumnElement[] columnElementArray = foreignKeyElement.getLocalColumns();
                int n = columnElementArray != null ? columnElementArray.length : 0;
                int n2 = 0;
                while (n2 < n) {
                    if (!columnElementArray[n2].isNullable()) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            private ForeignKeyElement getMatchingFK(MappingRelationshipElement mappingRelationshipElement) {
                MappingClassElement mappingClassElement = mappingRelationshipElement.getDeclaringClass();
                String string = ModelValidator.this.getSchemaForClass(ModelValidator.this.getClassName());
                ArrayList arrayList = mappingRelationshipElement.getColumns();
                ArrayList arrayList2 = mappingClassElement.getTables();
                if (arrayList2 != null) {
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        String string2 = ((MappingTableElement)iterator.next()).getName();
                        TableElement tableElement = ModelValidator.this.getTable(string2, string);
                        ForeignKeyElement foreignKeyElement = this.getMatchingFK(arrayList, tableElement);
                        if (foreignKeyElement == null) continue;
                        return foreignKeyElement;
                    }
                }
                return null;
            }

            private ForeignKeyElement getMatchingFK(List list, TableElement tableElement) {
                ForeignKeyElement[] foreignKeyElementArray = tableElement != null ? tableElement.getForeignKeys() : null;
                int n = foreignKeyElementArray != null ? foreignKeyElementArray.length : 0;
                int n2 = 0;
                while (n2 < n) {
                    if (this.matchesFK(list, foreignKeyElementArray[n2])) {
                        return foreignKeyElementArray[n2];
                    }
                    ++n2;
                }
                return null;
            }

            private boolean matchesFK(List list, ForeignKeyElement foreignKeyElement) {
                int n;
                ColumnPairElement[] columnPairElementArray = foreignKeyElement.getColumnPairs();
                int n2 = columnPairElementArray != null ? columnPairElementArray.length : 0;
                int n3 = n = list != null ? list.size() : 0;
                if (n2 == n) {
                    int n4 = 0;
                    while (n4 < n2) {
                        String string = NameUtil.getRelativeMemberName(columnPairElementArray[n4].getName().getFullName());
                        if (!list.contains(string)) {
                            return false;
                        }
                        ++n4;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected ValidationComponent createFieldMappingComponent(final PersistenceFieldElement persistenceFieldElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                MappingFieldElement mappingFieldElement;
                String string = persistenceFieldElement.getName();
                MappingClassElement mappingClassElement = ModelValidator.this.getMappingClass(ModelValidator.this.getClassName());
                if (mappingClassElement != null && mappingClassElement.getTables().size() > 0 && ((mappingFieldElement = mappingClassElement.getField(string)) == null || mappingFieldElement.getColumns().size() == 0)) {
                    throw ModelValidator.this.constructFieldException(1, string, "util.validation.field_not_mapped");
                }
            }
        };
    }

    protected ValidationComponent createFieldBlobMappingComponent(final PersistenceFieldElement persistenceFieldElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                boolean bl;
                MappingFieldElement mappingFieldElement;
                String string = ModelValidator.this.getClassName();
                String string2 = persistenceFieldElement.getName();
                MappingClassElement mappingClassElement = ModelValidator.this.getMappingClass(string);
                MappingFieldElement mappingFieldElement2 = mappingFieldElement = mappingClassElement != null ? mappingClassElement.getField(string2) : null;
                if (mappingFieldElement != null && ((bl = persistenceFieldElement.isKey()) || 1 == mappingFieldElement.getFetchGroup()) && this.isMappedToBlob(mappingFieldElement, ModelValidator.this.getSchemaForClass(string))) {
                    throw ModelValidator.this.constructFieldException(string2, bl ? "util.validation.field_key_field_not_allowed" : "util.validation.field_fetch_group_not_allowed");
                }
            }

            private boolean isMappedToBlob(MappingFieldElement mappingFieldElement, String string) {
                if (mappingFieldElement instanceof MappingRelationshipElement) {
                    return this.isMappedToBlob((MappingRelationshipElement)mappingFieldElement, string);
                }
                Iterator iterator = mappingFieldElement.getColumns().iterator();
                while (iterator.hasNext()) {
                    ColumnElement columnElement;
                    String string2 = NameUtil.getAbsoluteMemberName(string, (String)iterator.next());
                    TableElement tableElement = TableElement.forName(NameUtil.getTableName(string2));
                    ColumnElement columnElement2 = columnElement = tableElement != null ? (ColumnElement)tableElement.getMember(DBIdentifier.create(string2)) : null;
                    if (!this.isMappedToBlob(columnElement)) continue;
                    return true;
                }
                return false;
            }

            private boolean isMappedToBlob(MappingRelationshipElement mappingRelationshipElement, String string) {
                ColumnPairElement columnPairElement;
                Iterator iterator = mappingRelationshipElement.getColumns().iterator();
                while (iterator.hasNext()) {
                    columnPairElement = ModelValidator.this.getPair((String)iterator.next(), string);
                    if (!this.isMappedToBlob(columnPairElement)) continue;
                    return true;
                }
                iterator = mappingRelationshipElement.getAssociatedColumns().iterator();
                while (iterator.hasNext()) {
                    columnPairElement = ModelValidator.this.getPair((String)iterator.next(), string);
                    if (!this.isMappedToBlob(columnPairElement)) continue;
                    return true;
                }
                return false;
            }

            private boolean isMappedToBlob(ColumnPairElement columnPairElement) {
                return columnPairElement == null ? false : this.isMappedToBlob(columnPairElement.getLocalColumn()) && this.isMappedToBlob(columnPairElement.getReferencedColumn());
            }

            private boolean isMappedToBlob(ColumnElement columnElement) {
                return columnElement != null && SQLTypeUtil.isBlob(columnElement.getType());
            }
        };
    }

    protected ValidationComponent createCollectionClassComponent(final RelationshipElement relationshipElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                String string;
                String string2 = ModelValidator.this.getClassName();
                if (ModelValidator.this.isCollection(string2, string = relationshipElement.getName())) {
                    Model model = ModelValidator.this.getModel();
                    String string3 = relationshipElement.getCollectionClass();
                    String string4 = model.getFieldType(string2, string);
                    boolean bl = StringHelper.isEmpty(string3);
                    if (!bl && !model.getSupportedCollectionClasses(string4).contains(string3)) {
                        throw ModelValidator.this.constructFieldException(string, "util.validation.collection_class_invalid");
                    }
                }
            }
        };
    }

    protected ValidationComponent createElementClassComponent(final RelationshipElement relationshipElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                String string;
                String string2;
                String string3 = ModelValidator.this.getClassName();
                if (ModelValidator.this.isCollection(string3, string2 = relationshipElement.getName()) && StringHelper.isEmpty(string = relationshipElement.getElementClass())) {
                    MappingFieldElement mappingFieldElement;
                    MappingClassElement mappingClassElement = ModelValidator.this.getMappingClass(string3);
                    MappingFieldElement mappingFieldElement2 = mappingFieldElement = mappingClassElement != null ? mappingClassElement.getField(string2) : null;
                    if (mappingFieldElement != null && mappingFieldElement.getColumns().size() > 0) {
                        throw ModelValidator.this.constructFieldException(string2, "util.validation.element_class_not_found");
                    }
                }
            }
        };
    }

    protected ValidationComponent createInverseFieldComponent(final RelationshipElement relationshipElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                RelationshipElement relationshipElement4;
                Model model = ModelValidator.this.getModel();
                RelationshipElement relationshipElement2 = relationshipElement.getInverseRelationship(model);
                RelationshipElement relationshipElement3 = relationshipElement4 = relationshipElement2 != null ? relationshipElement2.getInverseRelationship(model) : null;
                if (!(relationshipElement2 == null || relationshipElement.equals(relationshipElement4) && relationshipElement4 != null)) {
                    String string = relationshipElement.getName();
                    throw new ModelValidationException(model.getField(ModelValidator.this.getClassName(), string), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.inverse_field_invalid", new Object[]{string, relationshipElement2.getName()}));
                }
            }
        };
    }

    protected ValidationComponent createRelatedClassMatchesComponent(final RelationshipElement relationshipElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                Model model;
                RelationshipElement relationshipElement2;
                String string = relationshipElement.getInverseRelationshipName();
                if (!StringHelper.isEmpty(string) && (relationshipElement2 = relationshipElement.getInverseRelationship(model = ModelValidator.this.getModel())) == null) {
                    Object[] objectArray;
                    String string2;
                    String string3 = ModelValidator.this.getRelatedClass(relationshipElement);
                    String string4 = relationshipElement.getName();
                    String string5 = string2 = string3 != null ? "util.validation.related_class_mismatch" : "util.validation.related_class_not_found";
                    if (string3 != null) {
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = string4;
                        objectArray2[1] = string;
                        objectArray = objectArray2;
                        objectArray2[2] = string3;
                    } else {
                        Object[] objectArray3 = new Object[2];
                        objectArray3[0] = string4;
                        objectArray = objectArray3;
                        objectArray3[1] = string;
                    }
                    Object[] objectArray4 = objectArray;
                    throw new ModelValidationException(model.getField(ModelValidator.this.getClassName(), string4), I18NHelper.getMessage(ModelValidator.this.getMessages(), string2, objectArray4));
                }
            }
        };
    }

    protected ValidationComponent createInverseMappingComponent(final RelationshipElement relationshipElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                Model model = ModelValidator.this.getModel();
                RelationshipElement relationshipElement2 = relationshipElement.getInverseRelationship(model);
                if (relationshipElement2 != null && !this.isInverseMapping(relationshipElement, relationshipElement2)) {
                    String string = relationshipElement.getName();
                    throw new ModelValidationException(model.getField(ModelValidator.this.getClassName(), string), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.inverse_mapping_mismatch", new Object[]{string, relationshipElement2.getName()}));
                }
            }

            private boolean hasMappingRows(MappingRelationshipElement mappingRelationshipElement) {
                if (mappingRelationshipElement != null) {
                    ArrayList arrayList = mappingRelationshipElement.getColumns();
                    return arrayList != null && !arrayList.isEmpty();
                }
                return false;
            }

            private boolean isInverseMapping(RelationshipElement relationshipElement3, RelationshipElement relationshipElement2) {
                MappingRelationshipElement mappingRelationshipElement = ModelValidator.this.getMappingRelationship(relationshipElement3);
                MappingRelationshipElement mappingRelationshipElement2 = ModelValidator.this.getMappingRelationship(relationshipElement2);
                boolean bl = this.hasMappingRows(mappingRelationshipElement);
                boolean bl2 = this.hasMappingRows(mappingRelationshipElement2);
                if (bl && bl2) {
                    boolean bl3 = ModelValidator.this.isJoin(mappingRelationshipElement);
                    if (bl3 == ModelValidator.this.isJoin(mappingRelationshipElement2)) {
                        ArrayList arrayList = mappingRelationshipElement.getColumns();
                        ArrayList arrayList2 = mappingRelationshipElement2.getColumns();
                        return !bl3 ? this.isInverse(arrayList, arrayList2) : this.isInverse(arrayList, mappingRelationshipElement2.getAssociatedColumns()) && this.isInverse(mappingRelationshipElement.getAssociatedColumns(), arrayList2);
                    }
                    return false;
                }
                return bl == bl2;
            }

            private boolean isInverse(ArrayList arrayList, ArrayList arrayList2) {
                int n;
                int n2 = arrayList.size();
                if (n2 == (n = arrayList2.size())) {
                    int n3 = 0;
                    while (n3 < n2) {
                        String string = (String)arrayList.get(n3);
                        String string2 = (String)arrayList2.get(n3);
                        int n4 = string.indexOf(59);
                        int n5 = string2.indexOf(59);
                        if (n4 == -1 || n5 == -1 || !string.substring(0, n4).equals(string2.substring(n5 + 1)) || !string.substring(n4 + 1).equals(string2.substring(0, n5))) {
                            return false;
                        }
                        ++n3;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected ValidationComponent createDefaultFetchGroupComponent(final RelationshipElement relationshipElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                String string = relationshipElement.getName();
                if (ModelValidator.this.getModel().isDefaultFetchGroup(ModelValidator.this.getClassName(), string)) {
                    throw ModelValidator.this.constructFieldException(string, "util.validation.fetch_group_invalid");
                }
            }
        };
    }

    protected ValidationComponent createFieldDefaultFetchGroupComponent(final MappingFieldElement mappingFieldElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (mappingFieldElement != null) {
                    PersistenceFieldElement persistenceFieldElement;
                    String string = mappingFieldElement.getName();
                    PersistenceClassElement persistenceClassElement = ModelValidator.this.getPersistenceClass(ModelValidator.this.getClassName());
                    PersistenceFieldElement persistenceFieldElement2 = persistenceFieldElement = persistenceClassElement != null ? persistenceClassElement.getField(string) : null;
                    if (persistenceFieldElement != null && !persistenceFieldElement.isKey() && 1 == mappingFieldElement.getFetchGroup()) {
                        MappingClassElement mappingClassElement = mappingFieldElement.getDeclaringClass();
                        Iterator iterator = mappingClassElement.getFields().iterator();
                        String string2 = "util.validation.field_fetch_group_invalid";
                        while (iterator.hasNext()) {
                            MappingFieldElement mappingFieldElement2 = (MappingFieldElement)iterator.next();
                            String string3 = ModelValidator.this.getClassName();
                            if (ModelValidator.this.isRelationship(mappingFieldElement2) && !ModelValidator.this.isCollection(string3, mappingFieldElement2.getName())) {
                                ArrayList arrayList = mappingFieldElement.getColumns();
                                Iterator iterator2 = mappingFieldElement2.getColumns().iterator();
                                String string4 = ModelValidator.this.getSchemaForClass(string3);
                                while (iterator2.hasNext()) {
                                    if (this.testColumn(this.getLocalColumn((String)iterator2.next(), string4), arrayList)) continue;
                                    throw ModelValidator.this.constructFieldException(string, string2);
                                }
                                continue;
                            }
                            if (mappingFieldElement2.equals(mappingFieldElement) || !this.isExactMatch(mappingFieldElement.getColumns(), mappingFieldElement2.getColumns())) continue;
                            throw ModelValidator.this.constructFieldException(string, string2);
                        }
                    }
                }
            }

            private boolean testColumn(ColumnElement columnElement, ArrayList arrayList) {
                if (columnElement != null && !this.isPrimaryKeyColumn(columnElement)) {
                    return !arrayList.contains(NameUtil.getRelativeMemberName(columnElement.getName().getFullName()));
                }
                return true;
            }

            private ColumnElement getLocalColumn(String string, String string2) {
                ColumnPairElement columnPairElement = ModelValidator.this.getPair(string, string2);
                return columnPairElement != null ? columnPairElement.getLocalColumn() : null;
            }

            private boolean isPrimaryKeyColumn(ColumnElement columnElement) {
                if (columnElement != null) {
                    UniqueKeyElement uniqueKeyElement = columnElement.getDeclaringTable().getPrimaryKey();
                    return uniqueKeyElement != null && uniqueKeyElement.getColumn(columnElement.getName()) != null;
                }
                return false;
            }

            private boolean isExactMatch(ArrayList arrayList, ArrayList arrayList2) {
                int n = arrayList.size();
                if (n > 0 && n == arrayList2.size()) {
                    return ModelValidator.this.getDifference(arrayList, arrayList2).isEmpty();
                }
                return false;
            }
        };
    }

    protected ValidationComponent createRelatedSchemaMatchesComponent(final String string, final PersistenceFieldElement persistenceFieldElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (string != null) {
                    String string5 = ModelValidator.this.getClassName();
                    String string2 = ModelValidator.this.getSchemaForClass(string5);
                    String string3 = ModelValidator.this.getSchemaForClass(string);
                    if (string2 != null && string3 != null && !string3.equals(string2)) {
                        String string4 = persistenceFieldElement.getName();
                        throw new ModelValidationException(ModelValidator.this.getModel().getField(string5, string4), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.schema_mismatch", new Object[]{string5, string, string4}));
                    }
                }
            }
        };
    }

    protected ValidationComponent createRelatedTableMatchesComponent(final String string, final PersistenceFieldElement persistenceFieldElement, final MappingTableElement mappingTableElement, final String string2) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                ColumnElement columnElement;
                ColumnPairElement columnPairElement = ModelValidator.this.getPair(string2, ModelValidator.this.getSchemaForClass(string));
                if (columnPairElement != null && (columnElement = columnPairElement.getReferencedColumn()) != null && (mappingTableElement == null || mappingTableElement != null && !mappingTableElement.isEqual(columnElement.getDeclaringTable()))) {
                    String string3 = persistenceFieldElement.getName();
                    throw new ModelValidationException(ModelValidator.this.getModel().getField(ModelValidator.this.getClassName(), string3), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.table_mismatch", new Object[]{string, string3, columnElement.getName().getFullName()}));
                }
            }
        };
    }

    protected ValidationComponent createSchemaExistenceComponent(String string) {
        return this.createSchemaExistenceComponent(string, null);
    }

    protected ValidationComponent createSchemaExistenceComponent(final String string, final PersistenceFieldElement persistenceFieldElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                String string2 = ModelValidator.this.getSchemaForClass(string);
                if (string2 != null && SchemaElement.forName(string2) == null) {
                    Object[] objectArray;
                    if (persistenceFieldElement == null) {
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = string2;
                        objectArray = objectArray2;
                        objectArray2[1] = string;
                    } else {
                        Object[] objectArray3 = new Object[3];
                        objectArray3[0] = string2;
                        objectArray3[1] = string;
                        objectArray = objectArray3;
                        objectArray3[2] = persistenceFieldElement;
                    }
                    Object[] objectArray4 = objectArray;
                    throw new ModelValidationException(1, ModelValidator.this.getOffendingObject(persistenceFieldElement), I18NHelper.getMessage(ModelValidator.this.getMessages(), ModelValidator.this.getKey("util.validation.schema_not_found", persistenceFieldElement), objectArray4));
                }
            }
        };
    }

    protected ValidationComponent createPrimaryTableComponent(final MappingTableElement mappingTableElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (mappingTableElement != null) {
                    String string = ModelValidator.this.getClassName();
                    String string2 = ModelValidator.this.getSchemaForClass(string);
                    if (string2 == null) {
                        throw ModelValidator.this.constructClassException(string, null, "util.validation.schema_not_set");
                    }
                    String string3 = mappingTableElement.getName();
                    TableElement tableElement = ModelValidator.this.getTable(string3, string2);
                    if (tableElement != null && tableElement.getPrimaryKey() == null) {
                        throw new ModelValidationException(ModelValidator.this.getOffendingObject(null), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.table_no_primarykey", new Object[]{string3, string}));
                    }
                }
            }
        };
    }

    protected ValidationComponent createTableExistenceComponent(String string) {
        return this.createTableExistenceComponent(string, null);
    }

    protected ValidationComponent createTableExistenceComponent(final String string, final PersistenceFieldElement persistenceFieldElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (string != null) {
                    String string2 = ModelValidator.this.getClassName();
                    boolean bl = persistenceFieldElement == null;
                    TableElement tableElement = ModelValidator.this.getTable(string, ModelValidator.this.getSchemaForClass(bl ? string2 : ModelValidator.this.getRelatedClass(persistenceFieldElement)));
                    if (tableElement == null) {
                        Object[] objectArray;
                        if (bl) {
                            Object[] objectArray2 = new Object[2];
                            objectArray2[0] = string;
                            objectArray = objectArray2;
                            objectArray2[1] = string2;
                        } else {
                            Object[] objectArray3 = new Object[2];
                            objectArray3[0] = string;
                            objectArray = objectArray3;
                            objectArray3[1] = persistenceFieldElement;
                        }
                        Object[] objectArray4 = objectArray;
                        throw new ModelValidationException(1, ModelValidator.this.getOffendingObject(persistenceFieldElement), I18NHelper.getMessage(ModelValidator.this.getMessages(), ModelValidator.this.getKey("util.validation.table_not_found", persistenceFieldElement), objectArray4));
                    }
                }
            }
        };
    }

    protected ValidationComponent createColumnExistenceComponent(String string) {
        return this.createColumnExistenceComponent(string, null);
    }

    protected ValidationComponent createColumnExistenceComponent(final String string, final MappingFieldElement mappingFieldElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (string != null) {
                    boolean bl;
                    String string3 = ModelValidator.this.getClassName();
                    String string2 = NameUtil.getAbsoluteMemberName(ModelValidator.this.getSchemaForClass(string3), string);
                    TableElement tableElement = TableElement.forName(NameUtil.getTableName(string2));
                    boolean bl2 = tableElement != null;
                    DBMemberElement dBMemberElement = bl2 ? tableElement.getMember(DBIdentifier.create(string2)) : null;
                    boolean bl3 = bl = mappingFieldElement == null;
                    if (bl2) {
                        boolean bl4;
                        boolean bl5 = !bl && ModelValidator.this.isRelationship(mappingFieldElement);
                        boolean bl6 = bl4 = dBMemberElement == null;
                        if (!bl5 && bl4) {
                            Object[] objectArray;
                            if (bl) {
                                Object[] objectArray2 = new Object[2];
                                objectArray2[0] = string;
                                objectArray = objectArray2;
                                objectArray2[1] = string3;
                            } else {
                                Object[] objectArray3 = new Object[3];
                                objectArray3[0] = string;
                                objectArray3[1] = mappingFieldElement;
                                objectArray = objectArray3;
                                objectArray3[2] = string3;
                            }
                            Object[] objectArray4 = objectArray;
                            throw new ModelValidationException(1, ModelValidator.this.getOffendingObject(mappingFieldElement), I18NHelper.getMessage(ModelValidator.this.getMessages(), ModelValidator.this.getKey("util.validation.column_not_found", mappingFieldElement), objectArray4));
                        }
                        if (bl5 && (bl4 || !this.isPairComplete(dBMemberElement))) {
                            throw new ModelValidationException(1, ModelValidator.this.getOffendingObject(mappingFieldElement), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.column_invalid", new Object[]{string, mappingFieldElement, string3}));
                        }
                    }
                }
            }

            private boolean isPairComplete(DBMemberElement dBMemberElement) {
                return dBMemberElement instanceof ColumnPairElement && ((ColumnPairElement)dBMemberElement).getLocalColumn() != null && ((ColumnPairElement)dBMemberElement).getReferencedColumn() != null;
            }
        };
    }

    protected ValidationComponent createColumnOverlapComponent(final MappingFieldElement mappingFieldElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                MappingClassElement mappingClassElement = mappingFieldElement.getDeclaringClass();
                Iterator iterator = mappingClassElement.getFields().iterator();
                ArrayList arrayList = mappingFieldElement.getColumns();
                while (iterator.hasNext()) {
                    MappingFieldElement mappingFieldElement2 = (MappingFieldElement)iterator.next();
                    if (mappingFieldElement2.equals(mappingFieldElement) || ModelValidator.this.isRelationship(mappingFieldElement2) || !this.isPartialMatch(arrayList, mappingFieldElement2.getColumns())) continue;
                    String string = mappingFieldElement.getName();
                    throw new ModelValidationException(ModelValidator.this.getModel().getField(ModelValidator.this.getClassName(), string), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.field_mapping_invalid", new Object[]{string, mappingFieldElement2.getName()}));
                }
            }

            private boolean isPartialMatch(ArrayList arrayList, ArrayList arrayList2) {
                int n = arrayList.size();
                if (n > 0) {
                    ArrayList arrayList3 = ModelValidator.this.getDifference(arrayList, arrayList2);
                    return !arrayList3.isEmpty() && arrayList2.size() != arrayList3.size();
                }
                return false;
            }
        };
    }

    protected ValidationComponent createKeyClassComponent(final String string) {
        return new ValidationComponent(){
            private Object keyClass;
            private String keyClassName;

            public void validate() throws ModelValidationException {
                this.keyClassName = this.validateKeyClassName(string);
                this.keyClass = ModelValidator.this.getModel().getClass(this.keyClassName, ModelValidator.this.getClassLoader());
                this.validateClass();
                this.validateConstructor();
                this.validateFields();
                this.validateMethods();
            }

            private void validateClass() throws ModelValidationException {
                Model model = ModelValidator.this.getModel();
                int n = model.getModifiersForClass(this.keyClassName);
                boolean bl = !StringHelper.isEmpty(this.keyClassName);
                boolean bl2 = bl && this.keyClassName.indexOf(36) != -1;
                String string2 = ModelValidator.this.getClassName();
                if (this.keyClass == null) {
                    throw new ModelValidationException(1, model.getClass(string2), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_class_missing", this.keyClassName, string2));
                }
                if (!Modifier.isPublic(n)) {
                    throw new ModelValidationException(this.keyClass, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_class_public", this.keyClassName, string2));
                }
                if (bl2 && !Modifier.isStatic(n)) {
                    throw new ModelValidationException(this.keyClass, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_class_static", this.keyClassName, string2));
                }
            }

            private void validateFields() throws ModelValidationException {
                Object object;
                Object object2;
                String string3 = ModelValidator.this.getClassName();
                Model model = ModelValidator.this.getModel();
                List list = model.getAllFields(this.keyClassName);
                Map map = this.getKeyFields();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    object2 = (String)iterator.next();
                    object = this.getKeyClassField(this.keyClassName, (String)object2);
                    int n = model.getModifiers(object);
                    String string2 = model.getType(object);
                    Object v = map.get(object2);
                    if (Modifier.isStatic(n)) continue;
                    if (!model.isSerializable(object)) {
                        throw new ModelValidationException(object, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_field_serializable", (String)object2, this.keyClassName));
                    }
                    if (!Modifier.isPublic(n)) {
                        throw new ModelValidationException(object, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_field_public", (String)object2, this.keyClassName));
                    }
                    if (v == null) continue;
                    if (!string2.equals(model.getType(v))) {
                        throw new ModelValidationException(object, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_field_type_mismatch", (String)object2, this.keyClassName, string3));
                    }
                    map.remove(object2);
                }
                if (!map.isEmpty()) {
                    object2 = model.getClass(string3);
                    object = StringHelper.arrayToSeparatedList(new ArrayList(map.keySet()));
                    throw new ModelValidationException(object2, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_field_missing", string3, this.keyClassName, (String)object));
                }
            }

            private void validateConstructor() throws ModelValidationException {
                Model model = ModelValidator.this.getModel();
                boolean bl = model.hasConstructor(this.keyClassName);
                Object object = model.getConstructor(this.keyClassName, Model.NO_ARGS);
                int n = model.getModifiers(object);
                if (bl && (object == null || !Modifier.isPublic(n))) {
                    throw new ModelValidationException(this.keyClass, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_class_constructor", this.keyClassName, ModelValidator.this.getClassName()));
                }
            }

            private void validateMethods() throws ModelValidationException {
                Model model = ModelValidator.this.getModel();
                Object object = model.getMethod(this.keyClassName, "equals", Model.EQUALS_ARGS);
                Object object2 = model.getMethod(this.keyClassName, "hashCode", Model.NO_ARGS);
                if (!ModelValidator.this.matchesMethod(object, 1, "boolean")) {
                    throw new ModelValidationException(this.keyClass, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_class_equals", this.keyClassName, ModelValidator.this.getClassName()));
                }
                if (!ModelValidator.this.matchesMethod(object2, 1, "int")) {
                    throw new ModelValidationException(this.keyClass, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_class_hashcode", this.keyClassName, ModelValidator.this.getClassName()));
                }
            }

            private String validateKeyClassName(String string4) throws ModelValidationException {
                boolean bl;
                boolean bl2;
                String string2 = ModelValidator.this.getClassName();
                Model model = ModelValidator.this.getModel();
                boolean bl3 = bl2 = !StringHelper.isEmpty(string4);
                if (!bl2) {
                    throw new ModelValidationException(1, model.getClass(string2), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_class_unset", string2));
                }
                boolean bl4 = (string4 = string4.trim()).startsWith(string2);
                String string3 = bl4 ? string4.substring(string2.length()) : string4;
                boolean bl5 = bl = string3.equalsIgnoreCase(".OID") || string3.equalsIgnoreCase("$OID");
                if (!bl4 || !string3.equalsIgnoreCase("Key") && !bl) {
                    Object object = ModelValidator.this.getModel().getClass(string2);
                    throw new ModelValidationException(object, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_class_invalid", string4, string2));
                }
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer(string4);
                    stringBuffer.setCharAt(string4.length() - 4, '$');
                    return stringBuffer.toString();
                }
                return string4;
            }

            private Object getKeyClassField(String string3, String string2) {
                Model model = ModelValidator.this.getModel();
                Object object = model.getField(string3, string2);
                if (object == null) {
                    object = model.getInheritedField(string3, string2);
                }
                return object;
            }

            private Map getKeyFields() {
                Model model = ModelValidator.this.getModel();
                String string3 = ModelValidator.this.getClassName();
                PersistenceClassElement persistenceClassElement = model.getPersistenceClass(string3);
                PersistenceFieldElement[] persistenceFieldElementArray = persistenceClassElement.getFields();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                if (persistenceFieldElementArray != null) {
                    int n = 0;
                    while (n < persistenceFieldElementArray.length) {
                        PersistenceFieldElement persistenceFieldElement = persistenceFieldElementArray[n];
                        if (persistenceFieldElement.isKey()) {
                            String string2 = persistenceFieldElement.getName();
                            hashMap.put(string2, model.getField(string3, string2));
                        }
                        ++n;
                    }
                }
                return hashMap;
            }
        };
    }

    protected ValidationComponent createSerializableClassComponent(final String string) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                Model model = ModelValidator.this.getModel();
                Object object = null;
                if (string == null) {
                    return;
                }
                object = model.getClass(string);
                if (object == null) {
                    return;
                }
                if (model.implementsInterface(object, "java.io.Serializable")) {
                    Object object2 = model.getMethod(string, "readObject", Model.READ_OBJECT_ARGS);
                    if (!ModelValidator.this.matchesMethod(object2, 2, "void")) {
                        throw new ModelValidationException(object, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.class_readobject", string));
                    }
                    Object object3 = model.getMethod(string, "writeObject", Model.WRITE_OBJECT_ARGS);
                    if (!ModelValidator.this.matchesMethod(object3, 2, "void")) {
                        throw new ModelValidationException(object, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.class_writeobject", string));
                    }
                }
            }
        };
    }

    protected ValidationComponent createClassMappingComponent(final PersistenceClassElement persistenceClassElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                PersistenceFieldElement[] persistenceFieldElementArray = persistenceClassElement.getFields();
                String string = ModelValidator.this.getClassName();
                if (persistenceFieldElementArray == null || persistenceFieldElementArray.length == 0) {
                    throw ModelValidator.this.constructClassException(1, string, null, "util.validation.class_no_fields");
                }
                MappingClassElement mappingClassElement = ModelValidator.this.getMappingClass(string);
                if (mappingClassElement == null || mappingClassElement.getTables().size() == 0) {
                    throw ModelValidator.this.constructClassException(1, string, null, "util.validation.class_not_mapped");
                }
            }
        };
    }

    protected ValidationComponent createKeyColumnMappingComponent(final PersistenceClassElement persistenceClassElement) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                String string;
                TableElement tableElement;
                List list;
                ArrayList arrayList;
                String string2 = ModelValidator.this.getClassName();
                MappingClassElement mappingClassElement = ModelValidator.this.getMappingClass(string2);
                if (mappingClassElement != null && (arrayList = mappingClassElement.getTables()).size() > 0 && (list = this.getUnmappedColumnNames((tableElement = ModelValidator.this.getTable(string = ((MappingTableElement)arrayList.get(0)).getName(), ModelValidator.this.getSchemaForClass(string2))) != null ? tableElement.getPrimaryKey() : null, mappingClassElement)) != null && list.size() > 0) {
                    throw new ModelValidationException(1, ModelValidator.this.getOffendingObject(null), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.class_key_column_missing", string2, string, StringHelper.arrayToSeparatedList(list)));
                }
            }

            private List getUnmappedColumnNames(KeyElement keyElement, MappingClassElement mappingClassElement) {
                List list = null;
                if (keyElement != null) {
                    int n;
                    ColumnElement[] columnElementArray = keyElement.getColumns();
                    int n2 = n = columnElementArray != null ? columnElementArray.length : 0;
                    if (n > 0) {
                        ArrayList arrayList = mappingClassElement.getFields();
                        Iterator iterator = arrayList.iterator();
                        list = this.getRelativeColumnNames(columnElementArray);
                        while (iterator.hasNext()) {
                            MappingFieldElement mappingFieldElement = (MappingFieldElement)iterator.next();
                            if (!this.isKeyField(mappingFieldElement)) continue;
                            list.removeAll(mappingFieldElement.getColumns());
                        }
                    }
                }
                return list;
            }

            private List getRelativeColumnNames(ColumnElement[] columnElementArray) {
                int n = columnElementArray != null ? columnElementArray.length : 0;
                ArrayList<String> arrayList = new ArrayList<String>(n);
                int n2 = 0;
                while (n2 < n) {
                    arrayList.add(NameUtil.getRelativeMemberName(columnElementArray[n2].getName().getFullName()));
                    ++n2;
                }
                return arrayList;
            }

            private boolean isKeyField(MappingFieldElement mappingFieldElement) {
                PersistenceFieldElement persistenceFieldElement = persistenceClassElement.getField(mappingFieldElement.getName());
                return persistenceFieldElement != null && persistenceFieldElement.isKey();
            }
        };
    }

    private Object getOffendingObject(Object object) {
        return object == null ? this.getModel().getClass(this.getClassName(), this.getClassLoader()) : this.getModel().getField(this.getClassName(), object.toString());
    }

    private String getKey(String string, Object object) {
        return object == null ? string : string + "_related";
    }

    private Object[] getArguments(String string, Object object) {
        Object[] objectArray;
        if (object == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = string;
            objectArray = objectArray3;
            objectArray3[1] = object;
        }
        return objectArray;
    }

    private ModelValidationException constructClassException(String string, Object object, String string2) {
        return this.constructClassException(0, string, object, string2);
    }

    private ModelValidationException constructClassException(int n, String string, Object object, String string2) {
        return new ModelValidationException(n, this.getOffendingObject(object), I18NHelper.getMessage(this.getMessages(), this.getKey(string2, object), this.getArguments(string, object)));
    }

    private ModelValidationException constructFieldException(String string, String string2) {
        return this.constructFieldException(0, string, string2);
    }

    private ModelValidationException constructFieldException(int n, String string, String string2) {
        return new ModelValidationException(n, this.getModel().getField(this.getClassName(), string), I18NHelper.getMessage(this.getMessages(), string2, string));
    }

    private boolean matchesMethod(Object object, int n, String string) {
        Model model = this.getModel();
        return object != null && model.getModifiers(object) == n && string.equals(model.getType(object));
    }

    private boolean isRelationship(Object object) {
        return object instanceof RelationshipElement || object instanceof MappingRelationshipElement;
    }

    private boolean shouldBeRelationship(PersistenceFieldElement persistenceFieldElement) {
        Model model = this.getModel();
        String string = model.getFieldType(this.getClassName(), persistenceFieldElement.getName());
        return this.isPersistent(string) || model.isCollection(string);
    }

    private boolean isLegalRelationship(PersistenceFieldElement persistenceFieldElement) {
        return this.isRelationship(persistenceFieldElement) ? this.shouldBeRelationship(persistenceFieldElement) : false;
    }

    private boolean isCollection(String string, String string2) {
        Model model = this.getModel();
        return model.isCollection(model.getFieldType(string, string2));
    }

    private String getRelatedClass(PersistenceFieldElement persistenceFieldElement) {
        if (this.isLegalRelationship(persistenceFieldElement)) {
            return this.getModel().getRelatedClass((RelationshipElement)persistenceFieldElement);
        }
        return null;
    }

    private String getSchemaForClass(String string) {
        MappingClassElement mappingClassElement = this.getMappingClass(string);
        String string2 = mappingClassElement != null ? mappingClassElement.getDatabaseRoot() : null;
        return StringHelper.isEmpty(string2) ? null : string2.trim();
    }

    private MappingRelationshipElement getMappingRelationship(RelationshipElement relationshipElement) {
        MappingFieldElement mappingFieldElement;
        MappingClassElement mappingClassElement;
        MappingRelationshipElement mappingRelationshipElement = null;
        if (relationshipElement != null && (mappingClassElement = this.getMappingClass(relationshipElement.getDeclaringClass().getName())) != null && this.isRelationship(mappingFieldElement = mappingClassElement.getField(relationshipElement.getName()))) {
            mappingRelationshipElement = (MappingRelationshipElement)mappingFieldElement;
        }
        return mappingRelationshipElement;
    }

    private boolean isJoin(MappingRelationshipElement mappingRelationshipElement) {
        if (mappingRelationshipElement != null) {
            ArrayList arrayList = mappingRelationshipElement.getAssociatedColumns();
            return arrayList != null && !arrayList.isEmpty();
        }
        return false;
    }

    private MappingReferenceKeyElement findReferenceKey(MappingTableElement mappingTableElement, MappingTableElement mappingTableElement2) {
        if (mappingTableElement != null && mappingTableElement2 != null) {
            Iterator iterator = mappingTableElement.getReferencingKeys().iterator();
            while (iterator.hasNext()) {
                MappingReferenceKeyElement mappingReferenceKeyElement = (MappingReferenceKeyElement)iterator.next();
                if (!mappingReferenceKeyElement.getTable().equals(mappingTableElement2)) continue;
                return mappingReferenceKeyElement;
            }
        }
        return null;
    }

    private TableElement getTable(String string, String string2) {
        String string3 = NameUtil.getAbsoluteTableName(string2, string);
        return TableElement.forName(string3);
    }

    private ColumnPairElement getPair(String string, String string2) {
        String string3 = NameUtil.getAbsoluteMemberName(string2, string);
        TableElement tableElement = TableElement.forName(NameUtil.getTableName(string3));
        DBMemberElement dBMemberElement = tableElement == null ? null : tableElement.getMember(DBIdentifier.create(string3));
        return dBMemberElement instanceof ColumnPairElement ? (ColumnPairElement)dBMemberElement : null;
    }

    private ArrayList getDifference(ArrayList arrayList, ArrayList arrayList2) {
        ArrayList arrayList3 = new ArrayList(arrayList2);
        arrayList3.removeAll(arrayList);
        return arrayList3;
    }

    private MappingClassElement getMappingClass(String string) {
        return this.getModel().getMappingClass(string, this.getClassLoader());
    }

    private PersistenceClassElement getPersistenceClass(String string) {
        return this.getModel().getPersistenceClass(string, this.getClassLoader());
    }

    private boolean isPersistent(String string) {
        return this.getModel().isPersistent(string, this.getClassLoader());
    }

    private boolean isPersistentAllowed(String string, String string2) {
        return this.getModel().isPersistentAllowed(string, this.getClassLoader(), string2);
    }

    static abstract class ValidationComponent {
        public abstract void validate() throws ModelValidationException;
    }
}

