/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.jdo;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.spi.persistence.utility.I18NHelper;

public class RelationshipElement
extends PersistenceFieldElement {
    public static final int NONE_ACTION = 0;
    public static final int NULLIFY_ACTION = 1;
    public static final int RESTRICT_ACTION = 2;
    public static final int CASCADE_ACTION = 3;
    public static final int AGGREGATE_ACTION = 4;

    public RelationshipElement() {
        this(null, null);
    }

    public RelationshipElement(Impl impl, PersistenceClassElement persistenceClassElement) {
        super(impl, persistenceClassElement);
    }

    final Impl getRelationshipImpl() {
        return (Impl)this.getImpl();
    }

    public int getUpdateAction() {
        return this.getRelationshipImpl().getUpdateAction();
    }

    public void setUpdateAction(int n) throws ModelException {
        if (n < 0 || n > 4) {
            throw new ModelException(I18NHelper.getMessage(PersistenceElement.getMessages(), "jdo.relationship.update_action_invalid", n));
        }
        this.getRelationshipImpl().setUpdateAction(n);
    }

    public int getDeleteAction() {
        return this.getRelationshipImpl().getDeleteAction();
    }

    public void setDeleteAction(int n) throws ModelException {
        if (n < 0 || n > 4) {
            throw new ModelException(I18NHelper.getMessage(PersistenceElement.getMessages(), "jdo.relationship.delete_action_invalid", n));
        }
        this.getRelationshipImpl().setDeleteAction(n);
    }

    public boolean isPrefetch() {
        return this.getRelationshipImpl().isPrefetch();
    }

    public void setPrefetch(boolean bl) throws ModelException {
        this.getRelationshipImpl().setPrefetch(bl);
    }

    public int getLowerBound() {
        return this.getRelationshipImpl().getLowerBound();
    }

    public void setLowerBound(int n) throws ModelException {
        if (n > this.getUpperBound() || n < 0) {
            throw new ModelException(I18NHelper.getMessage(PersistenceElement.getMessages(), "jdo.relationship.lower_cardinality_invalid"));
        }
        this.getRelationshipImpl().setLowerBound(n);
    }

    public int getUpperBound() {
        return this.getRelationshipImpl().getUpperBound();
    }

    public void setUpperBound(int n) throws ModelException {
        if (n < this.getLowerBound() || n <= 0) {
            throw new ModelException(I18NHelper.getMessage(PersistenceElement.getMessages(), "jdo.relationship.upper_cardinality_invalid"));
        }
        this.getRelationshipImpl().setUpperBound(n);
    }

    public String getCollectionClass() {
        return this.getRelationshipImpl().getCollectionClass();
    }

    public void setCollectionClass(String string) throws ModelException {
        this.getRelationshipImpl().setCollectionClass(string);
    }

    public String getElementClass() {
        return this.getRelationshipImpl().getElementClass();
    }

    public void setElementClass(String string) throws ModelException {
        this.getRelationshipImpl().setElementClass(string);
    }

    public String getInverseRelationshipName() {
        return this.getRelationshipImpl().getInverseRelationshipName();
    }

    public RelationshipElement getInverseRelationship(Model model) {
        PersistenceClassElement persistenceClassElement;
        String string;
        String string2 = this.getInverseRelationshipName();
        RelationshipElement relationshipElement = null;
        if (model != null && string2 != null && (string = model.getRelatedClass(this)) != null && (persistenceClassElement = model.getPersistenceClass(string)) != null) {
            relationshipElement = persistenceClassElement.getRelationship(string2);
        }
        return relationshipElement;
    }

    public void setInverseRelationship(RelationshipElement relationshipElement, Model model) throws ModelException {
        RelationshipElement relationshipElement2 = this.getInverseRelationship(model);
        if (relationshipElement2 != relationshipElement || relationshipElement == null && this.getInverseRelationshipName() != null) {
            RelationshipElement relationshipElement3;
            if (relationshipElement2 != null && this.equals(relationshipElement3 = relationshipElement2.getInverseRelationship(model))) {
                relationshipElement2.changeInverseRelationship(null);
            }
            this.changeInverseRelationship(relationshipElement);
            if (relationshipElement != null) {
                relationshipElement.changeInverseRelationship(this);
            }
        }
    }

    public void changeInverseRelationship(RelationshipElement relationshipElement) throws ModelException {
        this.getRelationshipImpl().changeInverseRelationship(relationshipElement);
    }

    public static interface Impl
    extends PersistenceFieldElement.Impl {
        public int getUpdateAction();

        public void setUpdateAction(int var1) throws ModelException;

        public int getDeleteAction();

        public void setDeleteAction(int var1) throws ModelException;

        public boolean isPrefetch();

        public void setPrefetch(boolean var1) throws ModelException;

        public int getLowerBound();

        public void setLowerBound(int var1) throws ModelException;

        public int getUpperBound();

        public void setUpperBound(int var1) throws ModelException;

        public String getCollectionClass();

        public void setCollectionClass(String var1) throws ModelException;

        public String getElementClass();

        public void setElementClass(String var1) throws ModelException;

        public String getInverseRelationshipName();

        public void changeInverseRelationship(RelationshipElement var1) throws ModelException;
    }
}

