/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model;

import com.sun.forte4j.modules.dbmodel.SchemaElement;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RuntimeModel
extends Model {
    private static final String CLASS_EXTENSION = "class";
    private static final String JAVA_PACKAGE = "java.";
    private static final String SERIALIZABLE = "java.io.Serializable";
    private HashMap classLoaders = new HashMap();
    static /* synthetic */ Class class$java$lang$Object;

    protected RuntimeModel() {
    }

    public boolean isInterface(String string) {
        Class clazz = (Class)this.getClass(string);
        return clazz != null ? clazz.isInterface() : false;
    }

    protected BufferedInputStream getInputStreamForResource(String string, ClassLoader classLoader, String string2) {
        InputStream inputStream = string != null ? classLoader.getResourceAsStream(string2) : null;
        BufferedInputStream bufferedInputStream = null;
        bufferedInputStream = inputStream != null && !(inputStream instanceof BufferedInputStream) ? new BufferedInputStream(inputStream) : (BufferedInputStream)inputStream;
        return bufferedInputStream;
    }

    private String getShortClassName(String string) {
        return string.substring(string.lastIndexOf(46) + 1, string.length());
    }

    /*
     * Unable to fully structure code
     */
    protected String findPenultimateSuperclass(String var1_1) {
        var2_2 = (Class<T>)this.getClass(var1_1);
        var3_3 = RuntimeModel.class$java$lang$Object == null ? (RuntimeModel.class$java$lang$Object = RuntimeModel.class$("java.lang.Object")) : RuntimeModel.class$java$lang$Object;
        var4_4 = null;
        if (var2_2 != null) ** GOTO lbl8
        return var1_1;
        while (!var4_4.equals(var3_3)) {
            var2_2 = var4_4;
lbl8:
            // 2 sources

            if ((var4_4 = var2_2.getSuperclass()) != null) continue;
        }
        return var2_2.getName();
    }

    protected String getSuperclass(String string) {
        Class clazz = (Class)this.getClass(string);
        if (clazz != null) {
            clazz = clazz.getSuperclass();
        }
        return clazz != null ? clazz.getName() : null;
    }

    public MappingClassElement getMappingClass(String string, ClassLoader classLoader) {
        MappingClassElement mappingClassElement = null;
        mappingClassElement = super.getMappingClass(string, classLoader = this.findClassLoader(string, classLoader));
        if (mappingClassElement != null && classLoader != null) {
            SchemaElement.forName(mappingClassElement.getDatabaseRoot(), classLoader);
        }
        return mappingClassElement;
    }

    public Map getClassLoaderCache() {
        return Collections.unmodifiableMap(this.classLoaders);
    }

    protected BufferedOutputStream createFile(String string, String string2, String string3) throws IOException {
        Class clazz;
        char c = '.';
        File file = this.getFile(string, string2 + c + string3);
        if (file == null && (clazz = (Class)this.getClass(string)) != null) {
            String string4 = clazz.getResource(this.getShortClassName(string) + c + CLASS_EXTENSION).getFile();
            int n = string4.lastIndexOf(c) + 1;
            file = new File(string4.substring(0, n) + string3);
            file.createNewFile();
        }
        return file != null ? new BufferedOutputStream(new FileOutputStream(file)) : null;
    }

    protected void deleteFile(String string, String string2) throws IOException {
        File file = this.getFile(string, string2);
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    protected File getFile(String string, String string2) throws IOException {
        Class clazz = (Class)this.getClass(string);
        if (clazz != null) {
            URL uRL = clazz.getResource(string2.substring(string2.lastIndexOf(this.getShortClassName(string))));
            return uRL != null ? new File(uRL.getFile()) : null;
        }
        return null;
    }

    public Object getClass(String string, ClassLoader classLoader) {
        if (string == null) {
            return null;
        }
        try {
            classLoader = this.findClassLoader(string, classLoader);
            return Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected ClassLoader findClassLoader(String string, ClassLoader classLoader) throws IllegalArgumentException {
        ClassLoader classLoader2 = null;
        if (string == null) {
            return null;
        }
        if (string.startsWith(JAVA_PACKAGE)) {
            return this.getClass().getClassLoader();
        }
        classLoader2 = (ClassLoader)this.classLoaders.get(string);
        if (classLoader == null) {
            classLoader = classLoader2 != null ? classLoader2 : this.getClass().getClassLoader();
        } else if (classLoader2 == null) {
            this.classLoaders.put(string, classLoader);
        } else if (classLoader != classLoader2) {
            Class<?> clazz = null;
            Class<?> clazz2 = null;
            try {
                String string2 = System.getProperty("com.sun.jdo.api.persistence.model.multipleClassLoaders", "error");
                clazz = Class.forName(string, true, classLoader);
                clazz2 = Class.forName(string, true, classLoader2);
                if (clazz.getClassLoader() == clazz2.getClassLoader()) {
                    return classLoader2;
                }
                if ("ignore".equals(string2)) {
                    return classLoader2;
                }
                if ("reload".equals(string2)) {
                    this.removeFromCaches(string);
                    this.classLoaders.put(string, classLoader);
                    return classLoader;
                }
                throw new IllegalArgumentException(I18NHelper.getMessage(Model.getMessages(), "classloader.multiple", string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (clazz != null && clazz2 == null) {
                    this.classLoaders.put(string, classLoader);
                }
            }
        }
        return classLoader;
    }

    public boolean implementsInterface(Object object, String string) {
        Class clazz = (Class)this.getClass(string);
        if (object == null || !(object instanceof Class) || clazz == null) {
            return false;
        }
        return clazz.isAssignableFrom((Class)object);
    }

    public boolean hasConstructor(String string) {
        final Class clazz = (Class)this.getClass(string);
        if (clazz != null) {
            Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(clazz.getDeclaredConstructors().length != 0);
                }
            });
            return bl;
        }
        return false;
    }

    public Object getConstructor(String string, String[] stringArray) {
        final Class clazz = (Class)this.getClass(string);
        if (clazz != null) {
            final Class[] classArray = this.getTypesForNames(stringArray);
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return clazz.getDeclaredConstructor(classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        return null;
                    }
                }
            });
        }
        return null;
    }

    public Object getMethod(String string, final String string2, String[] stringArray) {
        final Class clazz = (Class)this.getClass(string);
        if (clazz != null) {
            final Class[] classArray = this.getTypesForNames(stringArray);
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return clazz.getDeclaredMethod(string2, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        return null;
                    }
                }
            });
        }
        return null;
    }

    public String getType(Object object) {
        return this.getNameForType(this.getTypeObject(object));
    }

    public List getFields(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        final Class clazz = (Class)this.getClass(string);
        if (clazz != null) {
            Field[] fieldArray = (Field[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return clazz.getDeclaredFields();
                }
            });
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(fieldArray[n2].getName());
                ++n2;
            }
        }
        return arrayList;
    }

    public Object getField(String string, final String string2) {
        final Class clazz = (Class)this.getClass(string);
        if (clazz != null) {
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return clazz.getDeclaredField(string2);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        return null;
                    }
                }
            });
        }
        return null;
    }

    public boolean isSerializable(Object object) {
        Class<?> clazz = this.getTypeObject(object);
        while (clazz != null && clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz != null ? clazz.isPrimitive() || this.implementsInterface(clazz, SERIALIZABLE) : false;
    }

    public boolean isArray(String string, String string2) {
        Object object = this.getField(string, string2);
        return object != null ? this.getTypeObject(object).isArray() : false;
    }

    public int getModifiers(Object object) {
        int n = 0;
        if (object != null) {
            if (object instanceof Class) {
                n = ((Class)object).getModifiers();
            } else if (object instanceof Member) {
                n = ((Member)object).getModifiers();
            }
        }
        return n;
    }

    protected Class getTypeObject(Object object) {
        Class<?> clazz = null;
        if (object != null) {
            if (object instanceof Field) {
                clazz = ((Field)object).getType();
            } else if (object instanceof Method) {
                clazz = ((Method)object).getReturnType();
            }
        }
        return clazz;
    }

    private String getNameForType(Class clazz) {
        String string = null;
        if (clazz != null) {
            string = clazz.isArray() ? this.getNameForType(clazz.getComponentType()) + "[]" : clazz.getName();
        }
        return string;
    }

    private Class[] getTypesForNames(String[] stringArray) {
        Class[] classArray = new Class[stringArray.length];
        int n = 0;
        while (n < classArray.length) {
            classArray[n] = this.getTypeForName(stringArray[n]);
            ++n;
        }
        return classArray;
    }

    private Class getTypeForName(String string) {
        Class clazz = JavaTypeHelper.getPrimitiveClass(string);
        if (clazz == null) {
            clazz = (Class)this.getClass(string);
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

