/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte4j.modules.dbmodel;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.ColumnElementHolder;
import com.sun.forte4j.modules.dbmodel.ColumnPairElement;
import com.sun.forte4j.modules.dbmodel.ColumnPairElementHolder;
import com.sun.forte4j.modules.dbmodel.DBElement;
import com.sun.forte4j.modules.dbmodel.DBException;
import com.sun.forte4j.modules.dbmodel.DBIdentifier;
import com.sun.forte4j.modules.dbmodel.DBMemberElement;
import com.sun.forte4j.modules.dbmodel.DBMemoryCollection;
import com.sun.forte4j.modules.dbmodel.ForeignKeyElement;
import com.sun.forte4j.modules.dbmodel.IndexElement;
import com.sun.forte4j.modules.dbmodel.KeyElement;
import com.sun.forte4j.modules.dbmodel.SchemaElement;
import com.sun.forte4j.modules.dbmodel.UniqueKeyElement;
import java.util.ArrayList;

public final class TableElement
extends DBElement
implements ColumnElementHolder,
ColumnPairElementHolder {
    public static final boolean TABLE = true;
    public static final boolean VIEW = false;
    private transient SchemaElement declaringSchema;
    static /* synthetic */ Class class$com$sun$forte4j$modules$dbmodel$ForeignKeyElement;
    static /* synthetic */ Class class$com$sun$forte4j$modules$dbmodel$UniqueKeyElement;

    public TableElement() {
        this(new Memory(), null);
    }

    public TableElement(Impl impl, SchemaElement schemaElement) {
        super(impl);
        this.declaringSchema = schemaElement;
    }

    final Impl getTableImpl() {
        return (Impl)this.getElementImpl();
    }

    public static TableElement forName(String string, SchemaElement schemaElement) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return null;
        }
        string = string.substring(n + 1);
        TableElement[] tableElementArray = schemaElement.getTables();
        int n2 = 0;
        while (n2 < tableElementArray.length) {
            if (tableElementArray[n2].getName().getName().trim().equals(string)) {
                return tableElementArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public static TableElement forName(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                System.out.println(DBElement.bundle.getString("FullyQualifiedName"));
            }
            return null;
        }
        SchemaElement schemaElement = SchemaElement.forName(string.substring(0, n));
        if (schemaElement == null) {
            return null;
        }
        return TableElement.forName(string, schemaElement);
    }

    public void setTableOrView(boolean bl) throws DBException {
        this.getTableImpl().setTableOrView(bl);
    }

    public boolean isTableOrView() {
        return this.getTableImpl().isTableOrView();
    }

    public boolean isTable() {
        return this.getTableImpl().isTableOrView();
    }

    public boolean isView() {
        return !this.getTableImpl().isTableOrView();
    }

    public final SchemaElement getDeclaringSchema() {
        return this.declaringSchema;
    }

    public final void setDeclaringSchema(SchemaElement schemaElement) {
        if (this.declaringSchema == null) {
            this.declaringSchema = schemaElement;
        }
    }

    public void addColumn(ColumnElement columnElement) throws DBException {
        this.addColumns(new ColumnElement[]{columnElement});
    }

    public void addColumns(ColumnElement[] columnElementArray) throws DBException {
        int n = 0;
        while (n < columnElementArray.length) {
            if (this.getColumn(columnElementArray[n].getName()) != null) {
                this.throwAddException("FMT_EXC_AddColumn", columnElementArray[n]);
            }
            if (columnElementArray[n].getDeclaringTable() == null) {
                columnElementArray[n].setDeclaringTable(this);
            }
            ++n;
        }
        this.getTableImpl().changeColumns(columnElementArray, 1);
    }

    public void removeColumn(ColumnElement columnElement) throws DBException {
        this.removeColumns(new ColumnElement[]{columnElement});
    }

    public void removeColumns(ColumnElement[] columnElementArray) throws DBException {
        this.getTableImpl().changeColumns(columnElementArray, -1);
    }

    public void setColumns(ColumnElement[] columnElementArray) throws DBException {
        this.getTableImpl().changeColumns(columnElementArray, 0);
    }

    public ColumnElement[] getColumns() {
        return this.getTableImpl().getColumns();
    }

    public ColumnElement getColumn(DBIdentifier dBIdentifier) {
        return this.getTableImpl().getColumn(dBIdentifier);
    }

    private ArrayList getColumns(Class clazz) {
        ColumnElement[] columnElementArray = this.getColumns();
        int n = columnElementArray.length;
        ArrayList<ColumnElement> arrayList = new ArrayList<ColumnElement>(n);
        int n2 = 0;
        while (n2 < n) {
            ColumnElement columnElement = columnElementArray[n2];
            if (clazz.isInstance(columnElement)) {
                arrayList.add(columnElement);
            }
            ++n2;
        }
        return arrayList;
    }

    public void addIndex(IndexElement indexElement) throws DBException {
        this.addIndexes(new IndexElement[]{indexElement});
    }

    public void addIndexes(IndexElement[] indexElementArray) throws DBException {
        int n = 0;
        while (n < indexElementArray.length) {
            if (this.getIndex(indexElementArray[n].getName()) != null) {
                this.throwAddException("FMT_EXC_AddColumn", indexElementArray[n]);
            }
            if (indexElementArray[n].getDeclaringTable() == null) {
                indexElementArray[n].setDeclaringTable(this);
            }
            ++n;
        }
        this.getTableImpl().changeIndexes(indexElementArray, 1);
    }

    public void removeIndex(IndexElement indexElement) throws DBException {
        this.removeIndexes(new IndexElement[]{indexElement});
    }

    public void removeIndexes(IndexElement[] indexElementArray) throws DBException {
        this.getTableImpl().changeIndexes(indexElementArray, -1);
    }

    public void setIndexes(IndexElement[] indexElementArray) throws DBException {
        this.getTableImpl().changeIndexes(indexElementArray, 0);
    }

    public IndexElement[] getIndexes() {
        return this.getTableImpl().getIndexes();
    }

    public IndexElement getIndex(DBIdentifier dBIdentifier) {
        return this.getTableImpl().getIndex(dBIdentifier);
    }

    public void addKey(KeyElement keyElement) throws DBException {
        this.addKeys(new KeyElement[]{keyElement});
    }

    public void addKeys(KeyElement[] keyElementArray) throws DBException {
        int n = 0;
        while (n < keyElementArray.length) {
            if (this.getKey(keyElementArray[n].getName()) != null) {
                this.throwAddException("FMT_EXC_AddColumn", keyElementArray[n]);
            }
            if (keyElementArray[n].getDeclaringTable() == null) {
                keyElementArray[n].setDeclaringTable(this);
            }
            if (keyElementArray[n] instanceof UniqueKeyElement && ((UniqueKeyElement)keyElementArray[n]).getAssociatedIndex() == null) {
                IndexElement indexElement = new IndexElement();
                try {
                    indexElement.setName(keyElementArray[n].getName());
                    indexElement.setColumns(keyElementArray[n].getColumns());
                    this.addIndex(indexElement);
                }
                catch (DBException dBException) {
                    dBException.printStackTrace();
                }
                ((UniqueKeyElement)keyElementArray[n]).setAssociatedIndex(indexElement);
            }
            ++n;
        }
        this.getTableImpl().changeKeys(keyElementArray, 1);
    }

    public void removeKey(KeyElement keyElement) throws DBException {
        this.removeKeys(new KeyElement[]{keyElement});
    }

    public void removeKeys(KeyElement[] keyElementArray) throws DBException {
        this.getTableImpl().changeKeys(keyElementArray, -1);
    }

    public void setKeys(KeyElement[] keyElementArray) throws DBException {
        this.getTableImpl().changeKeys(keyElementArray, 0);
    }

    public KeyElement[] getKeys() {
        return this.getTableImpl().getKeys();
    }

    public KeyElement getKey(DBIdentifier dBIdentifier) {
        return this.getTableImpl().getKey(dBIdentifier);
    }

    private ArrayList getKeys(Class clazz) {
        KeyElement[] keyElementArray = this.getKeys();
        if (keyElementArray == null) {
            return null;
        }
        int n = keyElementArray.length;
        ArrayList<KeyElement> arrayList = new ArrayList<KeyElement>(n);
        int n2 = 0;
        while (n2 < n) {
            KeyElement keyElement = keyElementArray[n2];
            if (clazz.isInstance(keyElement)) {
                arrayList.add(keyElement);
            }
            ++n2;
        }
        return arrayList;
    }

    public ForeignKeyElement[] getForeignKeys() {
        ArrayList arrayList = this.getKeys(class$com$sun$forte4j$modules$dbmodel$ForeignKeyElement == null ? (class$com$sun$forte4j$modules$dbmodel$ForeignKeyElement = TableElement.class$("com.sun.forte4j.modules.dbmodel.ForeignKeyElement")) : class$com$sun$forte4j$modules$dbmodel$ForeignKeyElement);
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        return arrayList.toArray(new ForeignKeyElement[n]);
    }

    public ForeignKeyElement getForeignKey(DBIdentifier dBIdentifier) {
        ForeignKeyElement[] foreignKeyElementArray = this.getForeignKeys();
        int n = foreignKeyElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ForeignKeyElement foreignKeyElement = foreignKeyElementArray[n2];
            if (dBIdentifier.equals(foreignKeyElement.getName())) {
                return foreignKeyElement;
            }
            ++n2;
        }
        return null;
    }

    public UniqueKeyElement[] getUniqueKeys() {
        ArrayList arrayList = this.getKeys(class$com$sun$forte4j$modules$dbmodel$UniqueKeyElement == null ? (class$com$sun$forte4j$modules$dbmodel$UniqueKeyElement = TableElement.class$("com.sun.forte4j.modules.dbmodel.UniqueKeyElement")) : class$com$sun$forte4j$modules$dbmodel$UniqueKeyElement);
        if (arrayList == null) {
            return null;
        }
        return arrayList.toArray(new UniqueKeyElement[arrayList.size()]);
    }

    public UniqueKeyElement getUniqueKey(DBIdentifier dBIdentifier) {
        UniqueKeyElement[] uniqueKeyElementArray = this.getUniqueKeys();
        int n = uniqueKeyElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            UniqueKeyElement uniqueKeyElement = uniqueKeyElementArray[n2];
            if (dBIdentifier.equals(uniqueKeyElement.getName())) {
                return uniqueKeyElement;
            }
            ++n2;
        }
        return null;
    }

    public UniqueKeyElement getPrimaryKey() {
        UniqueKeyElement[] uniqueKeyElementArray = this.getUniqueKeys();
        if (uniqueKeyElementArray == null) {
            return null;
        }
        int n = 0;
        while (n < uniqueKeyElementArray.length) {
            UniqueKeyElement uniqueKeyElement = uniqueKeyElementArray[n];
            if (uniqueKeyElement.isPrimaryKey()) {
                return uniqueKeyElement;
            }
            ++n;
        }
        return null;
    }

    private void throwAddException(String string, DBMemberElement dBMemberElement) throws DBException {
        String string2 = dBMemberElement.getName().getName();
        throw new DBException(string2);
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName().toString();
        }
        return null;
    }

    public void addColumnPair(ColumnPairElement columnPairElement) throws DBException {
        this.addColumnPairs(new ColumnPairElement[]{columnPairElement});
    }

    public void addColumnPairs(ColumnPairElement[] columnPairElementArray) throws DBException {
        int n = 0;
        while (n < columnPairElementArray.length) {
            if (this.getColumnPair(columnPairElementArray[n].getName()) != null) {
                this.throwAddException("FMT_EXC_AddColumn", columnPairElementArray[n]);
            }
            if (columnPairElementArray[n].getDeclaringTable() == null) {
                columnPairElementArray[n].setDeclaringTable(this);
            }
            ++n;
        }
        this.getTableImpl().changeColumnPairs(columnPairElementArray, 1);
    }

    public void removeColumnPair(ColumnPairElement columnPairElement) throws DBException {
        this.removeColumnPairs(new ColumnPairElement[]{columnPairElement});
    }

    public void removeColumnPairs(ColumnPairElement[] columnPairElementArray) throws DBException {
        this.getTableImpl().changeColumnPairs(columnPairElementArray, -1);
    }

    public void setColumnPairs(ColumnPairElement[] columnPairElementArray) throws DBException {
        this.getTableImpl().changeColumnPairs(columnPairElementArray, 0);
    }

    public ColumnPairElement[] getColumnPairs() {
        return this.getTableImpl().getColumnPairs();
    }

    public ColumnPairElement getColumnPair(DBIdentifier dBIdentifier) {
        return this.getTableImpl().getColumnPair(dBIdentifier);
    }

    public DBMemberElement getMember(DBIdentifier dBIdentifier) {
        int n = dBIdentifier.getName().indexOf(";");
        if (n == -1) {
            return this.getColumn(dBIdentifier);
        }
        return this.getColumnPair(dBIdentifier);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class Memory
    extends DBElement.Memory
    implements Impl {
        private boolean _isTable;
        private DBMemoryCollection.Column columns;
        private DBMemoryCollection.Index indexes;
        private DBMemoryCollection.Key keys;
        private DBMemoryCollection.ColumnPair pairs;

        public Memory() {
            this._isTable = true;
        }

        public Memory(TableElement tableElement) {
            super(tableElement);
            this._isTable = tableElement.isTableOrView();
        }

        public void setTableOrView(boolean bl) {
            boolean bl2 = this._isTable;
            this._isTable = bl;
            this.firePropertyChange("tableOrView", new Boolean(bl2), new Boolean(bl));
        }

        public boolean isTableOrView() {
            return this._isTable;
        }

        public synchronized void changeColumns(ColumnElement[] columnElementArray, int n) throws DBException {
            this.initColumns();
            this.columns.change(columnElementArray, n);
        }

        public synchronized ColumnElement[] getColumns() {
            this.initColumns();
            return (ColumnElement[])this.columns.getElements();
        }

        public synchronized ColumnElement getColumn(DBIdentifier dBIdentifier) {
            this.initColumns();
            return (ColumnElement)this.columns.getElement(dBIdentifier);
        }

        void initColumns() {
            if (this.columns == null) {
                this.columns = new DBMemoryCollection.Column(this);
            }
        }

        public synchronized void changeIndexes(IndexElement[] indexElementArray, int n) throws DBException {
            this.initIndexes();
            this.indexes.change(indexElementArray, n);
        }

        public synchronized IndexElement[] getIndexes() {
            this.initIndexes();
            return (IndexElement[])this.indexes.getElements();
        }

        public synchronized IndexElement getIndex(DBIdentifier dBIdentifier) {
            this.initIndexes();
            return (IndexElement)this.indexes.getElement(dBIdentifier);
        }

        void initIndexes() {
            if (this.indexes == null) {
                this.indexes = new DBMemoryCollection.Index(this);
            }
        }

        public synchronized void changeKeys(KeyElement[] keyElementArray, int n) throws DBException {
            this.initKeys();
            this.keys.change(keyElementArray, n);
        }

        public synchronized KeyElement[] getKeys() {
            this.initKeys();
            return (KeyElement[])this.keys.getElements();
        }

        public synchronized KeyElement getKey(DBIdentifier dBIdentifier) {
            this.initKeys();
            return (KeyElement)this.keys.getElement(dBIdentifier);
        }

        void initKeys() {
            if (this.keys == null) {
                this.keys = new DBMemoryCollection.Key(this);
            }
        }

        final TableElement getTableElement() {
            return (TableElement)this._element;
        }

        public synchronized ColumnPairElement[] getColumnPairs() {
            this.initColumnPairs();
            return (ColumnPairElement[])this.pairs.getElements();
        }

        public synchronized ColumnPairElement getColumnPair(DBIdentifier dBIdentifier) {
            this.initColumnPairs();
            return (ColumnPairElement)this.pairs.getElement(dBIdentifier);
        }

        public synchronized void changeColumnPairs(ColumnPairElement[] columnPairElementArray, int n) throws DBException {
            this.initColumnPairs();
            this.pairs.change(columnPairElementArray, n);
        }

        void initColumnPairs() {
            if (this.pairs == null) {
                this.pairs = new DBMemoryCollection.ColumnPair(this);
            }
        }
    }

    public static interface Impl
    extends DBElement.Impl {
        public void setTableOrView(boolean var1) throws DBException;

        public boolean isTableOrView();

        public void changeColumns(ColumnElement[] var1, int var2) throws DBException;

        public ColumnElement[] getColumns();

        public ColumnElement getColumn(DBIdentifier var1);

        public void changeIndexes(IndexElement[] var1, int var2) throws DBException;

        public IndexElement[] getIndexes();

        public IndexElement getIndex(DBIdentifier var1);

        public void changeKeys(KeyElement[] var1, int var2) throws DBException;

        public KeyElement[] getKeys();

        public KeyElement getKey(DBIdentifier var1);

        public void changeColumnPairs(ColumnPairElement[] var1, int var2) throws DBException;

        public ColumnPairElement[] getColumnPairs();

        public ColumnPairElement getColumnPair(DBIdentifier var1);
    }
}

