/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.jms;

import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AccessViolationException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.InvalidAttributeValueException;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.tools.common.deploy.NameValuePair;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.common.util.diagnostics.StackTrace;
import com.iplanet.ias.tools.forte.jms.JmsResourceBean;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.swing.JOptionPane;
import org.openide.TopManager;

public class JmsUtil {
    static final ResourceBundle bundle = ResourceBundle.getBundle("com.iplanet.ias.tools.forte.jms.Bundle");
    public static int PROPERTY_NAME_PREFIX_LENGTH = "property.".length();

    public static JmsResourceBean getResourceBean(ServerComponent regres) {
        try {
            JmsResourceBean bn = new JmsResourceBean();
            Reporter.info(regres.getDisplayName());
            String value = null;
            value = (String)regres.getAttribute("name");
            if (value == null) {
                Reporter.error("JNDI name returns null");
                bn.setJndiName(null);
            } else {
                bn.setJndiName(value);
            }
            value = (String)regres.getAttribute("resType");
            if (value == null) {
                bn.setResType(null);
            } else {
                bn.setResType(value);
            }
            value = regres.getAttribute("enabled").toString();
            if (value == null) {
                bn.setEnabled(null);
            } else {
                bn.setEnabled(value);
            }
            value = (String)regres.getAttribute("description");
            if (value == null) {
                bn.setDescription("");
            } else {
                bn.setDescription(value);
            }
            AttributeList props = regres.getAttributes(new String[]{"property."});
            if (props.size() > 0) {
                Object[] pairs = new NameValuePair[props.size()];
                int i = 0;
                while (i < props.size()) {
                    Attribute prop = (Attribute)props.get(i);
                    NameValuePair pair = new NameValuePair();
                    pair.setParamName(prop.getName().substring(PROPERTY_NAME_PREFIX_LENGTH));
                    pair.setParamValue((String)prop.getValue());
                    pairs[i] = pair;
                    ++i;
                }
                bn.setExtParams(pairs);
            }
            return bn;
        }
        catch (AttributeNotFoundException ex) {
            Reporter.error("Got AttributeNotFoundException: " + ex.getMessage());
        }
        catch (AccessViolationException ex) {
            Reporter.error("Got AccessViolationException: " + ex.getMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_Access"), bundle.getString("Error"), 0);
        }
        catch (AFTargetNotFoundException ex) {
            Reporter.error("Got AFTargetNotFoundException: " + ex.getMessage());
            TopManager.getDefault().setStatusText(bundle.getString("Err_NoTarget") + ": " + ex.getLocalizedMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_NoTarget"), bundle.getString("Error"), 0);
        }
        catch (AFException ex) {
            Reporter.error("Got AFException: " + ex.getMessage());
            TopManager.getDefault().setStatusText(bundle.getString("Err_Access") + ": " + ex.getLocalizedMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_Access"), bundle.getString("Error"), 0);
        }
        catch (Throwable ex) {
            Reporter.critical(new StackTrace(ex));
        }
        return null;
    }

    public static boolean setAttribute(ServerComponent regres, String name, Object value) {
        Reporter.info("name = " + name + ", value = " + value);
        try {
            if (name.equals("JndiName")) {
                regres.setAttribute("name", (String)value);
            } else if (name.equals("ResType")) {
                regres.setAttribute("resType", (String)value);
            } else if (name.equals("Enabled")) {
                regres.setAttribute("enabled", new Boolean((String)value));
            } else if (name.equals("Description")) {
                regres.setAttribute("description", (String)value);
            }
            return true;
        }
        catch (AttributeNotFoundException ex) {
            Reporter.error("Got AttributeNotFoundException: " + ex.getMessage());
            return false;
        }
        catch (InvalidAttributeValueException ex) {
            Reporter.error("Got InvalidAttributeValueException: " + ex.getMessage());
            return false;
        }
        catch (AccessViolationException ex) {
            Reporter.error("Got AccessViolationException: " + ex.getMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_Access"), bundle.getString("Error"), 0);
            return false;
        }
        catch (AFTargetNotFoundException ex) {
            Reporter.error("Got AFTargetNotFoundException: " + ex.getMessage());
            TopManager.getDefault().setStatusText(bundle.getString("Err_NoTarget") + ": " + ex.getLocalizedMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_NoTarget"), bundle.getString("Error"), 0);
            return false;
        }
    }
}

