/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.ejb.resourceRefs;

import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManagerFactory;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.HostAndPort;
import com.iplanet.ias.tools.common.dd.DefaultResourcePrincipal;
import com.iplanet.ias.tools.common.dd.ResourceRef;
import com.iplanet.ias.tools.common.dd.ejb.Ejb;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.common.util.diagnostics.StackTrace;
import com.iplanet.ias.tools.forte.LinkedPropertyManager;
import com.iplanet.ias.tools.forte.common.ResRefMap;
import com.iplanet.ias.tools.forte.globalsettings.IasGlobalOptionsSettings;
import com.iplanet.ias.tools.forte.server.AdminInstanceBean;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.netbeans.modules.j2ee.server.datamodel.EjbStandardData;
import org.netbeans.modules.j2ee.server.datamodel.StandardData;

public class ResRefMapModel {
    private EjbStandardData.Ejb ejbJ2EE = null;
    private Ejb ejbNode = null;
    private String[] j2eeRefNames = null;
    private ResRefMap[] maps = null;
    private int numRefs = 0;
    private Hashtable resTags = null;
    private Vector[] regResTags = null;
    private LinkedPropertyManager refNameManager = new LinkedPropertyManager("ResRefName");

    public ResRefMapModel(Ejb n, EjbStandardData.Ejb e) {
        Reporter.assertIt((Object)n);
        Reporter.assertIt(e);
        this.ejbJ2EE = e;
        this.ejbNode = n;
        this.load();
    }

    public String[] getJ2eeRefNames() {
        return this.j2eeRefNames;
    }

    public ResRefMap[] getMaps() {
        return this.maps;
    }

    public void setMaps(ResRefMap[] maps) {
        this.maps = maps;
    }

    public Ejb saveData() {
        int num = this.howManyMaps();
        Reporter.info("Saving Resource Reference Maps --- numMaps: " + num + ",  numRefs: " + this.numRefs);
        int size = this.ejbNode.sizeResourceRef();
        ResourceRef[] existingRrs = this.ejbNode.getResourceRef();
        ResourceRef[] rrs = new ResourceRef[num];
        int currentMap = 0;
        ResourceRef rr = null;
        int i = 0;
        while (i < this.numRefs) {
            String jndi = this.maps[i].getJNDI();
            String j2ee = this.maps[i].getJ2EE();
            String uname = this.maps[i].getUsername();
            String pword = this.maps[i].getPassword();
            rr = null;
            boolean newEntry = true;
            int j = 0;
            while (j < size) {
                if (existingRrs[j].getResRefName().equals(j2ee) && existingRrs[j].getJndiName().equals(jndi)) {
                    rr = existingRrs[j];
                    newEntry = false;
                    break;
                }
                ++j;
            }
            if (newEntry) {
                rr = new ResourceRef();
                rr.setJndiName(jndi);
                rr.setResRefName(j2ee);
                if (null != uname && null != pword) {
                    DefaultResourcePrincipal drp = new DefaultResourcePrincipal();
                    drp.setName(uname);
                    drp.setPassword(pword);
                    rr.setDefaultResourcePrincipal(drp);
                }
            }
            rrs[currentMap++] = rr;
            this.refNameManager.joinWithSource(j2ee, (Object)rr, "ResRefName");
            ++i;
        }
        this.ejbNode.setResourceRef(rrs);
        return this.ejbNode;
    }

    int howManyMaps() {
        Reporter.info(new Integer(this.numRefs));
        return this.numRefs;
    }

    private void load() {
        this.loadJ2EERefs();
        this.maps = new ResRefMap[this.numRefs];
        int i = 0;
        while (i < this.numRefs) {
            this.maps[i] = new ResRefMap(this.j2eeRefNames[i]);
            ++i;
        }
        this.loadExistingMaps();
    }

    private void loadJ2EERefs() {
        Reporter.assertIt(this.ejbJ2EE);
        this.numRefs = 0;
        EjbStandardData.ResourceRefCategory rrc = this.ejbJ2EE.getResourceRefCategory();
        if (rrc == null) {
            Reporter.warn("No EjbStandardData.ResourceRefCategory returned from ejbJ2EE");
            this.j2eeRefNames = new String[0];
            return;
        }
        EjbStandardData.ResourceRef[] rr = rrc.getResourceRef();
        if (rr == null || rr.length <= 0) {
            this.j2eeRefNames = new String[0];
            return;
        }
        this.numRefs = rr.length;
        this.j2eeRefNames = new String[this.numRefs];
        this.regResTags = new Vector[this.numRefs];
        this.loadResourceTags();
        int i = 0;
        while (i < this.numRefs) {
            this.j2eeRefNames[i] = rr[i].getResRefName();
            this.refNameManager.addNewSource(this.j2eeRefNames[i], (StandardData)rr[i]);
            String resType = rr[i].getResType();
            Vector tags = (Vector)this.resTags.get(resType);
            Reporter.info("res-type = " + resType);
            this.regResTags[i] = tags;
            ++i;
        }
    }

    private void loadExistingMaps() {
        ResourceRef[] iasRefs = this.ejbNode.getResourceRef();
        int i = 0;
        while (i < iasRefs.length) {
            String jndi = iasRefs[i].getJndiName();
            String j2ee = iasRefs[i].getResRefName();
            DefaultResourcePrincipal drp = iasRefs[i].getDefaultResourcePrincipal();
            String name = null;
            String pword = null;
            if (null != drp) {
                name = drp.getName();
                pword = drp.getPassword();
            }
            Reporter.info(((Object)((Object)iasRefs[i])).hashCode() + " has name " + j2ee);
            this.refNameManager.joinWithSource(j2ee, (Object)iasRefs[i], "ResRefName");
            int j = 0;
            while (j < this.numRefs) {
                if (j2ee.equals(this.maps[j].getJ2EE())) {
                    this.maps[j].setJNDI(jndi);
                    this.maps[j].setPassword(pword);
                    this.maps[j].setUsername(name);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public Vector[] getResourceTags() {
        return this.regResTags;
    }

    private void loadResourceTags() {
        this.resTags = new Hashtable();
        List adinstances = IasGlobalOptionsSettings.getSingleton().getAdminInstances();
        if (adinstances.size() > 0) {
            int i = 0;
            while (i < adinstances.size()) {
                AdminInstanceBean bn = (AdminInstanceBean)IasGlobalOptionsSettings.getSingleton().getAdminInstance(i);
                HostAndPort hp = new HostAndPort(bn.getHost(), bn.getPort());
                try {
                    ServerModelIterator it = ServerInstanceManagerFactory.getFactory().getServerInstanceManager(hp, bn.getUserName(), bn.getPassword()).getAllServerInstances();
                    while (it.hasNext()) {
                        ServerModelIterator deployed;
                        Vector<String> topicConnFactories;
                        AppServerInstance si = (AppServerInstance)it.next();
                        Reporter.info("server instance: " + si.getName());
                        Vector<String> resources = (Vector<String>)this.resTags.get("javax.sql.DataSource");
                        if (resources == null) {
                            resources = new Vector<String>();
                        }
                        try {
                            ServerModelIterator deployed2 = si.getJDBCResources();
                            while (deployed2.hasNext()) {
                                String val = deployed2.next().toString();
                                val = val + "(" + si.getName() + ":" + hp + ")";
                                resources.addElement(val);
                            }
                        }
                        catch (AFTargetNotFoundException te) {
                            te.printStackTrace();
                        }
                        catch (AFException ex) {
                            ex.printStackTrace();
                        }
                        this.resTags.put("javax.sql.DataSource", resources);
                        Vector<String> queueConnFactories = (Vector<String>)this.resTags.get("javax.jms.QueueConnectionFactory");
                        if (queueConnFactories == null) {
                            queueConnFactories = new Vector<String>();
                        }
                        if ((topicConnFactories = (Vector<String>)this.resTags.get("javax.jms.TopicConnectionFactory")) == null) {
                            topicConnFactories = new Vector<String>();
                        }
                        try {
                            deployed = si.getJMSResources();
                            while (deployed.hasNext()) {
                                ServerComponent res = (ServerComponent)deployed.next();
                                String val = res.toString();
                                val = val + "(" + si.getName() + ":" + hp + ")";
                                String resType = (String)res.getAttribute("resType");
                                Reporter.info(resType);
                                if (resType.equals("javax.jms.QueueConnectionFactory")) {
                                    queueConnFactories.addElement(val);
                                    continue;
                                }
                                if (!resType.equals("javax.jms.TopicConnectionFactory")) continue;
                                topicConnFactories.addElement(val);
                            }
                        }
                        catch (AFTargetNotFoundException te) {
                            te.printStackTrace();
                        }
                        catch (AFException ex) {
                            ex.printStackTrace();
                        }
                        this.resTags.put("javax.jms.QueueConnectionFactory", queueConnFactories);
                        this.resTags.put("javax.jms.TopicConnectionFactory", topicConnFactories);
                        resources = (Vector<String>)this.resTags.get("javax.mail.Session");
                        if (resources == null) {
                            resources = new Vector<String>();
                        }
                        try {
                            deployed = si.getJavaMailResources();
                            while (deployed.hasNext()) {
                                String val = deployed.next().toString();
                                val = val + "(" + si.getName() + ":" + hp + ")";
                                resources.addElement(val);
                            }
                        }
                        catch (AFTargetNotFoundException te) {
                            te.printStackTrace();
                        }
                        catch (AFException ex) {
                            ex.printStackTrace();
                        }
                        this.resTags.put("javax.mail.Session", resources);
                    }
                }
                catch (Throwable t) {
                    Reporter.critical(new StackTrace(t));
                }
                ++i;
            }
        }
    }
}

