/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.DeployedWebModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.VirtualServer;
import com.iplanet.ias.admin.servermodel.beans.VirtualServerClass;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.StringValidator;
import java.util.Vector;
import javax.management.ObjectName;

public class VirtualServerClassController
implements Controller {
    private static final String CREATE_VIRTUAL_SERVER = "createVirtualServer";
    private static final String DELETE_VIRTUAL_SERVER = "deleteVirtualServer";
    private static final String LIST_VIRTUAL_SERVERS = "listVirtualServers";
    private static final String CREATE_HTTP_QOS = "createHttpQos";
    private static final String DELETE_HTTP_QOS = "deleteHttpQos";
    private static final String IS_HTTP_QOS_CREATED = "isHttpQosCreated";
    private VirtualServerClass component;

    public VirtualServerClassController(VirtualServerClass virtualServerClass) {
        this.component = virtualServerClass;
    }

    public void createVirtualServer(String id, String hosts, String mime, String defaultWebModule) throws AFException {
        ArgChecker.checkValid(id, "id", StringValidator.getInstance());
        ArgChecker.checkValid(hosts, "hosts");
        ArgChecker.checkValid(mime, "mime");
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.String"};
        Object[] params = new Object[]{id, defaultWebModule, null, null, hosts, mime, null, null, null, null, null};
        this.invoke(CREATE_VIRTUAL_SERVER, params, signature);
    }

    public void removeVirtualServer(String id) throws AFException {
        ArgChecker.checkValid(id, "id", StringValidator.getInstance());
        this.delWebModuleRef(id);
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{id};
        this.invoke(DELETE_VIRTUAL_SERVER, params, signature);
    }

    private void delWebModuleRef(String name) throws AFException {
        try {
            String vsStr;
            DeployedWebModuleComponentBean webModule;
            VirtualServer vs = this.component.getVirtualServer(name);
            String webModName = (String)vs.getAttribute("defaultWebModule");
            if (webModName != null && webModName.length() > 0 && (webModule = this.getWebModule(webModName)) != null && (vsStr = (String)webModule.getAttribute("virtualServers")) != null && vsStr.length() > 0 && vsStr.indexOf(name) != -1) {
                String preStr = vsStr.substring(0, vsStr.indexOf(name));
                String postStr = vsStr.substring(vsStr.indexOf(name) + name.length());
                if (preStr.length() > 0 && postStr.length() > 0) {
                    preStr = preStr.substring(0, preStr.length() - 1);
                } else if (preStr.length() > 0 && postStr.length() == 0) {
                    preStr = preStr.substring(0, preStr.length() - 1);
                } else if (preStr.length() == 0 && postStr.length() > 0) {
                    postStr = postStr.substring(1);
                }
                String newVSStr = preStr + postStr;
                webModule.setAttribute("virtualServers", newVSStr);
            }
        }
        catch (Exception e) {
            if (e instanceof AFException) {
                throw (AFException)e;
            }
            throw new AFException(e.getLocalizedMessage());
        }
    }

    private DeployedWebModuleComponentBean getWebModule(String moduleName) {
        ArgChecker.checkValid(moduleName, "moduleName", StringValidator.getInstance());
        ObjectName identifier = ObjectNames.getWebModuleObjectName(this.component.getInstanceName(), moduleName);
        Assert.assertit(identifier != null, "null value returned");
        DeployedWebModuleComponentBean module = new DeployedWebModuleComponentBean(identifier.toString(), moduleName, true);
        module.setContextHolder(this.component.getContextHolder());
        return module;
    }

    public ServerModelIterator getVirtualServers() throws AFException {
        Vector<VirtualServer> list = new Vector<VirtualServer>();
        String[] virtualServers = (String[])this.invoke(LIST_VIRTUAL_SERVERS, null, null);
        if (virtualServers != null && virtualServers.length > 0) {
            String instanceName = this.component.getInstanceName();
            String vsClassId = this.component.getClassId();
            Assert.assertit(instanceName != null, "null value returned");
            int i = 0;
            while (i < virtualServers.length) {
                ObjectName virtualServerMBeanName = ObjectNames.getVirtualServerObjectName(instanceName, vsClassId, virtualServers[i]);
                Assert.assertit(virtualServerMBeanName != null, "null value returned");
                Debug.println("VirtualServerClassController.getVirtualServers: virtual server mbean = " + virtualServerMBeanName);
                VirtualServer virtualServer = new VirtualServer(virtualServerMBeanName.toString(), virtualServers[i]);
                virtualServer.setContextHolder(this.component.getContextHolder());
                list.add(virtualServer);
                ++i;
            }
        }
        return new ServerModelIterator(list);
    }

    public boolean isHttpQosCreated() throws AFException {
        Boolean value = (Boolean)this.invoke(IS_HTTP_QOS_CREATED, null, null);
        Assert.assertit(value != null, "null value returned");
        return value;
    }

    public void createHttpQos() throws AFException {
        String[] signature = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.Boolean"};
        Object[] params = new Object[]{null, null, null, null};
        this.invoke(CREATE_HTTP_QOS, params, signature);
    }

    public void removeHttpQos() throws AFException {
        this.invoke(DELETE_HTTP_QOS, null, null);
    }

    private Object invoke(String operation, Object[] params, String[] signature) throws AFException {
        try {
            ContextHolder ctxHolder = this.component.getContextHolder();
            ObjectName mbeanName = new ObjectName(this.component.getIdentifier());
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            return dispatcher.invoke(mbeanName, operation, params, signature);
        }
        catch (Exception e) {
            if (e instanceof AFException) {
                throw (AFException)e;
            }
            throw new AFException(e.getLocalizedMessage());
        }
    }
}

