/*
 * Decompiled with CFR 0.152.
 */
package archiver.deserializer;

import archiver.deserializer.XMLDeserializer;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BaseXMLDeserializer
implements XMLDeserializer,
DocumentHandler,
DTDHandler,
ErrorHandler {
    protected Object InitialObject;
    protected Parser Parser;
    public Locator TheLocator;
    protected InputSource TheSource;
    public StringBuffer TheCharacters = new StringBuffer();

    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
        this.TheLocator = locator;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void endElement(String string) throws SAXException {
        this.TheCharacters.delete(0, this.TheCharacters.length());
    }

    public void endDocument() throws SAXException {
        this.freeResources();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.TheCharacters.append(cArray, n, n2);
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        this.TheCharacters.delete(0, this.TheCharacters.length());
    }

    public void startDocument() throws SAXException {
        this.freeResources();
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.commonErrorProcessor(sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.commonErrorProcessor(sAXParseException);
    }

    public void setInitialObject(Object object) {
        this.InitialObject = object;
    }

    public void freeResources() {
        this.TheCharacters.delete(0, this.TheCharacters.length());
    }

    public String getCharacters() {
        int n = 0;
        while (n < this.TheCharacters.length()) {
            if (n + 2 < this.TheCharacters.length() && this.TheCharacters.substring(n, n + 2).equals("\\n")) {
                this.TheCharacters.delete(n, n + 2);
            } else if (this.TheCharacters.charAt(n) == '\n') {
                this.TheCharacters.deleteCharAt(n);
            }
            ++n;
        }
        return this.TheCharacters.toString();
    }

    public int Begin() throws SAXException {
        try {
            if (this.Parser == null) {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setValidating(false);
                sAXParserFactory.setNamespaceAware(false);
                this.Parser = sAXParserFactory.newSAXParser().getParser();
                this.Parser.setDocumentHandler(this);
                this.Parser.setDTDHandler(this);
                this.Parser.setErrorHandler(this);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            SAXException sAXException = new SAXException(parserConfigurationException.getMessage());
            throw sAXException;
        }
        return 1;
    }

    public void commonErrorProcessor(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public Object XlateObject() throws SAXException, IOException {
        this.Begin();
        this.Parser.parse(this.TheSource);
        return this.InitialObject;
    }

    public void setSource(InputSource inputSource) {
        this.TheSource = inputSource;
    }

    public Object XlateObject(InputStream inputStream) throws SAXException, IOException {
        this.Begin();
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId("archiverNoID");
        this.setSource(inputSource);
        this.Parser.parse(this.TheSource);
        return this.InitialObject;
    }

    public void DumpStatus() {
        System.out.println("Dump Status from class BaseXMLSerializer");
        System.out.println("The initial object is an instance of " + this.InitialObject.getClass().getName());
        System.out.println("The initial object state " + this.InitialObject.toString());
        System.out.println("The current stream dump is " + this.TheCharacters);
        System.out.println("Dump Status from class BaseXMLSerializer - END");
    }
}

