/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.Grammar;
import antlr.Token;
import antlr.Tool;
import antlr.collections.impl.BitSet;
import java.io.IOException;

class LexerGrammar
extends Grammar {
    protected BitSet charVocabulary = new BitSet();
    protected boolean testLiterals = true;
    protected boolean caseSensitiveLiterals = true;
    protected boolean caseSensitive = true;
    protected boolean filterMode = false;
    protected String filterRule = null;

    public void generate() throws IOException {
        this.generator.gen(this);
    }

    public String getSuperClass() {
        if (this.debuggingOutput) {
            return "debug.DebuggingCharScanner";
        }
        return "CharScanner";
    }

    public boolean getTestLiterals() {
        return this.testLiterals;
    }

    public void processArguments(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-trace")) {
                this.traceRules = true;
                Tool.setArgOK(n);
            } else if (stringArray[n].equals("-traceLexer")) {
                this.traceRules = true;
                Tool.setArgOK(n);
            } else if (stringArray[n].equals("-debug")) {
                this.debuggingOutput = true;
                Tool.setArgOK(n);
            }
            ++n;
        }
    }

    public void setCharVocabulary(BitSet bitSet) {
        this.charVocabulary = bitSet;
    }

    public boolean setOption(String string, Token token) {
        String string2 = token.getText();
        if (string.equals("buildAST")) {
            Tool.warning("buildAST option is not valid for lexer", this.getFilename(), token.getLine());
            return true;
        }
        if (string.equals("testLiterals")) {
            if (string2.equals("true")) {
                this.testLiterals = true;
            } else if (string2.equals("false")) {
                this.testLiterals = false;
            } else {
                Tool.warning("testLiterals option must be true or false", this.getFilename(), token.getLine());
            }
            return true;
        }
        if (string.equals("interactive")) {
            if (string2.equals("true")) {
                this.interactive = true;
            } else if (string2.equals("false")) {
                this.interactive = false;
            } else {
                this.tool.error("interactive option must be true or false", this.getFilename(), token.getLine());
            }
            return true;
        }
        if (string.equals("caseSensitive")) {
            if (string2.equals("true")) {
                this.caseSensitive = true;
            } else if (string2.equals("false")) {
                this.caseSensitive = false;
            } else {
                Tool.warning("caseSensitive option must be true or false", this.getFilename(), token.getLine());
            }
            return true;
        }
        if (string.equals("caseSensitiveLiterals")) {
            if (string2.equals("true")) {
                this.caseSensitiveLiterals = true;
            } else if (string2.equals("false")) {
                this.caseSensitiveLiterals = false;
            } else {
                Tool.warning("caseSensitiveLiterals option must be true or false", this.getFilename(), token.getLine());
            }
            return true;
        }
        if (string.equals("filter")) {
            if (string2.equals("true")) {
                this.filterMode = true;
            } else if (string2.equals("false")) {
                this.filterMode = false;
            } else if (token.getType() == 24) {
                this.filterMode = true;
                this.filterRule = string2;
            } else {
                Tool.warning("filter option must be true, false, or a lexer rule name", this.getFilename(), token.getLine());
            }
            return true;
        }
        if (string.equals("longestPossible")) {
            Tool.warning("longestPossible option has been deprecated; ignoring it...", this.getFilename(), token.getLine());
            return true;
        }
        if (super.setOption(string, token)) {
            return true;
        }
        this.tool.error("Invalid option: " + string, this.getFilename(), token.getLine());
        return false;
    }

    LexerGrammar(String string, Tool tool, String string2) {
        super(string, tool, string2);
        this.defaultErrorHandler = false;
    }
}

