/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.common.ui;

import com.iplanet.ias.tools.common.BooleanStringItemListener;
import com.iplanet.ias.tools.common.PropertyUtils;
import com.iplanet.ias.tools.common.Validator;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.common.util.diagnostics.StackTrace;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class MVCUtils {
    private static final String TRUE = "true";
    private static final String EMPTY = "";
    static /* synthetic */ Class class$javax$swing$ListSelectionModel;

    private MVCUtils() {
    }

    public static void linkBooleanStringElement(Object model, AbstractButton view, String propName) throws IntrospectionException {
        view.addItemListener(new BooleanStringItemListener(model, propName));
        view.setSelected(MVCUtils.getStringElementValue(model, propName).equals(TRUE));
    }

    public static void linkBooleanStringElement(Object model, AbstractButton view) throws IntrospectionException {
        String propName = view.getName();
        if (null != propName) {
            MVCUtils.linkBooleanStringElement(model, view, propName);
        } else {
            Reporter.critical("the name of the " + model + " is null");
        }
    }

    public static void linkStringElement(Object model, JTextComponent view, String propName) throws IntrospectionException {
        view.addKeyListener(new StringItemListener(model, propName));
        view.setText(MVCUtils.getStringElementValue(model, propName));
    }

    public static void linkStringElement(Object model, JTextComponent view) throws IntrospectionException {
        String propName = view.getName();
        if (null != propName) {
            MVCUtils.linkStringElement(model, view, propName);
        } else {
            Reporter.critical("the name of the " + model + " is null");
        }
    }

    public static void linkIntStringElement(Object model, JTextComponent view, String propName) throws IntrospectionException {
        view.addKeyListener(new IntStringItemListener(model, propName));
        view.setText(MVCUtils.getStringElementValue(model, propName));
    }

    public static void linkIntStringElement(Object model, JTextComponent view, String propName, int defaultValue) throws IntrospectionException {
        view.addKeyListener(new IntStringItemListener(model, propName));
        String tval = MVCUtils.getStringElementValue(model, propName);
        view.setText(MVCUtils.getStringElementValue(model, propName));
        if (null == tval || tval.equals(EMPTY)) {
            view.setText(EMPTY + defaultValue);
        }
    }

    public static void linkIntStringElement(Object model, JTextComponent view, String propName, int min, int max) throws IntrospectionException {
        view.addKeyListener(new IntStringItemListener(model, propName, min, max));
        view.setText(MVCUtils.getStringElementValue(model, propName));
    }

    public static void linkIntStringElement(Object model, JTextComponent view, String propName, int defaultValue, int min, int max) throws IntrospectionException {
        view.addKeyListener(new IntStringItemListener(model, propName, min, max));
        String tval = MVCUtils.getStringElementValue(model, propName);
        view.setText(MVCUtils.getStringElementValue(model, propName));
        if (null == tval || tval.equals(EMPTY)) {
            view.setText(EMPTY + defaultValue);
        }
    }

    public static void selectionSensitive(Object hasListSelectionModel, Component sensitiveItem) {
        try {
            Method getter = hasListSelectionModel.getClass().getMethod("getSelectionModel", null);
            Object[] lsm = new ListSelectionModel[1];
            Class[] lsmArgs = new Class[]{class$javax$swing$ListSelectionModel == null ? (class$javax$swing$ListSelectionModel = MVCUtils.class$("javax.swing.ListSelectionModel")) : class$javax$swing$ListSelectionModel};
            if (null != getter) {
                lsm[0] = (ListSelectionModel)getter.invoke(hasListSelectionModel, null);
                if (null == lsm[0]) {
                    lsm[0] = new DefaultListSelectionModel();
                    Method putter = hasListSelectionModel.getClass().getMethod("setSelectionModel", lsmArgs);
                    putter.invoke(hasListSelectionModel, lsm);
                }
                lsm[0].addListSelectionListener(new SelectionActivator(sensitiveItem, hasListSelectionModel));
            }
        }
        catch (Throwable t) {
            Reporter.critical(new StackTrace(t));
        }
    }

    public static void validationSensitive(JTextComponent f, Component sensitive, Validator v) {
        StringValidationListener svl = new StringValidationListener(sensitive, v);
        f.addKeyListener(svl);
    }

    private static String getStringElementValue(Object model, String propName) {
        String retVal = EMPTY;
        Method reader = null;
        try {
            PropertyDescriptor destPd = new PropertyDescriptor(propName, model.getClass());
            reader = destPd.getReadMethod();
            Object tmp = reader.invoke(model, null);
            if (null != tmp) {
                retVal = tmp.toString();
            }
        }
        catch (Throwable t) {
            Reporter.critical(new StackTrace(t));
        }
        return retVal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class IntStringItemListener
    extends StringItemListener {
        Method reader = null;
        int min = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;

        public IntStringItemListener(Object target, String destName) throws IntrospectionException {
            super(target, destName);
        }

        public IntStringItemListener(Object target, String destName, int min, int max) throws IntrospectionException {
            super(target, destName);
            this.min = min;
            this.max = max;
            this.reader = PropertyUtils.getReader(target, destName);
        }

        public void keyReleased(KeyEvent ev) {
            try {
                JTextComponent src = (JTextComponent)ev.getSource();
                this.args[0] = new Integer(src.getText());
                Integer argVal = (Integer)this.args[0];
                int argIVal = argVal;
                if (argIVal >= this.min && argIVal <= this.max) {
                    this.writer.invoke(this.target, this.args);
                } else if (null != this.reader) {
                    Integer prev = (Integer)this.reader.invoke(this.target, null);
                    src.setText(prev.toString());
                }
            }
            catch (Throwable t) {
                Reporter.critical(new StackTrace(t));
            }
        }
    }

    static class StringItemListener
    extends KeyAdapter {
        Object target = null;
        Method writer = null;
        protected Object[] args = new Object[]{this.target};

        public StringItemListener(Object target, String destName) throws IntrospectionException {
            this.target = target;
            this.writer = PropertyUtils.getWriter(target, destName);
        }

        public void keyReleased(KeyEvent ev) {
            try {
                JTextComponent src = (JTextComponent)ev.getSource();
                this.args[0] = src.getText();
                if (null == this.args[0]) {
                    this.args[0] = MVCUtils.EMPTY;
                }
                this.writer.invoke(this.target, this.args);
            }
            catch (Throwable t) {
                Reporter.critical(new StackTrace(t));
            }
        }
    }

    static class SelectionActivator
    implements ListSelectionListener {
        Component comp = null;
        Object foo;

        public SelectionActivator(Component comp, Object foo2) {
            this.comp = comp;
            this.foo = foo2;
        }

        public void valueChanged(ListSelectionEvent lse) {
            Object src = lse.getSource();
            Reporter.verbose(src);
            int selected = -1;
            if (this.foo instanceof JTable) {
                JTable t = (JTable)this.foo;
                selected = t.getSelectedRow();
            } else if (src instanceof JList) {
                JList l = (JList)this.foo;
                selected = l.getSelectedIndex();
            }
            if (-1 != selected) {
                this.comp.setEnabled(true);
            } else {
                this.comp.setEnabled(false);
            }
        }
    }

    static class StringValidationListener
    extends KeyAdapter {
        Component sensitive;
        Validator validation;

        public StringValidationListener(Component sensitive, Validator validation) {
            this.validation = validation;
            this.sensitive = sensitive;
        }

        public void keyReleased(KeyEvent ev) {
            JTextComponent tc = (JTextComponent)ev.getSource();
            if (this.validation.isValid(tc.getText())) {
                this.sensitive.setEnabled(true);
            } else {
                this.sensitive.setEnabled(false);
            }
        }
    }
}

