/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli.framework;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.GlobalsManager;
import com.iplanet.ias.tools.cli.framework.ValidCommand;
import com.iplanet.ias.tools.cli.framework.ValidCommandsList;
import com.iplanet.ias.tools.cli.framework.ValidOption;
import com.iplanet.ias.tools.cli.framework.ValidOptionsList;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CLIPropertiesReader {
    private static final URL propertiesFile = (class$com$iplanet$ias$tools$cli$framework$CLIPropertiesReader == null ? (class$com$iplanet$ias$tools$cli$framework$CLIPropertiesReader = CLIPropertiesReader.class$("com.iplanet.ias.tools.cli.framework.CLIPropertiesReader")) : class$com$iplanet$ias$tools$cli$framework$CLIPropertiesReader).getClassLoader().getResource("com/iplanet/ias/tools/cli/CLIProperties.xml");
    private ValidCommandsList commandsList = null;
    private Document document;
    private Vector validOptionsForAllCommands;
    private Vector requiredOptionsForAllCommands;
    private ValidOptionsList validOptions;
    static /* synthetic */ Class class$com$iplanet$ias$tools$cli$framework$CLIPropertiesReader;

    public CLIPropertiesReader() throws CommandValidationException {
        this.initProperties();
        this.commandsList = new ValidCommandsList();
        this.validOptionsForAllCommands = new Vector();
        this.requiredOptionsForAllCommands = new Vector();
        this.validOptions = new ValidOptionsList();
        this.generateOptionsAndCommands();
    }

    public ValidCommandsList getCommandsList() {
        return this.commandsList;
    }

    public ValidOptionsList getValidOptions() {
        return this.validOptions;
    }

    public void initProperties() throws CommandValidationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setValidating(true);
            Debug.println("Validation against DTD is " + documentBuilderFactory.isValidating());
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (propertiesFile == null) {
                throw new CommandValidationException(GlobalsManager.getLocalizedString("NoPropertiesFile"));
            }
            Debug.println(propertiesFile);
            InputSource inputSource = new InputSource(propertiesFile.toString());
            this.document = documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Debug.printStackTrace(parserConfigurationException);
            throw new CommandValidationException(parserConfigurationException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            Debug.printStackTrace(iOException);
            throw new CommandValidationException(iOException.getLocalizedMessage());
        }
    }

    private void generateOptionsAndCommands() {
        if (this.document != null) {
            Node node = this.document.getDocumentElement().getFirstChild();
            while (node != null) {
                Object object;
                String string;
                Node node2;
                String string2 = node.getNodeName();
                if (string2.equalsIgnoreCase("Options")) {
                    node2 = node.getFirstChild();
                    while (node2 != null) {
                        string = node2.getNodeName();
                        if (string.equalsIgnoreCase("Option")) {
                            object = this.generateOption(node2);
                            this.validOptions.addOption((ValidOption)object);
                        }
                        node2 = node2.getNextSibling();
                    }
                } else if (string2.equalsIgnoreCase("ValidOptionsForAllCommands")) {
                    node2 = node.getFirstChild();
                    while (node2 != null) {
                        string = node2.getNodeName();
                        if (string.equalsIgnoreCase("ValidOption")) {
                            object = node2.getFirstChild().getNodeValue();
                            this.validOptionsForAllCommands.add(object);
                        }
                        node2 = node2.getNextSibling();
                    }
                } else if (string2.equalsIgnoreCase("RequiredOptionsForAllCommands")) {
                    node2 = node.getFirstChild();
                    while (node2 != null) {
                        string = node2.getNodeName();
                        if (string.equalsIgnoreCase("RequiredOption")) {
                            object = node2.getFirstChild().getNodeValue();
                            this.requiredOptionsForAllCommands.add(object);
                        }
                        node2 = node2.getNextSibling();
                    }
                } else if (string2.equalsIgnoreCase("ValidCommands")) {
                    node2 = node.getFirstChild();
                    while (node2 != null) {
                        string = node2.getNodeName();
                        if (string.equalsIgnoreCase("ValidCommand")) {
                            object = this.generateCommand(node2);
                            this.commandsList.addCommand((ValidCommand)object);
                        }
                        node2 = node2.getNextSibling();
                    }
                }
                node = node.getNextSibling();
            }
        }
    }

    private ValidOption generateOption(Node node) {
        ValidOption validOption = new ValidOption();
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            String string;
            String string2 = node2.getNodeName();
            if (string2.equalsIgnoreCase("name")) {
                string = node2.getFirstChild().getNodeValue();
                if (string != null) {
                    string = string.trim();
                    validOption.setName(string);
                }
            } else if (string2.equalsIgnoreCase("value-required")) {
                string = node2.getFirstChild().getNodeValue();
                if (string != null) {
                    if ((string = string.trim()).equalsIgnoreCase("REQUIRED")) {
                        validOption.setRequired(1);
                    } else if (string.equalsIgnoreCase("OPTIONAL")) {
                        validOption.setRequired(2);
                    } else if (string.equalsIgnoreCase("NOT_REQUIRED")) {
                        validOption.setRequired(3);
                    }
                }
            } else if (string2.equalsIgnoreCase("shortoption")) {
                string = node2.getFirstChild().getNodeValue();
                if ((string = string.trim()) != null) {
                    validOption.setShortName(string);
                }
            } else if (string2.equalsIgnoreCase("type")) {
                string = node2.getFirstChild().getNodeValue();
                if ((string = string.trim()) != null) {
                    validOption.setType(string);
                }
            } else if (string2.equalsIgnoreCase("default")) {
                string = node2.getFirstChild().getNodeValue();
                if ((string = string.trim()) != null) {
                    validOption.setDefaultValue(string);
                }
            } else if (string2.equalsIgnoreCase("help-text")) {
                string = node2.getFirstChild().getNodeValue();
                if ((string = string.trim()) != null) {
                    validOption.setHelpText(string);
                }
            }
            node2 = node2.getNextSibling();
        }
        return validOption;
    }

    private ValidCommand generateCommand(Node node) {
        ValidCommand validCommand = new ValidCommand();
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            ValidOption validOption;
            String string;
            String string2 = node2.getNodeName();
            if (string2.equalsIgnoreCase("name")) {
                string = node2.getFirstChild().getNodeValue();
                if (string != null) {
                    string = string.trim();
                    validCommand.setName(string);
                }
            } else if (string2.equalsIgnoreCase("numberofoperands")) {
                string = node2.getFirstChild().getNodeValue();
                if (string != null) {
                    string = string.trim();
                    validCommand.setNumberOfOperands(string);
                }
            } else if (string2.equalsIgnoreCase("className")) {
                string = node2.getFirstChild().getNodeValue();
                if (string != null) {
                    string = string.trim();
                    validCommand.setClassName(string);
                }
            } else if (string2.equalsIgnoreCase("ValidOption")) {
                string = node2.getFirstChild().getNodeValue();
                validOption = this.findOption(string);
                if (validOption == null) {
                    System.out.println("Valid option (" + string + ")is not found in xml : " + validCommand.getName());
                    return validCommand;
                }
                validCommand.addValidOption(validOption);
            } else if (string2.equalsIgnoreCase("RequiredOption")) {
                string = node2.getFirstChild().getNodeValue();
                validOption = this.findOption(string);
                if (validOption == null) {
                    System.out.println("Required option (" + string + ")is not found in xml : " + validCommand.getName());
                    return validCommand;
                }
                validCommand.addRequiredOption(validOption);
            } else if (string2.equalsIgnoreCase("help-text")) {
                string = node2.getFirstChild().getNodeValue();
                if (string != null) {
                    string = string.trim();
                    validCommand.setHelpText(string);
                }
            } else if (string2.equalsIgnoreCase("usage-text") && (string = node2.getFirstChild().getNodeValue()) != null) {
                string = string.trim();
                validCommand.setUsageText(string);
            }
            node2 = node2.getNextSibling();
        }
        this.appendOptionsValidForAllCommands(validCommand);
        this.appendOptionsRequiredForAllCommands(validCommand);
        return validCommand;
    }

    private ValidOption findOption(String string) {
        return this.validOptions.getValidOption(string);
    }

    private void appendOptionsValidForAllCommands(ValidCommand validCommand) {
        int n = 0;
        while (n < this.validOptionsForAllCommands.size()) {
            String string = (String)this.validOptionsForAllCommands.get(n);
            validCommand.addValidOption(this.findOption(string));
            ++n;
        }
    }

    private void appendOptionsRequiredForAllCommands(ValidCommand validCommand) {
        int n = 0;
        while (n < this.requiredOptionsForAllCommands.size()) {
            String string = (String)this.requiredOptionsForAllCommands.get(n);
            validCommand.addRequiredOption(this.findOption(string));
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

