/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseConfigurationCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Option;

public class ReconfigCommand
extends BaseConfigurationCommand {
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        try {
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            String string = this.getInstanceOperand(0);
            AppServerInstance appServerInstance = null;
            boolean bl = false;
            appServerInstance = "admin-server".equals(string) ? serverInstanceManager.getAdminInstance() : serverInstanceManager.getServerInstance(string);
            boolean bl2 = this.DiscardManualChanges();
            boolean bl3 = this.KeepManualChanges();
            if (bl3 && bl2) {
                throw new CommandValidationException(this.getLocalizedString("CantSetBothOptions"));
            }
            bl = bl3 ? appServerInstance.useManualChanges() : (bl2 ? appServerInstance.overwriteChanges() : appServerInstance.applyChanges());
            if (bl) {
                this.printMessage(this.getLocalizedString("RestartRequired"));
            }
            this.printMessage(this.getLocalizedString("ReconfigSuccess"));
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotReconfig"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private boolean DiscardManualChanges() throws CommandValidationException {
        Option option = this.findOption("discardmanualchanges");
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        boolean bl = false;
        if (string == null) {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        if (string.equalsIgnoreCase("true")) {
            bl = true;
        } else if (string.equalsIgnoreCase("false")) {
            bl = false;
        } else {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        return bl;
    }

    private boolean KeepManualChanges() throws CommandValidationException {
        Option option = this.findOption("keepmanualchanges");
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        boolean bl = false;
        if (string == null) {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        if (string.equalsIgnoreCase("true")) {
            bl = true;
        } else if (string.equalsIgnoreCase("false")) {
            bl = false;
        } else {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        return bl;
    }
}

