/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.DeployedApplicationComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedEJBComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedEJBModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedEntityBeanComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedServletComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedSessionBeanComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedWebModuleComponentBean;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseDeploymentCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import com.iplanet.ias.tools.cli.framework.Option;

public class ListSubComponentsCommand
extends BaseDeploymentCommand {
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        try {
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            AppServerInstance appServerInstance = serverInstanceManager.getServerInstance(this.getInstanceOption());
            String string = ((Operand)this.getOperands().get(0)).getName();
            String string2 = this.getApplicationNameOption();
            String string3 = null;
            if (this.findOption("type") != null) {
                string3 = this.findOption("type").getValue();
            }
            if (!(string3 == null || string3.equalsIgnoreCase("all") || string3.equalsIgnoreCase("servlets") || string3.equalsIgnoreCase("ejbs"))) {
                throw new CommandValidationException(this.getLocalizedString("InvalidSubComponentType", new Object[]{string, string3}));
            }
            if (string3.equalsIgnoreCase("all")) {
                this.listServlets(appServerInstance);
                this.listEJBs(appServerInstance);
            } else if (string3.equalsIgnoreCase("servlets")) {
                this.listServlets(appServerInstance);
            } else if (string3.equalsIgnoreCase("ejbs")) {
                this.listEJBs(appServerInstance);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotListSubComponents"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private void listServlets(AppServerInstance appServerInstance) throws CommandException, AFException {
        Object object;
        String string = this.getModuleNameOperand();
        DeployedWebModuleComponentBean deployedWebModuleComponentBean = null;
        String string2 = this.getApplicationNameOption();
        if (string2 == null) {
            deployedWebModuleComponentBean = appServerInstance.getDeployedWebModule(string);
        } else {
            object = appServerInstance.getDeployedApplication(string2);
            try {
                deployedWebModuleComponentBean = ((DeployedApplicationComponentBean)object).getWebModule(string);
            }
            catch (Exception exception) {
                throw new CommandException(this.getLocalizedString("NoApplication") + " " + string2);
            }
        }
        object = null;
        try {
            object = deployedWebModuleComponentBean.getServlets();
        }
        catch (Exception exception) {
            throw new CommandException(this.getLocalizedString("NoWEBModule") + " " + string);
        }
        if (object.hasNext()) {
            while (object.hasNext()) {
                DeployedServletComponentBean deployedServletComponentBean = (DeployedServletComponentBean)object.next();
                this.printMessage(deployedServletComponentBean + " <" + this.getLocalizedString("Servlets") + ">");
            }
        } else {
            this.printMessage(this.getLocalizedString("NoServlets"));
        }
    }

    private void listEJBs(AppServerInstance appServerInstance) throws AFException, CommandException {
        DeployedEJBComponentBean deployedEJBComponentBean;
        String string = this.getModuleNameOperand();
        DeployedEJBModuleComponentBean deployedEJBModuleComponentBean = null;
        String string2 = this.getApplicationNameOption();
        if (string2 == null) {
            deployedEJBModuleComponentBean = appServerInstance.getDeployedEJBModule(string);
        } else {
            DeployedApplicationComponentBean deployedApplicationComponentBean = appServerInstance.getDeployedApplication(string2);
            if (deployedApplicationComponentBean == null) {
                throw new CommandException(this.getLocalizedString("NoApplication") + " " + string2);
            }
            deployedEJBModuleComponentBean = deployedApplicationComponentBean.getEJBModule(string);
        }
        boolean bl = false;
        ServerModelIterator serverModelIterator = null;
        try {
            serverModelIterator = deployedEJBModuleComponentBean.getEntityBeans();
        }
        catch (Exception exception) {
            throw new CommandException(this.getLocalizedString("NoEJBModule") + " " + string);
        }
        if (serverModelIterator.hasNext()) {
            bl = true;
            while (serverModelIterator.hasNext()) {
                deployedEJBComponentBean = (DeployedEntityBeanComponentBean)serverModelIterator.next();
                this.printMessage(deployedEJBComponentBean + " <" + this.getLocalizedString("Ejb") + ">");
            }
        }
        try {
            serverModelIterator = deployedEJBModuleComponentBean.getSessionBeans();
        }
        catch (Exception exception) {
            throw new CommandException(this.getLocalizedString("NoEJBModule") + " " + string);
        }
        if (serverModelIterator.hasNext()) {
            bl = true;
            while (serverModelIterator.hasNext()) {
                deployedEJBComponentBean = (DeployedSessionBeanComponentBean)serverModelIterator.next();
                this.printMessage(deployedEJBComponentBean + " <" + this.getLocalizedString("Ejb") + ">");
            }
        }
        if (!bl) {
            this.printMessage(this.getLocalizedString("NoEJBs"));
        }
    }

    private String getApplicationNameOption() {
        Option option = this.findOption("appname");
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        return string;
    }

    private String getModuleNameOperand() {
        return ((Operand)this.getOperands().get(0)).getName();
    }
}

