/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseResourceCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;

public class CreateJMSResourceCommand
extends BaseResourceCommand {
    private static final String RESOURCE_TYPE = "resourcetype";
    private static final String ENABLED = "enabled";
    private static final String DESCRIPTION = "description";
    private static final String QUEUE = "javax.jms.Queue";
    private static final String TOPIC = "javax.jms.Topic";
    private static final String QUEUE_FACTORY = "javax.jms.QueueConnectionFactory";
    private static final String TOPIC_FACTORY = "javax.jms.TopicConnectionFactory";

    public boolean validateOptions() throws CommandValidationException {
        if (!super.validateOptions()) {
            return false;
        }
        String string = this.findOption(RESOURCE_TYPE).getValue();
        if (!(string.equals(QUEUE) || string.equals(TOPIC) || string.equals(QUEUE_FACTORY) || string.equals(TOPIC_FACTORY))) {
            throw new CommandValidationException(this.getLocalizedString("InvalidResourceType", new Object[]{string}));
        }
        return true;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        Object object;
        Object object2;
        AppServerInstance appServerInstance = null;
        String string = null;
        AttributeList attributeList = null;
        if (!this.validateOptions()) {
            return;
        }
        try {
            object2 = this.findOption(RESOURCE_TYPE).getValue();
            string = ((Operand)this.getOperands().get(0)).getName();
            attributeList = this.getAttributeList();
            object = this.getServerInstanceManager();
            appServerInstance = ((ServerInstanceManager)object).getServerInstance(this.getInstanceOption());
            appServerInstance.createJMSResource(string, (String)object2);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotCreateJMSResource"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        this.printMessage(this.getLocalizedString("CreatedJMSResource") + " = " + string);
        try {
            if (attributeList != null && !attributeList.isEmpty()) {
                object2 = appServerInstance.getJMSResource(string);
                object = ((ServerComponent)object2).setAttributes(attributeList);
                this.validateAttributeList(attributeList, (AttributeList)object);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("UseDefaultAttribute"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private AttributeList getAttributeList() throws CommandValidationException {
        Serializable serializable;
        AttributeList attributeList = new AttributeList();
        if (this.findOption(ENABLED) != null) {
            serializable = new Attribute(ENABLED, this.getBooleanOptionValue(ENABLED));
            attributeList.add((Attribute)serializable);
        }
        if (this.findOption(DESCRIPTION) != null) {
            serializable = new Attribute(DESCRIPTION, this.getOptionValue(DESCRIPTION));
            attributeList.add((Attribute)serializable);
        }
        serializable = this.getProperties();
        Enumeration<?> enumeration = ((Properties)serializable).propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)((Properties)serializable).get(string);
            Attribute attribute = new Attribute("property." + string, string2);
            attributeList.add(attribute);
            Debug.println("Property(name,value) = " + string + " , " + string2);
        }
        return attributeList;
    }
}

