/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.IiopListener;
import com.iplanet.ias.admin.servermodel.beans.ORBComponentBean;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.StringValidator;
import java.util.Vector;
import javax.management.ObjectName;

public class ORBComponentController
implements Controller {
    private static final String CREATE_IIOP_LISTENER = "createORBListener";
    private static final String DELETE_IIOP_LISTENER = "deleteORBListener";
    private static final String LIST_IIOP_LISTENERS = "listORBListeners";
    private static final String IS_SSL_CREATED = "isSslCreated";
    private static final String CREATE_SSL = "createSsl";
    private static final String DELETE_SSL = "deleteSsl";
    private ORBComponentBean orb;

    public ORBComponentController(ORBComponentBean oRBComponentBean) {
        this.orb = oRBComponentBean;
    }

    public void addIiopListener(String string, String string2) throws AFException {
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.Integer", "java.lang.Boolean"};
        Object[] objectArray = new Object[]{string, string2, null, null};
        this.invoke(CREATE_IIOP_LISTENER, objectArray, stringArray);
    }

    public void removeIiopListener(String string) throws AFException {
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        this.invoke(DELETE_IIOP_LISTENER, objectArray, stringArray);
    }

    public ServerModelIterator getIiopListeners() throws AFException {
        Vector<IiopListener> vector = new Vector<IiopListener>();
        String[] stringArray = (String[])this.invoke(LIST_IIOP_LISTENERS, null, null);
        if (stringArray != null && stringArray.length > 0) {
            String string = null;
            try {
                ObjectName objectName = new ObjectName(this.orb.getIdentifier());
                string = objectName.getKeyProperty("instance-name");
            }
            catch (Exception exception) {
                throw new AFException(exception.getLocalizedMessage());
            }
            int n = 0;
            while (n < stringArray.length) {
                ObjectName objectName = ObjectNames.getIiopListenerObjectName(string, stringArray[n]);
                Assert.assertit(objectName != null, "null value returned");
                IiopListener iiopListener = new IiopListener(objectName.toString(), stringArray[n]);
                vector.add(iiopListener);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public boolean isSSLCreated() throws AFException {
        Object object = this.invoke(IS_SSL_CREATED, null, null);
        Assert.assertit(object != null, "null value returned");
        return (Boolean)object;
    }

    public void createSSL(String string) throws AFException {
        ArgChecker.checkValid(string, "certNickName", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.Boolean", "java.lang.Boolean", "java.lang.Boolean"};
        Object[] objectArray = new Object[]{string, null, null, null, null, null, null, null};
        this.invoke(CREATE_SSL, objectArray, stringArray);
    }

    public void deleteSSL() throws AFException {
        this.invoke(DELETE_SSL, null, null);
    }

    private Object invoke(String string, Object[] objectArray, String[] stringArray) throws AFException {
        try {
            ContextHolder contextHolder = this.orb.getContextHolder();
            ObjectName objectName = new ObjectName(this.orb.getIdentifier());
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            return sOMRequestDispatcher.invoke(objectName, string, objectArray, stringArray);
        }
        catch (Exception exception) {
            if (exception instanceof AFException) {
                throw (AFException)exception;
            }
            throw new AFException(exception.getLocalizedMessage());
        }
    }
}

