/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.beans;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.beans.VirtualServer;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.VirtualServerClassController;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.StringValidator;
import java.io.Serializable;
import javax.management.ObjectName;

public class VirtualServerClass
extends ServerComponent
implements Serializable {
    private transient VirtualServerClassController controller = new VirtualServerClassController(this);

    public VirtualServerClass(String string, String string2) {
        super(string, string2);
    }

    public Controller getController() {
        return this.controller;
    }

    public void createVirtualServer(String string, String string2, String string3) throws AFException {
        this.createVirtualServer(string, string2, string3, null);
    }

    public void createVirtualServer(String string, String string2, String string3, String string4) throws AFException {
        this.controller.createVirtualServer(string, string2, string3, string4);
    }

    public void removeVirtualServer(String string) throws AFException {
        this.controller.removeVirtualServer(string);
    }

    public ServerModelIterator getVirtualServers() throws AFException {
        return this.controller.getVirtualServers();
    }

    public VirtualServer getVirtualServer(String string) throws AFException {
        ArgChecker.checkValid(string, "virtualServerId", StringValidator.getInstance());
        String string2 = this.getInstanceName();
        String string3 = this.getClassId();
        ObjectName objectName = ObjectNames.getVirtualServerObjectName(string2, string3, string);
        Assert.assertit(objectName != null, "null value returned");
        Debug.println("VirtualServerClass.getVirtualServer: mbean = " + objectName);
        VirtualServer virtualServer = new VirtualServer(objectName.toString(), string);
        virtualServer.setContextHolder(this.getContextHolder());
        return virtualServer;
    }

    public boolean isHttpQosCreated() throws AFException {
        return this.controller.isHttpQosCreated();
    }

    public void createHttpQos() throws AFException {
        this.controller.createHttpQos();
    }

    public void removeHttpQos() throws AFException {
        this.controller.removeHttpQos();
    }

    public String getInstanceName() {
        String string = null;
        try {
            String string2 = this.getIdentifier();
            ObjectName objectName = new ObjectName(string2);
            string = objectName.getKeyProperty("instance-name");
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            ExceptionUtil.ignoreException(exception);
        }
        return string;
    }

    public String getClassId() {
        String string = null;
        try {
            String string2 = this.getIdentifier();
            ObjectName objectName = new ObjectName(string2);
            string = objectName.getKeyProperty("name");
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            ExceptionUtil.ignoreException(exception);
        }
        return string;
    }
}

