/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.beans;

import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AccessViolationException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.InvalidAttributeValueException;
import com.iplanet.ias.admin.servermodel.Controllable;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.ConfigurationController;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.ServerComponentController;
import com.iplanet.ias.admin.util.ArgChecker;
import javax.management.AttributeList;

public abstract class ServerComponent
implements Controllable {
    protected final String identifier;
    private String displayName;
    private ContextHolder contextHolder;
    private boolean isChanged = false;
    private transient ConfigurationController configController;

    protected ServerComponent() {
        this.identifier = null;
    }

    protected ServerComponent(String string) {
        ArgChecker.checkValid(string, "identifier");
        this.identifier = string;
        this.configController = new ServerComponentController(this);
    }

    protected ServerComponent(String string, String string2) {
        this(string);
        this.displayName = string2;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public abstract Controller getController();

    public Object getAttribute(String string) throws AttributeNotFoundException, AccessViolationException, AFTargetNotFoundException {
        return this.configController.getAttribute(string);
    }

    public void setAttribute(String string, Object object) throws AttributeNotFoundException, InvalidAttributeValueException, AccessViolationException, AFTargetNotFoundException {
        this.configController.setAttribute(string, object);
    }

    public AttributeList getAttributes(String[] stringArray) throws AFException {
        return this.configController.getAttributes(stringArray);
    }

    public AttributeList setAttributes(AttributeList attributeList) throws AFException {
        return this.configController.setAttributes(attributeList);
    }

    public Object getDefaultAttributeValue(String string) throws AFException {
        return this.configController.getDefaultAttributeValue(string);
    }

    public void applyChanges() throws AFException {
        this.configController.applyChanges();
    }

    public String[] queryAttributeNames() {
        return null;
    }

    public void setContextHolder(ContextHolder contextHolder) {
        this.contextHolder = contextHolder;
    }

    public ContextHolder getContextHolder() {
        return this.contextHolder;
    }

    public String toString() {
        String string = this.displayName != null ? this.displayName : this.identifier;
        return string;
    }
}

