/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.common.domains.registry;

import com.iplanet.ias.admin.common.domains.registry.LockingStore;
import com.iplanet.ias.admin.common.domains.registry.PersistentStore;
import com.iplanet.ias.admin.common.domains.registry.TimeoutException;
import com.iplanet.ias.admin.common.domains.registry.Unlocked;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;

class Locked
implements LockingStore {
    private PersistentStore store;
    private RandomAccessFile raf;

    Locked(PersistentStore persistentStore, RandomAccessFile randomAccessFile) {
        this.checkNotNull(persistentStore, "null store not allowed");
        this.checkNotNull(randomAccessFile, "null Random Access File not allowed");
        this.store = persistentStore;
        this.raf = randomAccessFile;
    }

    public long lastModified() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObject() throws IOException, ClassNotFoundException {
        try {
            Object object = null;
            ObjectInputStream objectInputStream = null;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.store.getStore());
                if (fileInputStream.available() > 0) {
                    objectInputStream = new ObjectInputStream(fileInputStream);
                    object = objectInputStream.readObject();
                } else {
                    object = null;
                    fileInputStream.close();
                }
            }
            catch (EOFException eOFException) {
                object = null;
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            return object;
        }
        catch (IOException iOException) {
            this.unlock();
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.unlock();
            throw classNotFoundException;
        }
    }

    public void writeObject(Object object) throws IOException, IllegalStateException {
        ObjectOutputStream objectOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.store.getStore(), false));
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            this.unlock();
            throw iOException;
        }
        catch (IllegalStateException illegalStateException) {
            this.unlock();
            throw illegalStateException;
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
    }

    public void lock() throws IOException, TimeoutException {
    }

    public void unlock() {
        try {
            this.raf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.store.setState(new Unlocked(this.store));
    }

    protected void finalize() {
        this.unlock();
    }

    private void checkNotNull(Object object, String string) throws NullPointerException {
        if (object == null) {
            throw new NullPointerException(string);
        }
    }
}

