/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.smarticket.ejb.ticketsales;

import com.sun.j2ee.blueprints.smarticket.ejb.ticketsales.Seat;
import com.sun.j2ee.blueprints.smarticket.ejb.ticketsales.SeatingPlan;
import com.sun.j2ee.blueprints.smarticket.ejb.ticketsales.UnavailableSeatsException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class TicketSalesEJB
implements SessionBean {
    protected static final String TICKETSALES_DB = "java:comp/env/jdbc/TicketSalesDataSource";
    protected DataSource dataSource;
    protected String customerID;
    protected int showID;
    protected Set seats;

    public void ejbCreate(String string, int n) {
        this.initDataSources();
        this.customerID = string;
        this.showID = n;
        this.seats = Collections.EMPTY_SET;
    }

    public void ejbRemove() {
        this.dataSource = null;
    }

    public void ejbActivate() {
        this.initDataSources();
    }

    public void ejbPassivate() {
        this.dataSource = null;
    }

    public void setSessionContext(SessionContext sessionContext) {
    }

    protected void initDataSources() {
        try {
            InitialContext initialContext = new InitialContext();
            this.dataSource = (DataSource)initialContext.lookup(TICKETSALES_DB);
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    public SeatingPlan getSeatingPlan() {
        try {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("select t.s_row, t.seats from seating t where t.show_id = ? order by t.s_row");
            preparedStatement.setInt(1, this.showID);
            resultSet = preparedStatement.executeQuery();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(2));
            }
            resultSet.close();
            preparedStatement.close();
            String[] stringArray = arrayList.toArray(new String[0]);
            int n = stringArray.length > 0 ? stringArray[0].length() : 0;
            SeatingPlan seatingPlan = new SeatingPlan(stringArray.length, n);
            int n2 = 0;
            while (n2 < stringArray.length) {
                seatingPlan.setRow(n2, stringArray[n2]);
                ++n2;
            }
            connection.close();
            return seatingPlan;
        }
        catch (SQLException sQLException) {
            throw new EJBException("Error accessing data: " + sQLException.getMessage());
        }
    }

    public boolean reserveSeats(Set set) throws UnavailableSeatsException {
        try {
            Object object;
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            connection = this.dataSource.getConnection();
            this.seats = set;
            preparedStatement = connection.prepareStatement("select t.s_row, t.seats from seating t where t.show_id = ? order by t.s_row");
            preparedStatement.setInt(1, this.showID);
            resultSet = preparedStatement.executeQuery();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(2));
            }
            resultSet.close();
            preparedStatement.close();
            String[] stringArray = arrayList.toArray(new String[0]);
            int n = stringArray.length > 0 ? stringArray[0].length() : 0;
            SeatingPlan seatingPlan = new SeatingPlan(stringArray.length, n);
            int n2 = 0;
            while (n2 < stringArray.length) {
                seatingPlan.setRow(n2, stringArray[n2]);
                ++n2;
            }
            Iterator iterator = this.seats.iterator();
            while (iterator.hasNext()) {
                object = (Seat)iterator.next();
                if (seatingPlan.isAvailable(((Seat)object).row, ((Seat)object).seat)) continue;
                this.seats = Collections.EMPTY_SET;
                throw new UnavailableSeatsException();
            }
            object = this.seats.iterator();
            while (object.hasNext()) {
                Seat seat = (Seat)object.next();
                seatingPlan.setBooked(seat.row, seat.seat);
            }
            preparedStatement = connection.prepareStatement("update seating set seats = ? where show_id = ? and s_row = ?");
            int n3 = 0;
            while (n3 < seatingPlan.getRowCount()) {
                if (seatingPlan.hasBooking(n3)) {
                    int n4 = 0;
                    while (n4 < seatingPlan.getRowLength()) {
                        if (seatingPlan.isBooked(n3, n4)) {
                            seatingPlan.setUnavailable(n3, n4);
                        }
                        ++n4;
                    }
                    preparedStatement.setString(1, seatingPlan.getRow(n3));
                    preparedStatement.setInt(2, this.showID);
                    preparedStatement.setInt(3, n3);
                    preparedStatement.executeUpdate();
                }
                ++n3;
            }
            preparedStatement.close();
            preparedStatement = connection.prepareStatement("insert into reservations (show_id, s_row, seat, username) values (?, ?, ?, ?)");
            Iterator iterator2 = this.seats.iterator();
            while (iterator2.hasNext()) {
                Seat seat = (Seat)iterator2.next();
                preparedStatement.setInt(1, this.showID);
                preparedStatement.setInt(2, seat.row);
                preparedStatement.setInt(3, seat.seat);
                preparedStatement.setString(4, this.customerID);
                preparedStatement.executeUpdate();
            }
            preparedStatement.close();
            connection.close();
            return true;
        }
        catch (SQLException sQLException) {
            throw new EJBException("Error accessing data: " + sQLException.getMessage());
        }
    }

    public boolean cancelSeats() {
        try {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("select t.s_row, t.seats from seating t where t.show_id = ? order by t.s_row");
            preparedStatement.setInt(1, this.showID);
            resultSet = preparedStatement.executeQuery();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(2));
            }
            resultSet.close();
            preparedStatement.close();
            String[] stringArray = arrayList.toArray(new String[0]);
            int n = stringArray.length > 0 ? stringArray[0].length() : 0;
            SeatingPlan seatingPlan = new SeatingPlan(stringArray.length, n);
            int n2 = 0;
            while (n2 < stringArray.length) {
                seatingPlan.setRow(n2, stringArray[n2]);
                ++n2;
            }
            Iterator iterator = this.seats.iterator();
            while (iterator.hasNext()) {
                Seat seat = (Seat)iterator.next();
                seatingPlan.setBooked(seat.row, seat.seat);
            }
            preparedStatement = connection.prepareStatement("update seating set seats = ? where show_id = ? and s_row = ?");
            int n3 = 0;
            while (n3 < seatingPlan.getRowCount()) {
                if (seatingPlan.hasBooking(n3)) {
                    int n4 = 0;
                    while (n4 < seatingPlan.getRowLength()) {
                        if (seatingPlan.isBooked(n3, n4)) {
                            seatingPlan.setAvailable(n3, n4);
                        }
                        ++n4;
                    }
                    preparedStatement.setString(1, seatingPlan.getRow(n3));
                    preparedStatement.setInt(2, this.showID);
                    preparedStatement.setInt(3, n3);
                    preparedStatement.executeUpdate();
                }
                ++n3;
            }
            preparedStatement.close();
            preparedStatement = connection.prepareStatement("delete from reservations where show_id = ? and s_row = ? and seat = ?");
            Iterator iterator2 = this.seats.iterator();
            while (iterator2.hasNext()) {
                Seat seat = (Seat)iterator2.next();
                preparedStatement.setInt(1, this.showID);
                preparedStatement.setInt(2, seat.row);
                preparedStatement.setInt(3, seat.seat);
                preparedStatement.executeUpdate();
            }
            preparedStatement.close();
            connection.close();
            this.seats.clear();
            return true;
        }
        catch (SQLException sQLException) {
            throw new EJBException("Error accessing data: " + sQLException.getMessage());
        }
    }

    public boolean confirmSeats() {
        try {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("delete from reservations where show_id = ? and s_row = ? and seat = ?");
            Iterator iterator = this.seats.iterator();
            while (iterator.hasNext()) {
                Seat seat = (Seat)iterator.next();
                preparedStatement.setInt(1, this.showID);
                preparedStatement.setInt(2, seat.row);
                preparedStatement.setInt(3, seat.seat);
                preparedStatement.executeUpdate();
            }
            preparedStatement.close();
            connection.close();
            this.seats.clear();
            return true;
        }
        catch (SQLException sQLException) {
            throw new EJBException("Error accessing data: " + sQLException.getMessage());
        }
    }
}

