/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.util;

import com.iplanet.ias.admin.server.gui.util.SlashUtil;
import com.iplanet.ias.admin.server.gui.util.XmlNode;
import com.iplanet.ias.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class XmlConfig {
    private static boolean isValidating = true;
    private String xmlFile;
    private File file;
    private long lastModTime = 0L;
    private XmlNode root = null;
    private EntityResolver resolver = null;
    private static StringManager localStrings = StringManager.getManager((Class)(class$com$iplanet$ias$admin$server$gui$util$XmlConfig == null ? (class$com$iplanet$ias$admin$server$gui$util$XmlConfig = XmlConfig.class$("com.iplanet.ias.admin.server.gui.util.XmlConfig")) : class$com$iplanet$ias$admin$server$gui$util$XmlConfig));
    static /* synthetic */ Class class$com$iplanet$ias$admin$server$gui$util$XmlConfig;

    public XmlConfig(String string) {
        this.xmlFile = SlashUtil.de_slashes(string.trim());
        this.file = new File(this.xmlFile);
        this.lastModTime = this.file.lastModified();
    }

    public XmlConfig(String string, String string2, String string3) {
        this(string);
        this.resolver = new WEntityResolver(string2, string3);
    }

    public XmlConfig(String string, HashMap hashMap) {
        this(string);
        this.resolver = new WEntityResolver(hashMap);
    }

    public XmlNode parseConfig() throws Exception {
        return this.parseConfig(null);
    }

    public XmlNode parseConfig(ErrorHandler errorHandler) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("file:");
        int n = this.xmlFile.indexOf(58);
        int n2 = this.xmlFile.indexOf(47);
        if (n != -1 && n < n2) {
            stringBuffer.append('/');
        }
        stringBuffer.append(this.xmlFile);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(false);
        sAXParserFactory.setValidating(isValidating);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        Parser parser = sAXParser.getParser();
        if (this.resolver != null) {
            parser.setEntityResolver(this.resolver);
        }
        this.root = new XmlNode();
        ConfigHandler configHandler = new ConfigHandler(this.xmlFile, this.root);
        parser.setDocumentHandler(configHandler);
        if (errorHandler != null) {
            parser.setErrorHandler(errorHandler);
        }
        parser.parse(stringBuffer.toString());
        return this.root;
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    public boolean fileExists() {
        return this.file.exists();
    }

    public long getLastModified() {
        return this.lastModTime;
    }

    public boolean isModified() {
        return this.file.lastModified() > this.lastModTime;
    }

    public void saveConfig(PrintWriter printWriter) throws IOException {
        XmlNode xmlNode;
        if (this.root != null && (xmlNode = this.root.getFirstChild()) != null) {
            xmlNode.save(printWriter);
        }
    }

    public XmlNode getConfig() {
        return this.root;
    }

    public XmlNode findConfig(String string) {
        XmlNode xmlNode = this.getConfig();
        return xmlNode == null ? null : xmlNode.findConfig(string);
    }

    public String getString(String string, String string2) {
        XmlNode xmlNode = this.findConfig(string);
        return xmlNode == null ? string2 : xmlNode.getString();
    }

    public int getInt(String string, int n) {
        XmlNode xmlNode = this.findConfig(string);
        return xmlNode == null ? n : xmlNode.getInt();
    }

    public int getInterval(String string, int n) {
        XmlNode xmlNode = this.findConfig(string);
        return xmlNode == null ? n : xmlNode.getInterval(string, n);
    }

    public boolean getBoolean(String string, boolean bl) {
        XmlNode xmlNode = this.findConfig(string);
        return xmlNode == null ? bl : xmlNode.getBoolean(string, bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class WEntityResolver
    implements EntityResolver {
        HashMap dtdMap;

        public WEntityResolver(HashMap hashMap) {
            this.dtdMap = hashMap;
        }

        public WEntityResolver(String string, String string2) {
            this.dtdMap = new HashMap(1);
            this.dtdMap.put(string, string2);
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (string != null) {
                String string3 = (String)this.dtdMap.get(string);
                if (string3 != null) {
                    InputStream inputStream = this.getClass().getResourceAsStream(string3);
                    InputSource inputSource = new InputSource(inputStream);
                    return inputSource;
                }
                return null;
            }
            return null;
        }
    }

    static class ConfigHandler
    extends HandlerBase {
        String xmlFile;
        ArrayList elements = new ArrayList();
        XmlNode node;
        Locator locator;
        boolean beginText;

        ConfigHandler(String string, XmlNode xmlNode) {
            this.xmlFile = string;
            this.node = xmlNode;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            XmlNode xmlNode;
            if (this.beginText) {
                String string2 = localStrings.getString("admin.server.gui.util.cannot_have_elements_in_text_block");
                throw this.error(string2);
            }
            this.node = xmlNode = this.node.addChild(string, null, this.locator.getSystemId(), this.locator.getLineNumber());
            int n = 0;
            while (n < attributeList.getLength()) {
                String string3 = attributeList.getName(n);
                String string4 = attributeList.getValue(n);
                XmlNode xmlNode2 = xmlNode.addChild(string3, string4, this.locator.getSystemId(), this.locator.getLineNumber(), true);
                ++n;
            }
            this.beginText = false;
        }

        private boolean isWhitespace(char c) {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            int n3;
            while (n2 > 0) {
                n3 = cArray[n];
                if (n3 != 32 && n3 != 9 && n3 != 10 && n3 != 13) break;
                ++n;
                --n2;
            }
            n3 = 32;
            while (n2 > 0) {
                n3 = cArray[n + n2 - 1];
                if (n3 != 32 && n3 != 9 && n3 != 10 && n3 != 13) break;
                --n2;
            }
            if (n2 <= 0) {
                return;
            }
            if (this.node.getFirstChild() != null) {
                String string = localStrings.getString("admin.server.gui.util.cannot_have_elements_in_text_block");
                throw this.error(string);
            }
            this.node.value = this.node.value == null ? new String(cArray, n, n2) : this.node.value + new String(cArray, n, n2);
            this.beginText = true;
        }

        SAXException error(String string) {
            return new SAXException(this.locator.getSystemId() + ":" + this.locator.getLineNumber() + ": " + string);
        }

        public void endElement(String string) {
            if (this.node != null) {
                this.node = this.node.parentNode;
            }
            this.beginText = false;
        }
    }
}

