/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BucketizedHashtable
implements Cloneable,
Map,
Serializable {
    private int bucketSize;
    private Hashtable[] hashtables = null;

    public BucketizedHashtable(int n, int n2, float f) {
        if (n <= 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.bucketSize = n;
        this.hashtables = new Hashtable[n];
        int n3 = (int)Math.ceil((double)n2 / (double)n);
        int n4 = 0;
        while (n4 < n) {
            this.hashtables[n4] = new Hashtable(n3, f);
            ++n4;
        }
    }

    public BucketizedHashtable(int n, int n2) {
        this(n, n2, 0.75f);
    }

    public BucketizedHashtable(int n) {
        this(n, 11 * n, 0.75f);
    }

    public BucketizedHashtable() {
        this(11, 121, 0.75f);
    }

    public Object get(Object object) {
        return this.hashtables[this.getBucketIndex(object)].get(object);
    }

    public Object remove(Object object) {
        return this.hashtables[this.getBucketIndex(object)].remove(object);
    }

    public Object put(Object object, Object object2) {
        return this.hashtables[this.getBucketIndex(object)].put(object, object2);
    }

    public void putAll(Map map) {
        if (map instanceof BucketizedHashtable) {
            BucketizedHashtable bucketizedHashtable = (BucketizedHashtable)map;
            int n = 0;
            while (n < bucketizedHashtable.bucketSize) {
                this.putAllFromMapWithEntrySet(bucketizedHashtable.hashtables[n]);
                ++n;
            }
        } else {
            this.putAllFromMapWithEntrySet(map);
        }
    }

    public boolean containsKey(Object object) {
        return this.hashtables[this.getBucketIndex(object)].containsKey(object);
    }

    public boolean containsValue(Object object) {
        int n = 0;
        while (n < this.bucketSize) {
            if (this.hashtables[n].containsValue(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public int size() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.bucketSize) {
            n += this.hashtables[n2].size();
            ++n2;
        }
        return n;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.bucketSize) {
            n += this.hashtables[n2].hashCode();
            ++n2;
        }
        return n;
    }

    public boolean isEmpty() {
        int n = 0;
        while (n < this.bucketSize) {
            if (!this.hashtables[n].isEmpty()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void clear() {
        int n = 0;
        while (n < this.bucketSize) {
            this.hashtables[n].clear();
            ++n;
        }
    }

    public Set entrySet() {
        if (this.bucketSize == 1) {
            return this.hashtables[0].entrySet();
        }
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        if (this.bucketSize == 1) {
            return this.hashtables[0].keySet();
        }
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        if (this.bucketSize == 1) {
            return this.hashtables[0].values();
        }
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BucketizedHashtable)) {
            return false;
        }
        BucketizedHashtable bucketizedHashtable = (BucketizedHashtable)object;
        if (bucketizedHashtable.bucketSize != this.bucketSize || bucketizedHashtable.size() != this.size()) {
            return false;
        }
        int n = 0;
        while (n < this.bucketSize) {
            if (!this.hashtables[n].equals(bucketizedHashtable.hashtables[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Object clone() {
        try {
            BucketizedHashtable bucketizedHashtable = (BucketizedHashtable)super.clone();
            bucketizedHashtable.bucketSize = this.bucketSize;
            bucketizedHashtable.hashtables = new Hashtable[this.bucketSize];
            int n = 0;
            while (n < this.bucketSize) {
                bucketizedHashtable.hashtables[n] = (Hashtable)this.hashtables[n].clone();
                ++n;
            }
            return bucketizedHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(this.hashtables[0].toString());
        int n = 1;
        while (n < this.bucketSize) {
            stringBuffer.append(", ");
            stringBuffer.append(this.hashtables[n].toString());
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void putAllFromMapWithEntrySet(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    private int getBucketIndex(Object object) {
        return object.hashCode() % this.bucketSize;
    }
}

