/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.util.type;

import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.FieldInfo;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.Type;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.TypeTable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassType
extends Type {
    protected TypeTable typetab;
    protected Map fieldInfos;
    protected PersistenceClassElement pce;

    public ClassType(String string, Class clazz, int n, TypeTable typeTable) {
        super(string, clazz, n);
        this.typetab = typeTable;
        this.fieldInfos = new HashMap();
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            try {
                this.pce = typeTable.model.getPersistenceClass(string, classLoader);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JDOFatalUserException(illegalArgumentException.getMessage());
            }
        }
    }

    public ClassType(String string, Class clazz, TypeTable typeTable) {
        this(string, clazz, 0, typeTable);
    }

    public boolean isCompatibleWith(Type type) {
        boolean bl = false;
        if (type instanceof ClassType) {
            bl = ((ClassType)type).clazz.isAssignableFrom(this.clazz);
        }
        return bl;
    }

    public boolean isOrderable() {
        Type type = this.typetab.checkType("java.lang.Comparable");
        return this.isCompatibleWith(type);
    }

    public boolean isPersistenceCapable() {
        return this.pce != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfo[] getFieldInfos() {
        final Class clazz = this.clazz;
        Field[] fieldArray = (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredFields();
            }
        });
        Map map = this.fieldInfos;
        synchronized (map) {
            int n = 0;
            while (n < fieldArray.length) {
                String string = fieldArray[n].getName();
                FieldInfo fieldInfo = (FieldInfo)this.fieldInfos.get(string);
                if (fieldInfo == null) {
                    this.fieldInfos.put(string, new FieldInfo(fieldArray[n], this));
                }
                ++n;
            }
        }
        return this.fieldInfos.values().toArray(new FieldInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfo getFieldInfo(String string) {
        Map map = this.fieldInfos;
        synchronized (map) {
            Class clazz;
            Field field;
            FieldInfo fieldInfo = (FieldInfo)this.fieldInfos.get(string);
            if (fieldInfo == null && (field = (Field)AccessController.doPrivileged(new PrivilegedAction(clazz = this.clazz, string){
                private final /* synthetic */ Class val$cl;
                private final /* synthetic */ String val$fieldName;
                {
                    this.val$cl = clazz;
                    this.val$fieldName = string;
                }

                public Object run() {
                    try {
                        return this.val$cl.getDeclaredField(this.val$fieldName);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        return null;
                    }
                }
            })) != null) {
                fieldInfo = new FieldInfo(field, this);
                this.fieldInfos.put(string, fieldInfo);
            }
            return fieldInfo;
        }
    }

    public List getKeyFieldNames() {
        if (this.pce != null) {
            PersistenceFieldElement[] persistenceFieldElementArray = this.pce.getFields();
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            while (n < persistenceFieldElementArray.length) {
                if (persistenceFieldElementArray[n].isKey()) {
                    arrayList.add(persistenceFieldElementArray[n].getName());
                }
                ++n;
            }
            return arrayList;
        }
        return null;
    }
}

