/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc;

import antlr.ASTPair;
import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.TreeParser;
import antlr.collections.AST;
import antlr.collections.impl.BitSet;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ErrorMsg;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLAST;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ParameterTable;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.SemanticTokenTypes;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.VariableTable;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope.Definition;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope.Field;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope.Parameter;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope.SymbolTable;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope.TypeName;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope.Variable;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.ClassType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.FieldInfo;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.NumericType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.NumericWrapperClassType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.Type;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.TypeTable;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.util.ResourceBundle;

public class Semantic
extends TreeParser
implements SemanticTokenTypes {
    protected static final ResourceBundle messages = I18NHelper.loadBundle(class$com$sun$jdo$spi$persistence$support$sqlstore$query$jqlc$Semantic == null ? (class$com$sun$jdo$spi$persistence$support$sqlstore$query$jqlc$Semantic = Semantic.class$("com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.Semantic")) : class$com$sun$jdo$spi$persistence$support$sqlstore$query$jqlc$Semantic);
    protected SymbolTable symtab;
    protected SymbolTable typeNames;
    protected TypeTable typetab;
    protected ParameterTable paramtab;
    protected VariableTable vartab;
    protected ErrorMsg errorMsg;
    protected ClassType candidateClass;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"import\"", "\"this\"", "\"ascending\"", "\"descending\"", "\"distinct\"", "\"boolean\"", "\"byte\"", "\"char\"", "\"short\"", "\"int\"", "\"float\"", "\"long\"", "\"double\"", "\"null\"", "\"true\"", "\"false\"", "LPAREN", "RPAREN", "COMMA", "EQUAL", "LNOT", "BNOT", "NOT_EQUAL", "DIV", "PLUS", "MINUS", "STAR", "MOD", "GE", "GT", "LE", "LT", "BXOR", "BOR", "OR", "BAND", "AND", "SEMI", "WS", "NEWLINE", "CHAR_LITERAL", "STRING_LITERAL", "ESC", "HEX_DIGIT", "INT_LITERAL", "EXPONENT", "FLOAT_SUFFIX", "DOUBLE_SUFFIX", "an identifier", "UNICODE_DIGIT", "UNICODE_STR", "QUERY", "CLASS_DEF", "IMPORT_DEF", "PARAMETER_DEF", "VARIABLE_DEF", "ORDERING_DEF", "FILTER_DEF", "ARG_LIST", "UNARY_MINUS", "UNARY_PLUS", "TYPECAST", "OBJECT_EQUAL", "OBJECT_NOT_EQUAL", "COLLECTION_EQUAL", "COLLECTION_NOT_EQUAL", "CONCAT", "FIELD_ACCESS", "STATIC_FIELD_ACCESS", "CONTAINS", "NOT_CONTAINS", "NAVIGATION", "STARTS_WITH", "ENDS_WITH", "IS_EMPTY", "VARIABLE", "PARAMETER", "TYPENAME", "VALUE", "RESULT_DEF", "LIKE", "SUBSTRING", "INDEXOF", "LENGTH", "ABS", "SQRT", "NOT_IN", "DOT", "LONG_LITERAL", "FLOAT_LITERAL", "DOUBLE_LITERAL"};
    private static final long[] _tokenSet_0_data_ = new long[]{-9218531986676776928L, 2013265923L, 0L, 0L};
    public static final BitSet _tokenSet_0 = new BitSet(_tokenSet_0_data_);
    static /* synthetic */ Class class$com$sun$jdo$spi$persistence$support$sqlstore$query$jqlc$Semantic;

    public void init(TypeTable typeTable, ParameterTable parameterTable, ErrorMsg errorMsg) {
        this.symtab = new SymbolTable();
        this.typeNames = new SymbolTable();
        this.vartab = new VariableTable(errorMsg);
        this.typetab = typeTable;
        this.paramtab = parameterTable;
        this.errorMsg = errorMsg;
    }

    public void reportError(RecognitionException recognitionException) {
        this.errorMsg.fatal("Error: " + recognitionException);
    }

    public void reportError(String string) {
        this.errorMsg.fatal("Error: " + string);
    }

    public JQLAST createQueryAST(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3, JQLAST jQLAST4, JQLAST jQLAST5, JQLAST jQLAST6, JQLAST jQLAST7) {
        JQLAST jQLAST8 = new JQLAST(55, "query", null);
        if (jQLAST != null) {
            jQLAST8.addChild(jQLAST);
        }
        if (jQLAST2 != null) {
            jQLAST8.addChild(jQLAST2);
        }
        if (jQLAST3 != null) {
            jQLAST8.addChild(jQLAST3);
        }
        if (jQLAST4 != null) {
            jQLAST8.addChild(jQLAST4);
        }
        if (jQLAST5 != null) {
            jQLAST8.addChild(jQLAST5);
        }
        if (jQLAST6 != null) {
            jQLAST8.addChild(jQLAST6);
        }
        if (jQLAST7 != null) {
            jQLAST8.addChild(jQLAST7);
        }
        return jQLAST8;
    }

    public JQLAST checkCandidateClass(Class clazz) {
        Type type = this.typetab.checkType(clazz);
        if (type == null) {
            this.errorMsg.fatal("Semantic.checkCandidateClass: unknown type " + clazz);
        }
        return new JQLAST(56, "classDef", type);
    }

    protected void analyseOrderingExpression(JQLAST jQLAST) {
        this.checkValidOrderingExpr(jQLAST);
        Type type = jQLAST.getJQLType();
        if (!type.isOrderable()) {
            this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.analyseorderingexpression.notorderable", type.getName()));
            jQLAST.setJQLType(TypeTable.errorType);
        }
    }

    private void checkValidOrderingExpr(JQLAST jQLAST) {
        switch (jQLAST.getType()) {
            case 5: {
                break;
            }
            case 71: 
            case 75: {
                JQLAST jQLAST2 = (JQLAST)jQLAST.getFirstChild();
                if (jQLAST2 == null) break;
                this.checkValidOrderingExpr(jQLAST2);
                break;
            }
            default: {
                this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.checkvalidorderingexpr.invalidordering", jQLAST.getText()));
            }
        }
    }

    private void checkValidResultExpr(JQLAST jQLAST) {
        switch (jQLAST.getType()) {
            case 5: {
                break;
            }
            case 71: 
            case 75: {
                JQLAST jQLAST2 = (JQLAST)jQLAST.getFirstChild();
                if (jQLAST2 == null) break;
                this.checkValidResultExpr(jQLAST2);
                break;
            }
            case 79: {
                break;
            }
            default: {
                this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.checkvalidresultexpr.invalidresult", jQLAST.getText()));
            }
        }
    }

    protected JQLAST analyseDotExpr(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3, JQLAST jQLAST4) {
        Type type = jQLAST2.getJQLType();
        String string = jQLAST3.getText();
        jQLAST.setText(jQLAST2.getText() + '.' + string);
        if (type instanceof ClassType) {
            ClassType classType = (ClassType)type;
            if (jQLAST4 == null) {
                FieldInfo fieldInfo = classType.getFieldInfo(string);
                if (fieldInfo == null) {
                    this.errorMsg.error(jQLAST3.getLine(), jQLAST3.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.unknownfield", jQLAST3.getText(), type.getName()));
                    jQLAST.setJQLType(TypeTable.errorType);
                    jQLAST3.setJQLType(TypeTable.errorType);
                    return jQLAST;
                }
                if (jQLAST2.getType() == 81) {
                    return this.analyseStaticFieldAccess(jQLAST, jQLAST2, jQLAST3, classType, fieldInfo);
                }
                return this.analyseFieldAccess(jQLAST, jQLAST2, jQLAST3, classType, fieldInfo);
            }
            if (this.typetab.isCollectionType(type)) {
                return this.analyseCollectionCall(jQLAST, jQLAST2, jQLAST3, jQLAST4);
            }
            if (type.equals(this.typetab.stringType)) {
                return this.analyseStringCall(jQLAST, jQLAST2, jQLAST3, jQLAST4);
            }
            if (this.typetab.isJavaLangMathType(type)) {
                return this.analyseMathCall(jQLAST, jQLAST2, jQLAST3, jQLAST4);
            }
            this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.invalidmethodcall"));
            jQLAST.setJQLType(TypeTable.errorType);
            return jQLAST;
        }
        this.errorMsg.error(jQLAST2.getLine(), jQLAST2.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.analysedotexpr.classexprexpected", jQLAST3.getText(), type.getName()));
        jQLAST.setJQLType(TypeTable.errorType);
        return jQLAST;
    }

    protected JQLAST analyseFieldAccess(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3, ClassType classType, FieldInfo fieldInfo) {
        String string = jQLAST3.getText();
        Type type = fieldInfo.getType();
        if (classType.isPersistenceCapable()) {
            if (!fieldInfo.isPersistent()) {
                this.errorMsg.error(jQLAST3.getLine(), jQLAST3.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.analysefieldaccess.nonperistentfield", string, classType.getName()));
            }
            if (this.typetab.isPersistenceCapableType(type)) {
                jQLAST.setType(75);
            } else {
                jQLAST.setType(71);
            }
        } else {
            if (!fieldInfo.isPublic()) {
                this.errorMsg.error(jQLAST3.getLine(), jQLAST3.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.analysefieldaccess.nonpublicfield", string, classType.getName()));
            }
            jQLAST.setType(71);
        }
        jQLAST.setText(jQLAST2.getText() + '.' + string);
        jQLAST.setJQLType(type);
        jQLAST3.setJQLType(type);
        jQLAST.setFirstChild(jQLAST2);
        jQLAST2.setNextSibling(jQLAST3);
        return jQLAST;
    }

    protected JQLAST analyseStaticFieldAccess(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3, ClassType classType, FieldInfo fieldInfo) {
        String string = jQLAST3.getText();
        Type type = fieldInfo.getType();
        if (!fieldInfo.isStatic()) {
            this.errorMsg.error(jQLAST3.getLine(), jQLAST3.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.analysestaticfieldaccess.staticreference", jQLAST3.getText(), classType.getName()));
        }
        if (!fieldInfo.isPublic()) {
            this.errorMsg.error(jQLAST3.getLine(), jQLAST3.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.analysestaticfieldaccess.nonpublicfield", string, classType.getName()));
        }
        jQLAST.setType(72);
        jQLAST.setText(jQLAST2.getText() + '.' + string);
        jQLAST.setJQLType(type);
        jQLAST3.setJQLType(type);
        jQLAST.setFirstChild(jQLAST2);
        jQLAST2.setNextSibling(jQLAST3);
        return jQLAST;
    }

    protected JQLAST analyseDefinedIdentifier(JQLAST jQLAST, Definition definition) {
        Type type = definition.getType();
        if (definition instanceof Variable) {
            jQLAST.setType(79);
        } else if (definition instanceof Parameter) {
            jQLAST.setType(80);
        } else if (definition instanceof Field) {
            FieldInfo fieldInfo = ((Field)definition).getFieldInfo();
            JQLAST jQLAST2 = jQLAST;
            JQLAST jQLAST3 = new JQLAST(jQLAST);
            if (fieldInfo.isStatic()) {
                JQLAST jQLAST4 = new JQLAST(81, this.candidateClass.getName(), this.candidateClass);
                jQLAST = this.analyseStaticFieldAccess(jQLAST2, jQLAST4, jQLAST3, this.candidateClass, fieldInfo);
            } else {
                JQLAST jQLAST5 = new JQLAST(5, "this", this.candidateClass);
                jQLAST = this.analyseFieldAccess(jQLAST2, jQLAST5, jQLAST3, this.candidateClass, fieldInfo);
            }
        } else if (definition instanceof TypeName) {
            jQLAST.setType(81);
            jQLAST.setText(((TypeName)definition).getQualifiedName());
        } else {
            type = TypeTable.errorType;
            this.errorMsg.fatal("Semantic.analyseDefinedIdentifier: illegal identifier definition " + definition);
        }
        jQLAST.setJQLType(type);
        return jQLAST;
    }

    protected JQLAST analyseCollectionCall(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3, JQLAST jQLAST4) {
        String string = jQLAST3.getText();
        JQLAST jQLAST5 = (JQLAST)jQLAST4.getFirstChild();
        if (string.equals("contains")) {
            this.checkContainsArgs(jQLAST2, jQLAST3, jQLAST5);
            jQLAST.setType(73);
            jQLAST.setJQLType(this.typetab.booleanType);
            jQLAST.setFirstChild(jQLAST2);
            jQLAST2.setNextSibling(jQLAST5);
            return jQLAST;
        }
        if (string.equals("isEmpty")) {
            this.checkNoArgs(jQLAST3, jQLAST5);
            jQLAST.setType(78);
            jQLAST.setJQLType(this.typetab.booleanType);
            jQLAST.setFirstChild(jQLAST2);
            jQLAST2.setNextSibling(null);
            return jQLAST;
        }
        this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.invalidmethodcall"));
        jQLAST.setJQLType(TypeTable.errorType);
        return jQLAST;
    }

    protected JQLAST analyseStringCall(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3, JQLAST jQLAST4) {
        String string = jQLAST3.getText();
        JQLAST jQLAST5 = (JQLAST)jQLAST4.getFirstChild();
        if (string.equals("startsWith")) {
            jQLAST.setType(76);
            this.checkOneStringArg(jQLAST3, jQLAST5);
            jQLAST.setJQLType(this.typetab.booleanType);
            jQLAST.setFirstChild(jQLAST2);
            jQLAST2.setNextSibling(jQLAST5);
        } else if (string.equals("endsWith")) {
            jQLAST.setType(77);
            this.checkOneStringArg(jQLAST3, jQLAST5);
            jQLAST.setJQLType(this.typetab.booleanType);
            jQLAST.setFirstChild(jQLAST2);
            jQLAST2.setNextSibling(jQLAST5);
        } else if (string.equals("like")) {
            this.checkLikeArgs(jQLAST3, jQLAST5);
            jQLAST.setType(84);
            jQLAST.setJQLType(this.typetab.booleanType);
            jQLAST.setFirstChild(jQLAST2);
            jQLAST2.setNextSibling(jQLAST5);
        } else if (string.equals("substring")) {
            this.checkTwoIntArgs(jQLAST3, jQLAST5);
            jQLAST.setType(85);
            jQLAST.setJQLType(this.typetab.stringType);
            jQLAST.setFirstChild(jQLAST2);
            jQLAST2.setNextSibling(jQLAST5);
        } else if (string.equals("indexOf")) {
            this.checkIndexOfArgs(jQLAST3, jQLAST5);
            jQLAST.setType(86);
            jQLAST.setJQLType(this.typetab.intType);
            jQLAST.setFirstChild(jQLAST2);
            jQLAST2.setNextSibling(jQLAST5);
        } else if (string.equals("length")) {
            this.checkNoArgs(jQLAST3, jQLAST5);
            jQLAST.setType(87);
            jQLAST.setJQLType(this.typetab.intType);
            jQLAST.setFirstChild(jQLAST2);
            jQLAST2.setNextSibling(null);
        } else {
            this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.invalidmethodcall"));
            jQLAST.setJQLType(TypeTable.errorType);
        }
        return jQLAST;
    }

    protected JQLAST analyseMathCall(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3, JQLAST jQLAST4) {
        String string = jQLAST3.getText();
        JQLAST jQLAST5 = (JQLAST)jQLAST4.getFirstChild();
        if (string.equals("abs")) {
            this.checkAbsArgs(jQLAST3, jQLAST5);
            jQLAST.setType(88);
            jQLAST.setJQLType(jQLAST5.getJQLType());
            jQLAST.setFirstChild(jQLAST5);
        } else if (string.equals("sqrt")) {
            this.checkSqrtArgs(jQLAST3, jQLAST5);
            jQLAST.setType(89);
            jQLAST.setJQLType(jQLAST5.getJQLType());
            jQLAST.setFirstChild(jQLAST5);
        } else {
            this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.invalidmethodcall"));
            jQLAST.setJQLType(TypeTable.errorType);
        }
        return jQLAST;
    }

    protected void checkNoArgs(JQLAST jQLAST, JQLAST jQLAST2) {
        if (jQLAST2 != null) {
            this.errorMsg.error(jQLAST2.getLine(), jQLAST2.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.numbermismatch"));
        }
    }

    protected void checkOneStringArg(JQLAST jQLAST, JQLAST jQLAST2) {
        if (jQLAST2 == null) {
            this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.numbermismatch"));
        } else if (jQLAST2.getNextSibling() != null) {
            JQLAST jQLAST3 = (JQLAST)jQLAST2.getNextSibling();
            this.errorMsg.error(jQLAST3.getLine(), jQLAST3.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.numbermismatch"));
        } else {
            Type type = jQLAST2.getJQLType();
            if (!type.equals(this.typetab.stringType)) {
                this.errorMsg.error(jQLAST2.getLine(), jQLAST2.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.typemismatch", type.getName(), this.typetab.stringType.getName()));
            }
        }
    }

    protected void checkContainsArgs(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3) {
        if (jQLAST3 == null) {
            this.errorMsg.error(jQLAST2.getLine(), jQLAST2.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.numbermismatch"));
        } else if (jQLAST3.getNextSibling() != null) {
            JQLAST jQLAST4 = (JQLAST)jQLAST3.getNextSibling();
            this.errorMsg.error(jQLAST4.getLine(), jQLAST4.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.numbermismatch"));
        } else if (jQLAST3.getType() != 79) {
            this.errorMsg.unsupported(jQLAST3.getLine(), jQLAST3.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.analysecollectioncall.nonvariable"));
        } else {
            FieldInfo fieldInfo = this.getCollectionField(jQLAST);
            if (fieldInfo == null) {
                this.errorMsg.unsupported(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.analysecollectioncall.unsupportedcollectionexpr", jQLAST.getText()));
            } else if (!fieldInfo.isRelationship()) {
                this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.analysecollectioncall.relationshipexpected", fieldInfo.getName()));
            }
            Type type = jQLAST3.getJQLType();
            Type type2 = fieldInfo.getAssociatedClass();
            if (!type2.isCompatibleWith(type)) {
                this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.analysecollectioncall.typemismatch", type2.getName(), type.getName()));
            }
        }
    }

    protected void checkLikeArgs(JQLAST jQLAST, JQLAST jQLAST2) {
        if (jQLAST2 == null) {
            this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.numbermismatch"));
        } else if (jQLAST2.getNextSibling() != null && jQLAST2.getNextSibling().getNextSibling() != null) {
            JQLAST jQLAST3 = (JQLAST)jQLAST2.getNextSibling().getNextSibling();
            this.errorMsg.error(jQLAST3.getLine(), jQLAST3.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.numbermismatch"));
        } else {
            Type type;
            JQLAST jQLAST4;
            Type type2 = jQLAST2.getJQLType();
            if (!type2.equals(this.typetab.stringType)) {
                this.errorMsg.error(jQLAST2.getLine(), jQLAST2.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.typemismatch", type2.getName(), this.typetab.stringType.getName()));
            }
            if ((jQLAST4 = (JQLAST)jQLAST2.getNextSibling()) != null && !this.typetab.isCharType(type = jQLAST4.getJQLType())) {
                this.errorMsg.error(jQLAST4.getLine(), jQLAST4.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.typemismatch", type.getName(), this.typetab.charType.getName()));
            }
        }
    }

    protected void checkTwoIntArgs(JQLAST jQLAST, JQLAST jQLAST2) {
        if (jQLAST2 == null) {
            this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.numbermismatch"));
        } else if (jQLAST2.getNextSibling() == null) {
            this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.numbermismatch"));
        } else if (jQLAST2.getNextSibling().getNextSibling() != null) {
            JQLAST jQLAST3 = (JQLAST)jQLAST2.getNextSibling().getNextSibling();
            this.errorMsg.error(jQLAST3.getLine(), jQLAST3.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.numbermismatch"));
        } else {
            Type type = jQLAST2.getJQLType();
            if (!this.typetab.isIntType(type)) {
                this.errorMsg.error(jQLAST2.getLine(), jQLAST2.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.typemismatch", type.getName(), this.typetab.intType.getName()));
            }
            JQLAST jQLAST4 = (JQLAST)jQLAST2.getNextSibling();
            Type type2 = jQLAST2.getJQLType();
            if (!this.typetab.isIntType(type2)) {
                this.errorMsg.error(jQLAST4.getLine(), jQLAST4.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.typemismatch", type2.getName(), this.typetab.intType.getName()));
            }
        }
    }

    protected void checkIndexOfArgs(JQLAST jQLAST, JQLAST jQLAST2) {
        if (jQLAST2 == null) {
            this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.numbermismatch"));
        } else if (jQLAST2.getNextSibling() != null && jQLAST2.getNextSibling().getNextSibling() != null) {
            JQLAST jQLAST3 = (JQLAST)jQLAST2.getNextSibling().getNextSibling();
            this.errorMsg.error(jQLAST3.getLine(), jQLAST3.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.numbermismatch"));
        } else {
            Type type;
            JQLAST jQLAST4;
            Type type2 = jQLAST2.getJQLType();
            if (!type2.equals(this.typetab.stringType)) {
                this.errorMsg.error(jQLAST2.getLine(), jQLAST2.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.typemismatch", type2.getName(), this.typetab.stringType.getName()));
            }
            if ((jQLAST4 = (JQLAST)jQLAST2.getNextSibling()) != null && !this.typetab.isIntType(type = jQLAST4.getJQLType())) {
                this.errorMsg.error(jQLAST4.getLine(), jQLAST4.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.typemismatch", type.getName(), this.typetab.intType.getName()));
            }
        }
    }

    protected void checkAbsArgs(JQLAST jQLAST, JQLAST jQLAST2) {
        if (jQLAST2 == null) {
            this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.numbermismatch"));
        } else if (jQLAST2.getNextSibling() != null) {
            JQLAST jQLAST3 = (JQLAST)jQLAST2.getNextSibling();
            this.errorMsg.error(jQLAST3.getLine(), jQLAST3.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.numbermismatch"));
        } else {
            Type type = jQLAST2.getJQLType();
            if (!this.typetab.isNumberType(type)) {
                this.errorMsg.error(jQLAST2.getLine(), jQLAST2.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.typemismatch", type.getName(), "number type"));
            }
        }
    }

    protected void checkSqrtArgs(JQLAST jQLAST, JQLAST jQLAST2) {
        if (jQLAST2 == null) {
            this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.numbermismatch"));
        } else if (jQLAST2.getNextSibling() != null) {
            JQLAST jQLAST3 = (JQLAST)jQLAST2.getNextSibling();
            this.errorMsg.error(jQLAST3.getLine(), jQLAST3.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.numbermismatch"));
        } else {
            Type type = jQLAST2.getJQLType();
            if (!this.typetab.isDoubleType(type)) {
                this.errorMsg.error(jQLAST2.getLine(), jQLAST2.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.typemismatch", type.getName(), "double or Double"));
            }
        }
    }

    protected FieldInfo getCollectionField(JQLAST jQLAST) {
        JQLAST jQLAST2 = (JQLAST)jQLAST.getFirstChild();
        switch (jQLAST.getType()) {
            case 71: 
            case 75: {
                if (jQLAST2 != null && jQLAST2.getNextSibling() != null) {
                    ClassType classType = (ClassType)jQLAST2.getJQLType();
                    String string = jQLAST2.getNextSibling().getText();
                    return classType.getFieldInfo(string);
                }
                this.errorMsg.fatal("Semantic.getCollectionField: invalid node structure childs missing");
                break;
            }
            case 65: {
                if (jQLAST2 != null && jQLAST2.getNextSibling() != null) {
                    return this.getCollectionField((JQLAST)jQLAST2.getNextSibling());
                }
                this.errorMsg.fatal("Semantic.getCollectionField: invalid node structure childs missing");
            }
        }
        return null;
    }

    protected Type analyseBitwiseExpr(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3) {
        Type type;
        Type type2;
        block10: {
            block9: {
                type2 = jQLAST2.getJQLType();
                type = jQLAST3.getJQLType();
                if (type2.equals(TypeTable.errorType)) break block9;
                if (!type.equals(TypeTable.errorType)) break block10;
            }
            return TypeTable.errorType;
        }
        switch (jQLAST.getType()) {
            case 37: 
            case 39: {
                if (this.typetab.isBooleanType(type2) && this.typetab.isBooleanType(type)) {
                    return this.typetab.booleanType;
                }
                if (!this.typetab.isIntegralType(type2) && !this.typetab.isIntegralType(type)) break;
                this.errorMsg.unsupported(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.analysebitwiseexpr.integerbitwiseop", jQLAST.getText()));
                return TypeTable.errorType;
            }
            case 36: {
                if (this.typetab.isBooleanType(type2) && this.typetab.isBooleanType(type)) {
                    this.errorMsg.unsupported(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.analysebitwiseexpr.exclusiveorop"));
                    return TypeTable.errorType;
                }
                if (!this.typetab.isIntegralType(type2) && !this.typetab.isIntegralType(type)) break;
                this.errorMsg.unsupported(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.analysebitwiseexpr.integerbitwiseop", jQLAST.getText()));
                return TypeTable.errorType;
            }
        }
        this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.invalid", jQLAST.getText()));
        return TypeTable.errorType;
    }

    protected Type analyseConditionalExpr(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3) {
        Type type;
        Type type2;
        block6: {
            block5: {
                type2 = jQLAST2.getJQLType();
                type = jQLAST3.getJQLType();
                if (type2.equals(TypeTable.errorType)) break block5;
                if (!type.equals(TypeTable.errorType)) break block6;
            }
            return TypeTable.errorType;
        }
        switch (jQLAST.getType()) {
            case 38: 
            case 40: {
                if (!this.typetab.isBooleanType(type2) || !this.typetab.isBooleanType(type)) break;
                return this.typetab.booleanType;
            }
        }
        this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.invalid", jQLAST.getText()));
        return TypeTable.errorType;
    }

    protected Type analyseRelationalExpr(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3) {
        Type type;
        Type type2;
        block12: {
            block11: {
                type2 = jQLAST2.getJQLType();
                type = jQLAST3.getJQLType();
                if (type2.equals(TypeTable.errorType)) break block11;
                if (!type.equals(TypeTable.errorType)) break block12;
            }
            return TypeTable.errorType;
        }
        switch (jQLAST.getType()) {
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                if (!type2.isOrderable()) {
                    this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.analyserelationalexpr.notorderable", type2.getName(), jQLAST.getText()));
                    return TypeTable.errorType;
                }
                if (type.isOrderable()) break;
                this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.analyserelationalexpr.notorderable", type.getName(), jQLAST.getText()));
                return TypeTable.errorType;
            }
            case 23: 
            case 26: {
                if (jQLAST2.getType() != 73 && jQLAST3.getType() != 73) break;
                this.errorMsg.unsupported(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.unsupportedconstraintop", jQLAST.getText()));
                return TypeTable.errorType;
            }
        }
        if (this.typetab.isNumberType(type2) && this.typetab.isNumberType(type)) {
            return this.typetab.booleanType;
        }
        if (this.typetab.isBooleanType(type2) && this.typetab.isBooleanType(type)) {
            return this.typetab.booleanType;
        }
        if (type2.isCompatibleWith(type) || type.isCompatibleWith(type2)) {
            return this.typetab.booleanType;
        }
        this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.invalid", jQLAST.getText()));
        return TypeTable.errorType;
    }

    protected Type analyseBinaryArithmeticExpr(JQLAST jQLAST, JQLAST jQLAST2, JQLAST jQLAST3) {
        Type type;
        Type type2;
        block16: {
            block15: {
                type2 = jQLAST2.getJQLType();
                type = jQLAST3.getJQLType();
                if (type2.equals(TypeTable.errorType)) break block15;
                if (!type.equals(TypeTable.errorType)) break block16;
            }
            return TypeTable.errorType;
        }
        if (this.typetab.isNumberType(type2) && this.typetab.isNumberType(type)) {
            if (type2.isCompatibleWith(this.typetab.bigDecimalType)) {
                return type2;
            }
            if (type.isCompatibleWith(this.typetab.bigDecimalType)) {
                return type;
            }
            if (type2.isCompatibleWith(this.typetab.bigIntegerType)) {
                return this.typetab.isFloatingPointType(type) ? this.typetab.bigDecimalType : type2;
            }
            if (type.isCompatibleWith(this.typetab.bigIntegerType)) {
                return this.typetab.isFloatingPointType(type2) ? this.typetab.bigDecimalType : type;
            }
            boolean bl = false;
            if (type2 instanceof NumericWrapperClassType) {
                type2 = ((NumericWrapperClassType)type2).getPrimitiveType();
                bl = true;
            }
            if (type instanceof NumericWrapperClassType) {
                type = ((NumericWrapperClassType)type).getPrimitiveType();
                bl = true;
            }
            if (type2 instanceof NumericType && type instanceof NumericType) {
                Type type3 = this.typetab.binaryNumericPromotion(type2, type);
                if (bl && type3 instanceof NumericType) {
                    type3 = ((NumericType)type3).getWrapper();
                }
                return type3;
            }
        } else if (jQLAST.getType() == 28 && (type2.equals(this.typetab.stringType) || type2.equals(this.typetab.charType)) && (type.equals(this.typetab.stringType) || type.equals(this.typetab.charType))) {
            return this.typetab.stringType;
        }
        this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.invalid", jQLAST.getText()));
        return TypeTable.errorType;
    }

    protected Type analyseUnaryArithmeticExpr(JQLAST jQLAST, JQLAST jQLAST2) {
        Type type = jQLAST2.getJQLType();
        if (type.equals(TypeTable.errorType)) {
            return TypeTable.errorType;
        }
        if (type.isCompatibleWith(this.typetab.bigDecimalType)) {
            return type;
        }
        if (type.isCompatibleWith(this.typetab.bigIntegerType)) {
            return type;
        }
        boolean bl = false;
        if (type instanceof NumericWrapperClassType) {
            type = ((NumericWrapperClassType)type).getPrimitiveType();
            bl = true;
        }
        if (type instanceof NumericType) {
            Type type2 = this.typetab.unaryNumericPromotion(type);
            if (bl && type2 instanceof NumericType) {
                type2 = ((NumericType)type2).getWrapper();
            }
            return type2;
        }
        this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.invalid", jQLAST.getText()));
        return TypeTable.errorType;
    }

    protected Type analyseComplementExpr(JQLAST jQLAST, JQLAST jQLAST2) {
        Type type = jQLAST2.getJQLType();
        if (type.equals(TypeTable.errorType)) {
            return TypeTable.errorType;
        }
        switch (jQLAST.getType()) {
            case 25: {
                if (!this.typetab.isIntegralType(type)) break;
                return type;
            }
            case 24: {
                if (!this.typetab.isBooleanType(type)) break;
                if (jQLAST2.getType() == 73) {
                    this.errorMsg.unsupported(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.unsupportedconstraintop", jQLAST.getText()));
                    return TypeTable.errorType;
                }
                return type;
            }
        }
        this.errorMsg.error(jQLAST.getLine(), jQLAST.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.arguments.invalid", jQLAST.getText()));
        return TypeTable.errorType;
    }

    protected void checkConstraints(JQLAST jQLAST, VariableTable variableTable) {
        this.checkConstraints(jQLAST, null, variableTable);
    }

    protected void checkConstraints(JQLAST jQLAST, String string, VariableTable variableTable) {
        if (jQLAST == null) {
            return;
        }
        switch (jQLAST.getType()) {
            case 79: {
                variableTable.markUsed(jQLAST, string);
                break;
            }
            case 73: {
                JQLAST jQLAST2 = (JQLAST)jQLAST.getFirstChild();
                JQLAST jQLAST3 = (JQLAST)jQLAST2.getNextSibling();
                this.checkConstraints(jQLAST2, jQLAST3.getText(), variableTable);
                variableTable.markConstraint(jQLAST3, jQLAST2);
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                JQLAST jQLAST4 = (JQLAST)jQLAST.getFirstChild();
                JQLAST jQLAST5 = (JQLAST)jQLAST4.getNextSibling();
                VariableTable variableTable2 = new VariableTable(variableTable);
                this.checkConstraints(jQLAST4, string, variableTable);
                this.checkConstraints(jQLAST5, string, variableTable2);
                variableTable.merge(variableTable2);
                break;
            }
            default: {
                JQLAST jQLAST6 = (JQLAST)jQLAST.getFirstChild();
                while (jQLAST6 != null) {
                    this.checkConstraints(jQLAST6, string, variableTable);
                    jQLAST6 = (JQLAST)jQLAST6.getNextSibling();
                }
                break block0;
            }
        }
    }

    public Semantic() {
        this.tokenNames = _tokenNames;
    }

    public final void query(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        AST aST2 = aST;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST4 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST3);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 55);
        aST = aST.getFirstChild();
        this.symtab.enterScope();
        this.typeNames.enterScope();
        this.candidateClass(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        this.imports(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        this.symtab.enterScope();
        this.parameters(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        this.variables(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        this.ordering(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        this.result(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        this.filter(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        this.typeNames.leaveScope();
        this.symtab.leaveScope();
        this.symtab.leaveScope();
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void candidateClass(AST aST) throws RecognitionException {
        int n;
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        this.errorMsg.setContext("setClass");
        jQLAST3 = (JQLAST)aST;
        jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
        this.astFactory.addASTChild(aSTPair, jQLAST4);
        this.match(aST, 56);
        aST = aST.getNextSibling();
        this.candidateClass = (ClassType)jQLAST4.getJQLType();
        String string = this.candidateClass.getName();
        if (!this.candidateClass.isPersistenceCapable()) {
            this.errorMsg.unsupported(jQLAST4.getLine(), jQLAST4.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.candidateclass.nonpc", string));
        }
        String string2 = (n = string.lastIndexOf(46)) > 0 ? string.substring(n + 1) : string;
        this.typeNames.declare(string2, new TypeName(this.candidateClass, string));
        FieldInfo[] fieldInfoArray = this.candidateClass.getFieldInfos();
        int n2 = 0;
        while (n2 < fieldInfoArray.length) {
            FieldInfo fieldInfo = fieldInfoArray[n2];
            this.symtab.declare(fieldInfo.getName(), new Field(fieldInfo));
            ++n2;
        }
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void imports(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        Object var4_4 = null;
        this.errorMsg.setContext("declareImports");
        while (true) {
            if (aST == null) {
                aST = TreeParser.ASTNULL;
            }
            if (aST.getType() != 57) break;
            this.declareImport(aST);
            aST = this._retTree;
        }
        this.returnAST = var4_4;
        this._retTree = aST;
    }

    public final void parameters(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        this.errorMsg.setContext("declareParameters");
        while (true) {
            if (aST == null) {
                aST = TreeParser.ASTNULL;
            }
            if (aST.getType() != 58) break;
            this.declareParameter(aST);
            aST = this._retTree;
            this.astFactory.addASTChild(aSTPair, this.returnAST);
        }
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void variables(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        this.errorMsg.setContext("declareVariables");
        while (true) {
            if (aST == null) {
                aST = TreeParser.ASTNULL;
            }
            if (aST.getType() != 59) break;
            this.declareVariable(aST);
            aST = this._retTree;
            this.astFactory.addASTChild(aSTPair, this.returnAST);
        }
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void ordering(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        this.errorMsg.setContext("setOrdering");
        while (true) {
            if (aST == null) {
                aST = TreeParser.ASTNULL;
            }
            if (aST.getType() != 60) break;
            this.orderSpec(aST);
            aST = this._retTree;
            this.astFactory.addASTChild(aSTPair, this.returnAST);
        }
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void result(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        this.errorMsg.setContext("setResult");
        if (aST == null) {
            aST = TreeParser.ASTNULL;
        }
        switch (aST.getType()) {
            case 83: {
                AST aST2 = aST;
                jQLAST3 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
                this.astFactory.addASTChild(aSTPair, jQLAST4);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 83);
                aST = aST.getFirstChild();
                if (aST == null) {
                    aST = TreeParser.ASTNULL;
                }
                switch (aST.getType()) {
                    case 8: {
                        JQLAST jQLAST7 = null;
                        JQLAST jQLAST8 = null;
                        jQLAST7 = (JQLAST)this.astFactory.create((JQLAST)aST);
                        jQLAST8 = (JQLAST)aST;
                        this.astFactory.addASTChild(aSTPair, jQLAST7);
                        this.match(aST, 8);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 5: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 44: 
                    case 45: 
                    case 48: 
                    case 52: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                jQLAST6 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST5 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST2;
                aST = aST.getNextSibling();
                this.checkValidResultExpr(jQLAST5);
                jQLAST4.setJQLType(jQLAST5.getJQLType());
                this.checkConstraints(jQLAST5, this.vartab);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 61: {
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void filter(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        this.errorMsg.setContext("setFilter");
        AST aST2 = aST;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        jQLAST5 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST6 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST5);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 61);
        aST = aST.getFirstChild();
        jQLAST4 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
        this.expression(aST);
        aST = this._retTree;
        jQLAST3 = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        Type type = jQLAST3.getJQLType();
        if (!this.typetab.isBooleanType(type)) {
            if (!type.equals(TypeTable.errorType)) {
                this.errorMsg.error(jQLAST3.getLine(), jQLAST3.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.filter.booleanexpected", type));
            }
        }
        this.checkConstraints(jQLAST3, this.vartab);
        this.vartab.checkConstraints();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void declareImport(AST aST) throws RecognitionException {
        int n;
        String string;
        Definition definition;
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        String string2 = null;
        AST aST2 = aST;
        jQLAST3 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
        jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
        this.astFactory.addASTChild(aSTPair, jQLAST4);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 57);
        aST = aST.getFirstChild();
        string2 = this.qualifiedName(aST);
        aST = this._retTree;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        Type type = this.typetab.checkType(string2);
        if (type == null) {
            this.errorMsg.error(jQLAST4.getLine(), jQLAST4.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.unknowntype", string2));
        }
        if ((definition = this.typeNames.declare(string = (n = string2.lastIndexOf(46)) > 0 ? string2.substring(n + 1) : string2, new TypeName(type, string2))) != null) {
            this.errorMsg.error(jQLAST4.getLine(), jQLAST4.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.alreadydeclared", string, definition.getName()));
        }
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final String qualifiedName(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        String string = null;
        if (aST == null) {
            aST = TreeParser.ASTNULL;
        }
        switch (aST.getType()) {
            case 52: {
                jQLAST3 = (JQLAST)aST;
                jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
                this.astFactory.addASTChild(aSTPair, jQLAST4);
                this.match(aST, 52);
                aST = aST.getNextSibling();
                string = jQLAST4.getText();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 91: {
                AST aST2 = aST;
                jQLAST5 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST6 = (JQLAST)this.astFactory.create(jQLAST5);
                this.astFactory.addASTChild(aSTPair, jQLAST6);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 91);
                aST = aST.getFirstChild();
                string = this.qualifiedName(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST7 = (JQLAST)aST;
                jQLAST8 = (JQLAST)this.astFactory.create(jQLAST7);
                this.astFactory.addASTChild(aSTPair, jQLAST8);
                this.match(aST, 52);
                aST = aST.getNextSibling();
                string = string + jQLAST6.getText() + jQLAST8.getText();
                aSTPair = aSTPair2;
                aST = aST2;
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
        return string;
    }

    public final void declareParameter(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        AST aST2 = aST;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        jQLAST7 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST8 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST7);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 58);
        aST = aST.getFirstChild();
        jQLAST4 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
        this.type(aST);
        aST = this._retTree;
        jQLAST3 = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        jQLAST5 = (JQLAST)aST;
        jQLAST6 = (JQLAST)this.astFactory.create(jQLAST5);
        this.astFactory.addASTChild(aSTPair, jQLAST6);
        this.match(aST, 52);
        aST = aST.getNextSibling();
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        String string = jQLAST6.getText();
        Type type = jQLAST3.getJQLType();
        Definition definition = this.symtab.declare(string, new Parameter(type));
        if (definition != null) {
            this.errorMsg.error(jQLAST6.getLine(), jQLAST6.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.alreadydeclared", string, definition.getName()));
        }
        jQLAST6.setJQLType(type);
        this.paramtab.add(string, type);
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void type(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        String string = null;
        if (aST == null) {
            aST = TreeParser.ASTNULL;
        }
        switch (aST.getType()) {
            case 52: 
            case 91: {
                jQLAST4 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                string = this.qualifiedName(aST);
                aST = this._retTree;
                jQLAST3 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                Type type = null;
                if (this.typeNames.isDeclared(string)) {
                    Definition definition = this.typeNames.getDefinition(string);
                    if (definition instanceof TypeName) {
                        type = definition.getType();
                    } else {
                        this.errorMsg.error(jQLAST3.getLine(), jQLAST3.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.type.notype", string, definition.getName()));
                    }
                } else {
                    type = this.typetab.checkType(string);
                    if (type == null && string.indexOf(46) == -1) {
                        type = this.typetab.checkType("java.lang." + string);
                    }
                    if (type == null) {
                        this.errorMsg.error(jQLAST3.getLine(), jQLAST3.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.unknowntype", string));
                    }
                }
                jQLAST3.setType(81);
                jQLAST3.setText(string);
                jQLAST3.setFirstChild(null);
                jQLAST3.setJQLType(type);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                jQLAST6 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.primitiveType(aST);
                aST = this._retTree;
                jQLAST5 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST5.setJQLType(this.typetab.checkType(jQLAST5.getText()));
                jQLAST5.setType(81);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void declareVariable(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        AST aST2 = aST;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        jQLAST7 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST8 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST7);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 59);
        aST = aST.getFirstChild();
        jQLAST4 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
        this.type(aST);
        aST = this._retTree;
        jQLAST3 = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        jQLAST5 = (JQLAST)aST;
        jQLAST6 = (JQLAST)this.astFactory.create(jQLAST5);
        this.astFactory.addASTChild(aSTPair, jQLAST6);
        this.match(aST, 52);
        aST = aST.getNextSibling();
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        String string = jQLAST6.getText();
        Type type = jQLAST3.getJQLType();
        Definition definition = this.symtab.declare(string, new Variable(type));
        if (definition != null) {
            this.errorMsg.error(jQLAST6.getLine(), jQLAST6.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.alreadydeclared", string, definition.getName()));
        }
        this.vartab.add(string);
        jQLAST6.setJQLType(type);
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void orderSpec(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        AST aST2 = aST;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        jQLAST5 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST6 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST5);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 60);
        aST = aST.getFirstChild();
        if (aST == null) {
            aST = TreeParser.ASTNULL;
        }
        switch (aST.getType()) {
            case 6: {
                JQLAST jQLAST7 = null;
                JQLAST jQLAST8 = null;
                jQLAST7 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST8 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST7);
                this.match(aST, 6);
                aST = aST.getNextSibling();
                break;
            }
            case 7: {
                JQLAST jQLAST9 = null;
                JQLAST jQLAST10 = null;
                jQLAST9 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST10 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST9);
                this.match(aST, 7);
                aST = aST.getNextSibling();
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        jQLAST4 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
        this.expression(aST);
        aST = this._retTree;
        jQLAST3 = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        this.analyseOrderingExpression(jQLAST3);
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void expression(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        jQLAST4 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
        String string = this.exprNoCheck(aST, false);
        aST = this._retTree;
        jQLAST3 = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        if (string != null) {
            jQLAST3.setJQLType(TypeTable.errorType);
            this.errorMsg.error(jQLAST3.getLine(), jQLAST3.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.expression.undefined", string));
        }
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final String exprNoCheck(AST aST, boolean bl) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        String string = null;
        if (aST == null) {
            aST = TreeParser.ASTNULL;
        }
        switch (aST.getType()) {
            case 36: 
            case 37: 
            case 39: {
                this.bitwiseExpr(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 38: 
            case 40: {
                this.conditionalExpr(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 23: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                this.relationalExpr(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                this.binaryArithmeticExpr(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 63: 
            case 64: {
                this.unaryArithmeticExpr(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 24: 
            case 25: {
                this.complementExpr(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 44: 
            case 45: 
            case 48: 
            case 52: 
            case 65: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                string = this.primary(aST, bl);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
        return string;
    }

    public final void bitwiseExpr(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        JQLAST jQLAST9 = null;
        JQLAST jQLAST10 = null;
        JQLAST jQLAST11 = null;
        JQLAST jQLAST12 = null;
        JQLAST jQLAST13 = null;
        JQLAST jQLAST14 = null;
        JQLAST jQLAST15 = null;
        JQLAST jQLAST16 = null;
        JQLAST jQLAST17 = null;
        JQLAST jQLAST18 = null;
        JQLAST jQLAST19 = null;
        JQLAST jQLAST20 = null;
        if (aST == null) {
            aST = TreeParser.ASTNULL;
        }
        switch (aST.getType()) {
            case 39: {
                AST aST2 = aST;
                jQLAST3 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
                this.astFactory.addASTChild(aSTPair, jQLAST4);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 39);
                aST = aST.getFirstChild();
                jQLAST6 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST5 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST8 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST7 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST2;
                aST = aST.getNextSibling();
                jQLAST4.setJQLType(this.analyseBitwiseExpr(jQLAST4, jQLAST5, jQLAST7));
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 37: {
                AST aST3 = aST;
                jQLAST9 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST10 = (JQLAST)this.astFactory.create(jQLAST9);
                this.astFactory.addASTChild(aSTPair, jQLAST10);
                ASTPair aSTPair3 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 37);
                aST = aST.getFirstChild();
                jQLAST12 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST11 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST14 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST13 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair3;
                aST = aST3;
                aST = aST.getNextSibling();
                jQLAST10.setJQLType(this.analyseBitwiseExpr(jQLAST10, jQLAST11, jQLAST13));
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 36: {
                AST aST4 = aST;
                jQLAST15 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST16 = (JQLAST)this.astFactory.create(jQLAST15);
                this.astFactory.addASTChild(aSTPair, jQLAST16);
                ASTPair aSTPair4 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 36);
                aST = aST.getFirstChild();
                jQLAST18 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST17 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST20 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST19 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair4;
                aST = aST4;
                aST = aST.getNextSibling();
                jQLAST16.setJQLType(this.analyseBitwiseExpr(jQLAST16, jQLAST17, jQLAST19));
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void conditionalExpr(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        JQLAST jQLAST9 = null;
        JQLAST jQLAST10 = null;
        JQLAST jQLAST11 = null;
        JQLAST jQLAST12 = null;
        JQLAST jQLAST13 = null;
        JQLAST jQLAST14 = null;
        if (aST == null) {
            aST = TreeParser.ASTNULL;
        }
        switch (aST.getType()) {
            case 40: {
                AST aST2 = aST;
                jQLAST3 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
                this.astFactory.addASTChild(aSTPair, jQLAST4);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 40);
                aST = aST.getFirstChild();
                jQLAST6 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST5 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST8 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST7 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST2;
                aST = aST.getNextSibling();
                jQLAST4.setJQLType(this.analyseConditionalExpr(jQLAST4, jQLAST5, jQLAST7));
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 38: {
                AST aST3 = aST;
                jQLAST9 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST10 = (JQLAST)this.astFactory.create(jQLAST9);
                this.astFactory.addASTChild(aSTPair, jQLAST10);
                ASTPair aSTPair3 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 38);
                aST = aST.getFirstChild();
                jQLAST12 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST11 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST14 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST13 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair3;
                aST = aST3;
                aST = aST.getNextSibling();
                jQLAST10.setJQLType(this.analyseConditionalExpr(jQLAST10, jQLAST11, jQLAST13));
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void relationalExpr(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        JQLAST jQLAST9 = null;
        JQLAST jQLAST10 = null;
        JQLAST jQLAST11 = null;
        JQLAST jQLAST12 = null;
        JQLAST jQLAST13 = null;
        JQLAST jQLAST14 = null;
        JQLAST jQLAST15 = null;
        JQLAST jQLAST16 = null;
        JQLAST jQLAST17 = null;
        JQLAST jQLAST18 = null;
        JQLAST jQLAST19 = null;
        JQLAST jQLAST20 = null;
        JQLAST jQLAST21 = null;
        JQLAST jQLAST22 = null;
        JQLAST jQLAST23 = null;
        JQLAST jQLAST24 = null;
        JQLAST jQLAST25 = null;
        JQLAST jQLAST26 = null;
        JQLAST jQLAST27 = null;
        JQLAST jQLAST28 = null;
        JQLAST jQLAST29 = null;
        JQLAST jQLAST30 = null;
        JQLAST jQLAST31 = null;
        JQLAST jQLAST32 = null;
        JQLAST jQLAST33 = null;
        JQLAST jQLAST34 = null;
        JQLAST jQLAST35 = null;
        JQLAST jQLAST36 = null;
        JQLAST jQLAST37 = null;
        JQLAST jQLAST38 = null;
        Type type = null;
        Type type2 = null;
        if (aST == null) {
            aST = TreeParser.ASTNULL;
        }
        switch (aST.getType()) {
            case 23: {
                AST aST2 = aST;
                jQLAST3 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
                this.astFactory.addASTChild(aSTPair, jQLAST4);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 23);
                aST = aST.getFirstChild();
                jQLAST6 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST5 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST8 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST7 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST2;
                aST = aST.getNextSibling();
                jQLAST4.setJQLType(this.analyseRelationalExpr(jQLAST4, jQLAST5, jQLAST7));
                type = jQLAST5.getJQLType();
                type2 = jQLAST7.getJQLType();
                if (this.typetab.isPersistenceCapableType(type) || this.typetab.isPersistenceCapableType(type2)) {
                    jQLAST4.setType(66);
                } else if (this.typetab.isCollectionType(type) || this.typetab.isCollectionType(type2)) {
                    jQLAST4.setType(68);
                }
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 26: {
                AST aST3 = aST;
                jQLAST9 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST10 = (JQLAST)this.astFactory.create(jQLAST9);
                this.astFactory.addASTChild(aSTPair, jQLAST10);
                ASTPair aSTPair3 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 26);
                aST = aST.getFirstChild();
                jQLAST12 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST11 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST14 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST13 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair3;
                aST = aST3;
                aST = aST.getNextSibling();
                jQLAST10.setJQLType(this.analyseRelationalExpr(jQLAST10, jQLAST11, jQLAST13));
                type = jQLAST11.getJQLType();
                type2 = jQLAST13.getJQLType();
                if (this.typetab.isPersistenceCapableType(type) || this.typetab.isPersistenceCapableType(type2)) {
                    jQLAST10.setType(67);
                } else if (this.typetab.isCollectionType(type) || this.typetab.isCollectionType(type2)) {
                    jQLAST10.setType(69);
                }
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 35: {
                AST aST4 = aST;
                jQLAST15 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST16 = (JQLAST)this.astFactory.create(jQLAST15);
                this.astFactory.addASTChild(aSTPair, jQLAST16);
                ASTPair aSTPair4 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 35);
                aST = aST.getFirstChild();
                jQLAST18 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST17 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST20 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST19 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair4;
                aST = aST4;
                aST = aST.getNextSibling();
                jQLAST16.setJQLType(this.analyseRelationalExpr(jQLAST16, jQLAST17, jQLAST19));
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 33: {
                AST aST5 = aST;
                jQLAST21 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST22 = (JQLAST)this.astFactory.create(jQLAST21);
                this.astFactory.addASTChild(aSTPair, jQLAST22);
                ASTPair aSTPair5 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 33);
                aST = aST.getFirstChild();
                jQLAST24 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST23 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST26 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST25 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair5;
                aST = aST5;
                aST = aST.getNextSibling();
                jQLAST22.setJQLType(this.analyseRelationalExpr(jQLAST22, jQLAST23, jQLAST25));
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 34: {
                AST aST6 = aST;
                jQLAST27 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST28 = (JQLAST)this.astFactory.create(jQLAST27);
                this.astFactory.addASTChild(aSTPair, jQLAST28);
                ASTPair aSTPair6 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 34);
                aST = aST.getFirstChild();
                jQLAST30 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST29 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST32 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST31 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair6;
                aST = aST6;
                aST = aST.getNextSibling();
                jQLAST28.setJQLType(this.analyseRelationalExpr(jQLAST28, jQLAST29, jQLAST31));
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 32: {
                AST aST7 = aST;
                jQLAST33 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST34 = (JQLAST)this.astFactory.create(jQLAST33);
                this.astFactory.addASTChild(aSTPair, jQLAST34);
                ASTPair aSTPair7 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 32);
                aST = aST.getFirstChild();
                jQLAST36 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST35 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST38 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST37 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair7;
                aST = aST7;
                aST = aST.getNextSibling();
                jQLAST34.setJQLType(this.analyseRelationalExpr(jQLAST34, jQLAST35, jQLAST37));
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void binaryArithmeticExpr(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        JQLAST jQLAST9 = null;
        JQLAST jQLAST10 = null;
        JQLAST jQLAST11 = null;
        JQLAST jQLAST12 = null;
        JQLAST jQLAST13 = null;
        JQLAST jQLAST14 = null;
        JQLAST jQLAST15 = null;
        JQLAST jQLAST16 = null;
        JQLAST jQLAST17 = null;
        JQLAST jQLAST18 = null;
        JQLAST jQLAST19 = null;
        JQLAST jQLAST20 = null;
        JQLAST jQLAST21 = null;
        JQLAST jQLAST22 = null;
        JQLAST jQLAST23 = null;
        JQLAST jQLAST24 = null;
        JQLAST jQLAST25 = null;
        JQLAST jQLAST26 = null;
        JQLAST jQLAST27 = null;
        JQLAST jQLAST28 = null;
        JQLAST jQLAST29 = null;
        JQLAST jQLAST30 = null;
        JQLAST jQLAST31 = null;
        JQLAST jQLAST32 = null;
        if (aST == null) {
            aST = TreeParser.ASTNULL;
        }
        switch (aST.getType()) {
            case 28: {
                AST aST2 = aST;
                jQLAST3 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
                this.astFactory.addASTChild(aSTPair, jQLAST4);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 28);
                aST = aST.getFirstChild();
                jQLAST6 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST5 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST8 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST7 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST2;
                aST = aST.getNextSibling();
                jQLAST4.setJQLType(this.analyseBinaryArithmeticExpr(jQLAST4, jQLAST5, jQLAST7));
                if (jQLAST4.getJQLType().equals(this.typetab.stringType)) {
                    jQLAST4.setType(70);
                }
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 29: {
                AST aST3 = aST;
                jQLAST9 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST10 = (JQLAST)this.astFactory.create(jQLAST9);
                this.astFactory.addASTChild(aSTPair, jQLAST10);
                ASTPair aSTPair3 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 29);
                aST = aST.getFirstChild();
                jQLAST12 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST11 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST14 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST13 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair3;
                aST = aST3;
                aST = aST.getNextSibling();
                jQLAST10.setJQLType(this.analyseBinaryArithmeticExpr(jQLAST10, jQLAST11, jQLAST13));
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 30: {
                AST aST4 = aST;
                jQLAST15 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST16 = (JQLAST)this.astFactory.create(jQLAST15);
                this.astFactory.addASTChild(aSTPair, jQLAST16);
                ASTPair aSTPair4 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 30);
                aST = aST.getFirstChild();
                jQLAST18 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST17 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST20 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST19 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair4;
                aST = aST4;
                aST = aST.getNextSibling();
                jQLAST16.setJQLType(this.analyseBinaryArithmeticExpr(jQLAST16, jQLAST17, jQLAST19));
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 27: {
                AST aST5 = aST;
                jQLAST21 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST22 = (JQLAST)this.astFactory.create(jQLAST21);
                this.astFactory.addASTChild(aSTPair, jQLAST22);
                ASTPair aSTPair5 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 27);
                aST = aST.getFirstChild();
                jQLAST24 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST23 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST26 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST25 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair5;
                aST = aST5;
                aST = aST.getNextSibling();
                jQLAST22.setJQLType(this.analyseBinaryArithmeticExpr(jQLAST22, jQLAST23, jQLAST25));
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 31: {
                AST aST6 = aST;
                jQLAST27 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST28 = (JQLAST)this.astFactory.create(jQLAST27);
                this.astFactory.addASTChild(aSTPair, jQLAST28);
                ASTPair aSTPair6 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 31);
                aST = aST.getFirstChild();
                jQLAST30 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST29 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST32 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST31 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair6;
                aST = aST6;
                aST = aST.getNextSibling();
                this.errorMsg.unsupported(jQLAST27.getLine(), jQLAST27.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.binaryarithmeticexpr.reminderop"));
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void unaryArithmeticExpr(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        JQLAST jQLAST9 = null;
        JQLAST jQLAST10 = null;
        if (aST == null) {
            aST = TreeParser.ASTNULL;
        }
        switch (aST.getType()) {
            case 64: {
                AST aST2 = aST;
                jQLAST3 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
                this.astFactory.addASTChild(aSTPair, jQLAST4);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 64);
                aST = aST.getFirstChild();
                jQLAST6 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST5 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST2;
                aST = aST.getNextSibling();
                jQLAST4.setJQLType(this.analyseUnaryArithmeticExpr(jQLAST4, jQLAST5));
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 63: {
                AST aST3 = aST;
                jQLAST7 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST8 = (JQLAST)this.astFactory.create(jQLAST7);
                this.astFactory.addASTChild(aSTPair, jQLAST8);
                ASTPair aSTPair3 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 63);
                aST = aST.getFirstChild();
                jQLAST10 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST9 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair3;
                aST = aST3;
                aST = aST.getNextSibling();
                jQLAST8.setJQLType(this.analyseUnaryArithmeticExpr(jQLAST8, jQLAST9));
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void complementExpr(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        JQLAST jQLAST9 = null;
        JQLAST jQLAST10 = null;
        if (aST == null) {
            aST = TreeParser.ASTNULL;
        }
        switch (aST.getType()) {
            case 25: {
                AST aST2 = aST;
                jQLAST3 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
                this.astFactory.addASTChild(aSTPair, jQLAST4);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 25);
                aST = aST.getFirstChild();
                jQLAST6 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST5 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST2;
                aST = aST.getNextSibling();
                jQLAST4.setJQLType(this.analyseComplementExpr(jQLAST4, jQLAST5));
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 24: {
                AST aST3 = aST;
                jQLAST7 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST8 = (JQLAST)this.astFactory.create(jQLAST7);
                this.astFactory.addASTChild(aSTPair, jQLAST8);
                ASTPair aSTPair3 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 24);
                aST = aST.getFirstChild();
                jQLAST10 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST9 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair3;
                aST = aST3;
                aST = aST.getNextSibling();
                jQLAST8.setJQLType(this.analyseComplementExpr(jQLAST8, jQLAST9));
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final String primary(AST aST, boolean bl) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        JQLAST jQLAST9 = null;
        JQLAST jQLAST10 = null;
        String string = null;
        if (aST == null) {
            aST = TreeParser.ASTNULL;
        }
        switch (aST.getType()) {
            case 65: {
                AST aST2 = aST;
                jQLAST3 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
                this.astFactory.addASTChild(aSTPair, jQLAST4);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 65);
                aST = aST.getFirstChild();
                jQLAST6 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.type(aST);
                aST = this._retTree;
                jQLAST5 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST8 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.expression(aST);
                aST = this._retTree;
                jQLAST7 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST2;
                aST = aST.getNextSibling();
                Type type = jQLAST5.getJQLType();
                Type type2 = jQLAST7.getJQLType();
                if (!type.isCompatibleWith(type2) && !type2.isCompatibleWith(type)) {
                    this.errorMsg.error(jQLAST4.getLine(), jQLAST4.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.primary.invalidcast", type2.getName(), type.getName()));
                    type = TypeTable.errorType;
                }
                jQLAST4.setJQLType(type);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 44: 
            case 45: 
            case 48: 
            case 92: 
            case 93: 
            case 94: {
                this.literal(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 5: {
                jQLAST9 = (JQLAST)aST;
                jQLAST10 = (JQLAST)this.astFactory.create(jQLAST9);
                this.astFactory.addASTChild(aSTPair, jQLAST10);
                this.match(aST, 5);
                aST = aST.getNextSibling();
                jQLAST10.setJQLType(this.candidateClass);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 91: {
                string = this.dotExpr(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 52: {
                string = this.identifier(aST, bl);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
        return string;
    }

    public final void literal(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        JQLAST jQLAST9 = null;
        JQLAST jQLAST10 = null;
        JQLAST jQLAST11 = null;
        JQLAST jQLAST12 = null;
        JQLAST jQLAST13 = null;
        JQLAST jQLAST14 = null;
        JQLAST jQLAST15 = null;
        JQLAST jQLAST16 = null;
        JQLAST jQLAST17 = null;
        JQLAST jQLAST18 = null;
        JQLAST jQLAST19 = null;
        JQLAST jQLAST20 = null;
        if (aST == null) {
            aST = TreeParser.ASTNULL;
        }
        switch (aST.getType()) {
            case 18: {
                jQLAST3 = (JQLAST)aST;
                jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
                this.astFactory.addASTChild(aSTPair, jQLAST4);
                this.match(aST, 18);
                aST = aST.getNextSibling();
                jQLAST4.setJQLType(this.typetab.booleanType);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 19: {
                jQLAST5 = (JQLAST)aST;
                jQLAST6 = (JQLAST)this.astFactory.create(jQLAST5);
                this.astFactory.addASTChild(aSTPair, jQLAST6);
                this.match(aST, 19);
                aST = aST.getNextSibling();
                jQLAST6.setJQLType(this.typetab.booleanType);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 48: {
                jQLAST7 = (JQLAST)aST;
                jQLAST8 = (JQLAST)this.astFactory.create(jQLAST7);
                this.astFactory.addASTChild(aSTPair, jQLAST8);
                this.match(aST, 48);
                aST = aST.getNextSibling();
                jQLAST8.setJQLType(this.typetab.intType);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 92: {
                jQLAST9 = (JQLAST)aST;
                jQLAST10 = (JQLAST)this.astFactory.create(jQLAST9);
                this.astFactory.addASTChild(aSTPair, jQLAST10);
                this.match(aST, 92);
                aST = aST.getNextSibling();
                jQLAST10.setJQLType(this.typetab.longType);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 93: {
                jQLAST11 = (JQLAST)aST;
                jQLAST12 = (JQLAST)this.astFactory.create(jQLAST11);
                this.astFactory.addASTChild(aSTPair, jQLAST12);
                this.match(aST, 93);
                aST = aST.getNextSibling();
                jQLAST12.setJQLType(this.typetab.floatType);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 94: {
                jQLAST13 = (JQLAST)aST;
                jQLAST14 = (JQLAST)this.astFactory.create(jQLAST13);
                this.astFactory.addASTChild(aSTPair, jQLAST14);
                this.match(aST, 94);
                aST = aST.getNextSibling();
                jQLAST14.setJQLType(this.typetab.doubleType);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 44: {
                jQLAST15 = (JQLAST)aST;
                jQLAST16 = (JQLAST)this.astFactory.create(jQLAST15);
                this.astFactory.addASTChild(aSTPair, jQLAST16);
                this.match(aST, 44);
                aST = aST.getNextSibling();
                jQLAST16.setJQLType(this.typetab.charType);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 45: {
                jQLAST17 = (JQLAST)aST;
                jQLAST18 = (JQLAST)this.astFactory.create(jQLAST17);
                this.astFactory.addASTChild(aSTPair, jQLAST18);
                this.match(aST, 45);
                aST = aST.getNextSibling();
                jQLAST18.setJQLType(this.typetab.stringType);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 17: {
                jQLAST19 = (JQLAST)aST;
                jQLAST20 = (JQLAST)this.astFactory.create(jQLAST19);
                this.astFactory.addASTChild(aSTPair, jQLAST20);
                this.match(aST, 17);
                aST = aST.getNextSibling();
                jQLAST20.setJQLType(TypeTable.nullType);
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final String dotExpr(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        JQLAST jQLAST7 = null;
        JQLAST jQLAST8 = null;
        JQLAST jQLAST9 = null;
        JQLAST jQLAST10 = null;
        String string = null;
        AST aST2 = aST;
        jQLAST3 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
        jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
        this.astFactory.addASTChild(aSTPair, jQLAST4);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 91);
        aST = aST.getFirstChild();
        jQLAST6 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
        string = this.exprNoCheck(aST, true);
        aST = this._retTree;
        jQLAST5 = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(aSTPair, this.returnAST);
        jQLAST7 = (JQLAST)aST;
        jQLAST8 = (JQLAST)this.astFactory.create(jQLAST7);
        this.astFactory.addASTChild(aSTPair, jQLAST8);
        this.match(aST, 52);
        aST = aST.getNextSibling();
        if (aST == null) {
            aST = TreeParser.ASTNULL;
        }
        switch (aST.getType()) {
            case 62: {
                jQLAST10 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.argList(aST);
                aST = this._retTree;
                jQLAST9 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        jQLAST2 = (JQLAST)aSTPair.root;
        Type type = null;
        if (string != null) {
            String string2 = string + '.' + jQLAST8.getText();
            type = this.typetab.checkType(string2);
            if (type == null) {
                string = string2;
            } else if (jQLAST9 == null) {
                string = null;
                jQLAST4.setType(81);
                jQLAST4.setText(string2);
                jQLAST4.setFirstChild(null);
            } else {
                string = null;
                this.errorMsg.error(jQLAST3.getLine(), jQLAST3.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.invalidmethodcall"));
            }
            jQLAST4.setJQLType(type);
            jQLAST4.setText(jQLAST5.getText() + '.' + jQLAST8.getText());
        } else {
            jQLAST2 = this.analyseDotExpr(jQLAST4, jQLAST5, jQLAST8, jQLAST9);
        }
        aSTPair.root = jQLAST2;
        aSTPair.child = jQLAST2 != null && jQLAST2.getFirstChild() != null ? jQLAST2.getFirstChild() : jQLAST2;
        aSTPair.advanceChildToEnd();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
        return string;
    }

    public final String identifier(AST aST, boolean bl) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        JQLAST jQLAST5 = null;
        JQLAST jQLAST6 = null;
        String string = null;
        jQLAST3 = (JQLAST)aST;
        jQLAST4 = (JQLAST)this.astFactory.create(jQLAST3);
        this.astFactory.addASTChild(aSTPair, jQLAST4);
        this.match(aST, 52);
        aST = aST.getNextSibling();
        if (aST == null) {
            aST = TreeParser.ASTNULL;
        }
        switch (aST.getType()) {
            case 62: {
                jQLAST6 = aST == TreeParser.ASTNULL ? null : (JQLAST)aST;
                this.argList(aST);
                aST = this._retTree;
                jQLAST5 = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                break;
            }
            case 3: 
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 48: 
            case 52: 
            case 63: 
            case 64: 
            case 65: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        String string2 = jQLAST4.getText();
        Definition definition = this.symtab.getDefinition(string2);
        if (jQLAST5 != null) {
            jQLAST4.setJQLType(TypeTable.errorType);
            this.errorMsg.error(jQLAST4.getLine(), jQLAST4.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.generic.invalidmethodcall"));
        } else if (definition != null) {
            jQLAST4 = this.analyseDefinedIdentifier(jQLAST4, definition);
        } else if (bl) {
            Definition definition2 = this.typeNames.getDefinition(string2);
            if (definition2 != null) {
                jQLAST4 = this.analyseDefinedIdentifier(jQLAST4, definition2);
            } else {
                string = jQLAST4.getText();
            }
        } else {
            jQLAST4.setJQLType(TypeTable.errorType);
            this.errorMsg.error(jQLAST3.getLine(), jQLAST3.getColumn(), I18NHelper.getMessage(messages, "jqlc.semantic.identifier.undefined", jQLAST3.getText()));
        }
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
        return string;
    }

    public final void argList(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        AST aST2 = aST;
        JQLAST jQLAST3 = null;
        JQLAST jQLAST4 = null;
        jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
        jQLAST4 = (JQLAST)aST;
        this.astFactory.addASTChild(aSTPair, jQLAST3);
        ASTPair aSTPair2 = aSTPair.copy();
        aSTPair.root = aSTPair.child;
        aSTPair.child = null;
        this.match(aST, 62);
        aST = aST.getFirstChild();
        while (true) {
            if (aST == null) {
                aST = TreeParser.ASTNULL;
            }
            if (!_tokenSet_0.member(aST.getType())) break;
            this.expression(aST);
            aST = this._retTree;
            this.astFactory.addASTChild(aSTPair, this.returnAST);
        }
        aSTPair = aSTPair2;
        aST = aST2;
        aST = aST.getNextSibling();
        jQLAST2 = (JQLAST)aSTPair.root;
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    public final void primitiveType(AST aST) throws RecognitionException {
        JQLAST jQLAST = (JQLAST)aST;
        this.returnAST = null;
        ASTPair aSTPair = new ASTPair();
        JQLAST jQLAST2 = null;
        if (aST == null) {
            aST = TreeParser.ASTNULL;
        }
        switch (aST.getType()) {
            case 9: {
                JQLAST jQLAST3 = null;
                JQLAST jQLAST4 = null;
                jQLAST3 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST4 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST3);
                this.match(aST, 9);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 10: {
                JQLAST jQLAST5 = null;
                JQLAST jQLAST6 = null;
                jQLAST5 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST6 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST5);
                this.match(aST, 10);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 11: {
                JQLAST jQLAST7 = null;
                JQLAST jQLAST8 = null;
                jQLAST7 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST8 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST7);
                this.match(aST, 11);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 12: {
                JQLAST jQLAST9 = null;
                JQLAST jQLAST10 = null;
                jQLAST9 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST10 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST9);
                this.match(aST, 12);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 13: {
                JQLAST jQLAST11 = null;
                JQLAST jQLAST12 = null;
                jQLAST11 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST12 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST11);
                this.match(aST, 13);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 14: {
                JQLAST jQLAST13 = null;
                JQLAST jQLAST14 = null;
                jQLAST13 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST14 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST13);
                this.match(aST, 14);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 15: {
                JQLAST jQLAST15 = null;
                JQLAST jQLAST16 = null;
                jQLAST15 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST16 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST15);
                this.match(aST, 15);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            case 16: {
                JQLAST jQLAST17 = null;
                JQLAST jQLAST18 = null;
                jQLAST17 = (JQLAST)this.astFactory.create((JQLAST)aST);
                jQLAST18 = (JQLAST)aST;
                this.astFactory.addASTChild(aSTPair, jQLAST17);
                this.match(aST, 16);
                aST = aST.getNextSibling();
                jQLAST2 = (JQLAST)aSTPair.root;
                break;
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this.returnAST = jQLAST2;
        this._retTree = aST;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

