/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query;

import com.sun.jdo.api.persistence.support.JDOQueryException;
import com.sun.jdo.api.persistence.support.Query;
import com.sun.jdo.api.persistence.support.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.query.LogHelperQueryExecute;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLC;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ParameterTable;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;

public class QueryImpl
implements Query {
    private Class candidateClass;
    private String filterExpression;
    private String importDeclarations;
    private String parameterDeclarations;
    private String variableDeclarations;
    private String orderingSpecification;
    private String resultExpression;
    private boolean compiled = false;
    private transient PersistenceManager pm;
    private transient Collection candidateCollection;
    private transient boolean ignoreCache;
    private transient JQLC jqlc;
    private transient ParameterTable paramtab;
    private transient boolean createdBySerialization = false;
    protected static final ResourceBundle messages = I18NHelper.loadBundle(class$com$sun$jdo$spi$persistence$support$sqlstore$query$QueryImpl == null ? (class$com$sun$jdo$spi$persistence$support$sqlstore$query$QueryImpl = QueryImpl.class$("com.sun.jdo.spi.persistence.support.sqlstore.query.QueryImpl")) : class$com$sun$jdo$spi$persistence$support$sqlstore$query$QueryImpl);
    private static Logger logger = LogHelperQueryExecute.getLogger();
    static /* synthetic */ Class class$com$sun$jdo$spi$persistence$support$sqlstore$query$QueryImpl;

    public QueryImpl(PersistenceManager persistenceManager) {
        if (logger.isLoggable(400)) {
            logger.finer("LOG_CreateNewQuery", this.identity());
        }
        this.pm = persistenceManager;
        this.paramtab = new ParameterTable();
        this.ignoreCache = persistenceManager.getPersistenceManagerFactory().getIgnoreCache();
    }

    public QueryImpl(PersistenceManager persistenceManager, Object object) {
        if (logger.isLoggable(400)) {
            logger.finer("LOG_CreateNewQueryFromCompiled", this.identity(), object);
        }
        this.pm = persistenceManager;
        if (object == null) {
            JDOQueryException jDOQueryException = new JDOQueryException(I18NHelper.getMessage(messages, "query.queryimpl.init.compiledquery.isnull"));
            logger.throwing("query.QueryImpl", "<init>", jDOQueryException);
            throw jDOQueryException;
        }
        if (!(object instanceof QueryImpl)) {
            JDOQueryException jDOQueryException = new JDOQueryException(I18NHelper.getMessage(messages, "query.queryimpl.init.compiledquery.invalidtype", object.getClass().getName()));
            logger.throwing("query.QueryImpl", "<init>", jDOQueryException);
            throw jDOQueryException;
        }
        QueryImpl queryImpl = (QueryImpl)object;
        this.candidateClass = queryImpl.candidateClass;
        this.filterExpression = queryImpl.filterExpression;
        this.importDeclarations = queryImpl.importDeclarations;
        this.parameterDeclarations = queryImpl.parameterDeclarations;
        this.variableDeclarations = queryImpl.variableDeclarations;
        this.orderingSpecification = queryImpl.orderingSpecification;
        this.resultExpression = queryImpl.resultExpression;
        this.ignoreCache = queryImpl.ignoreCache;
        this.candidateCollection = null;
        if (queryImpl.paramtab != null) {
            this.jqlc = queryImpl.jqlc;
            this.paramtab = new ParameterTable(queryImpl.paramtab);
            this.compiled = queryImpl.compiled;
        } else {
            this.jqlc = null;
            this.paramtab = new ParameterTable();
            this.compiled = false;
        }
    }

    public QueryImpl(PersistenceManager persistenceManager, Class clazz) {
        this(persistenceManager);
        this.setClass(clazz);
    }

    public QueryImpl(PersistenceManager persistenceManager, Class clazz, Collection collection) {
        this(persistenceManager);
        this.setClass(clazz);
        this.setCandidates(collection);
    }

    public QueryImpl(PersistenceManager persistenceManager, Class clazz, String string) {
        this(persistenceManager);
        this.setClass(clazz);
        this.setFilter(string);
    }

    public QueryImpl(PersistenceManager persistenceManager, Class clazz, Collection collection, String string) {
        this(persistenceManager);
        this.setClass(clazz);
        this.setCandidates(collection);
        this.setFilter(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClass(Class clazz) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.candidateClass = clazz;
            this.compiled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCandidates(Collection collection) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.candidateCollection = collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(String string) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.filterExpression = string;
            this.compiled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareImports(String string) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.importDeclarations = string;
            this.compiled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareParameters(String string) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.parameterDeclarations = string;
            this.compiled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareVariables(String string) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.variableDeclarations = string;
            this.compiled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrdering(String string) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.orderingSpecification = string;
            this.compiled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(String string) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.resultExpression = string;
            this.compiled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIgnoreCache(boolean bl) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.ignoreCache = bl;
        }
    }

    public boolean getIgnoreCache() {
        return this.ignoreCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile() {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            if (!this.compiled) {
                if (logger.isLoggable(400)) {
                    logger.finer("LOG_CompileQuery", this);
                }
                this.jqlc = new JQLC();
                this.jqlc.setClass(this.candidateClass);
                this.jqlc.declareImports(this.importDeclarations);
                this.jqlc.declareParameters(this.parameterDeclarations);
                this.jqlc.declareVariables(this.variableDeclarations);
                this.jqlc.setOrdering(this.orderingSpecification);
                this.jqlc.setResult(this.resultExpression);
                this.jqlc.setFilter(this.filterExpression);
                this.jqlc.semanticCheck(this.paramtab);
                this.compiled = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.compile();
            ParameterTable parameterTable2 = new ParameterTable(this.paramtab);
            parameterTable2.initValueHandling();
            parameterTable2.checkUnboundParams();
            return this.doExecute(parameterTable2);
        }
    }

    public Object execute(Object object) {
        Object[] objectArray = new Object[]{object};
        return this.executeWithArray(objectArray);
    }

    public Object execute(Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return this.executeWithArray(objectArray);
    }

    public Object execute(Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return this.executeWithArray(objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeWithMap(Map map) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.compile();
            ParameterTable parameterTable2 = new ParameterTable(this.paramtab);
            parameterTable2.initValueHandling();
            parameterTable2.setValues(map);
            parameterTable2.checkUnboundParams();
            return this.doExecute(parameterTable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeWithArray(Object[] objectArray) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.compile();
            ParameterTable parameterTable2 = new ParameterTable(this.paramtab);
            parameterTable2.initValueHandling();
            parameterTable2.setValues(objectArray);
            parameterTable2.checkUnboundParams();
            return this.doExecute(parameterTable2);
        }
    }

    public com.sun.jdo.api.persistence.support.PersistenceManager getPersistenceManager() {
        return this.pm == null ? null : this.pm.getCurrentWrapper();
    }

    public void clearPersistenceManager() {
        this.pm = null;
        this.candidateCollection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doExecute(ParameterTable parameterTable) {
        ArrayList arrayList = null;
        RetrieveDesc retrieveDesc = null;
        try {
            this.pm.acquireExclusiveLock();
        }
        catch (NullPointerException nullPointerException) {
            String string = this.createdBySerialization ? "query.queryimpl.doexecute.notboundtopm" : "query.queryimpl.doexecute.pmclosed";
            JDOQueryException jDOQueryException = new JDOQueryException(I18NHelper.getMessage(messages, string));
            logger.throwing("query.QueryImpl", "compile", jDOQueryException);
            throw jDOQueryException;
        }
        try {
            this.checkCandidates();
            retrieveDesc = this.jqlc.codeGen(this.pm, parameterTable);
            this.flush();
            if (logger.isLoggable(400)) {
                logger.finer("LOG_ExecuteQuery", this, parameterTable.getValues());
            }
            arrayList = retrieveDesc != null ? this.pm.retrieve(retrieveDesc, parameterTable.getValueFetcher()) : new ArrayList();
            Object var8_7 = null;
            this.pm.releaseExclusiveLock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.pm.releaseExclusiveLock();
            throw throwable;
        }
        return arrayList;
    }

    private void checkCandidates() {
        if (this.candidateCollection == null && this.candidateClass != null) {
            this.candidateCollection = this.pm.getExtent(this.candidateClass, false);
        } else {
            this.jqlc.checkCandidates(this.candidateClass, this.candidateCollection);
        }
    }

    private void flush() {
        Transaction transaction = this.pm.currentTransaction();
        if (transaction != null && transaction.isActive() && !transaction.getOptimistic() && !this.ignoreCache) {
            this.pm.internalFlush();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("QueryImpl(");
        stringBuffer.append("candidateClass: ");
        stringBuffer.append(this.candidateClass);
        if (this.importDeclarations != null) {
            stringBuffer.append(", imports: ");
            stringBuffer.append(this.importDeclarations);
        }
        if (this.parameterDeclarations != null) {
            stringBuffer.append(", parameters: ");
            stringBuffer.append(this.parameterDeclarations);
        }
        if (this.variableDeclarations != null) {
            stringBuffer.append(", variables: ");
            stringBuffer.append(this.variableDeclarations);
        }
        if (this.filterExpression != null) {
            stringBuffer.append(", filter: ");
            stringBuffer.append(this.filterExpression);
        }
        if (this.orderingSpecification != null) {
            stringBuffer.append(", ordering: ");
            stringBuffer.append(this.orderingSpecification);
        }
        if (this.resultExpression != null) {
            stringBuffer.append(", result: ");
            stringBuffer.append(this.resultExpression);
        }
        stringBuffer.append(", identity: ");
        stringBuffer.append(this.identity());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String identity() {
        return "QueryImpl@" + System.identityHashCode(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paramtab = new ParameterTable();
        this.createdBySerialization = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

