/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.support;

import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.api.persistence.support.PersistenceCapable;
import com.sun.jdo.api.persistence.support.PersistenceManager;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.util.Collection;
import java.util.ResourceBundle;

public class JDOHelper {
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.impl.Bundle", (class$com$sun$jdo$api$persistence$support$JDOHelper == null ? (class$com$sun$jdo$api$persistence$support$JDOHelper = JDOHelper.class$("com.sun.jdo.api.persistence.support.JDOHelper")) : class$com$sun$jdo$api$persistence$support$JDOHelper).getClassLoader());
    static final String null_instance = "null";
    static /* synthetic */ Class class$com$sun$jdo$api$persistence$support$JDOHelper;

    public static PersistenceManager getPersistenceManager(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoGetPersistenceManager();
        }
        return null;
    }

    public static void makeDirty(Object object, String string) {
        if (object instanceof PersistenceCapable) {
            ((PersistenceCapable)object).jdoMakeDirty(string);
        }
    }

    public static Object getObjectId(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoGetObjectId();
        }
        return null;
    }

    public static boolean isDirty(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoIsDirty();
        }
        return false;
    }

    public static boolean isTransactional(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoIsTransactional();
        }
        return false;
    }

    public static boolean isPersistent(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoIsPersistent();
        }
        return false;
    }

    public static boolean isNew(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoIsNew();
        }
        return false;
    }

    public static boolean isDeleted(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoIsDeleted();
        }
        return false;
    }

    public static String printObject(Object object) {
        if (object == null) {
            return null_instance;
        }
        if (JDOHelper.isDeleted(object)) {
            return I18NHelper.getMessage(messages, "jdohelper.deleted_instance", object.getClass().getName());
        }
        return object.toString();
    }

    public static Object createSerializedCopy(Object object) {
        Object object2 = null;
        ClassLoader classLoader = JDOHelper.getObjectClassLoader(object);
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            HelperObjectInputStream helperObjectInputStream = new HelperObjectInputStream(byteArrayInputStream, classLoader);
            object2 = helperObjectInputStream.readObject();
        }
        catch (Exception exception) {
            throw new JDOUserException("", exception);
        }
        return object2;
    }

    private static ClassLoader getObjectClassLoader(Object object) {
        Class<?> clazz = object.getClass();
        if (object instanceof Collection) {
            return JDOHelper.getCollectionClassLoader((Collection)object);
        }
        if (clazz.isArray()) {
            return JDOHelper.getArrayClassLoader((Object[])object);
        }
        return clazz.getClassLoader();
    }

    private static ClassLoader getCollectionClassLoader(Collection collection) {
        Object[] objectArray = collection.toArray();
        return JDOHelper.getArrayClassLoader(objectArray);
    }

    private static ClassLoader getArrayClassLoader(Object[] objectArray) {
        ClassLoader classLoader = null;
        int n = 0;
        while (n < objectArray.length) {
            classLoader = JDOHelper.getObjectClassLoader(objectArray[n]);
            if (classLoader != null) break;
            ++n;
        }
        return classLoader;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class HelperObjectInputStream
    extends ObjectInputStream {
        ClassLoader classLoader;

        public HelperObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException, StreamCorruptedException {
            super(inputStream);
            this.classLoader = classLoader;
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            return this.classLoader.loadClass(objectStreamClass.getName());
        }
    }
}

