/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.mapping.impl;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.ColumnPairElement;
import com.sun.forte4j.modules.dbmodel.DBIdentifier;
import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.forte4j.modules.dbmodel.util.NameUtil;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.ModelVetoException;
import com.sun.jdo.api.persistence.model.mapping.MappingReferenceKeyElement;
import com.sun.jdo.api.persistence.model.mapping.MappingTableElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingMemberElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingTableElementImpl;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.ListIterator;

public class MappingReferenceKeyElementImpl
extends MappingMemberElementImpl
implements MappingReferenceKeyElement {
    private ArrayList _referencingKey;
    private MappingTableElement _table;

    public MappingReferenceKeyElementImpl() {
        this((String)null);
    }

    public MappingReferenceKeyElementImpl(String string) {
        super(string, null);
    }

    public MappingReferenceKeyElementImpl(MappingTableElement mappingTableElement) throws ModelException {
        super(mappingTableElement.getName(), mappingTableElement.getDeclaringClass());
        this.setTableInternal(mappingTableElement);
    }

    public String getKeyName() {
        return this.getName();
    }

    public void setKeyName(String string) throws ModelException {
        this.setName(string.toString());
    }

    public MappingTableElement getTable() {
        return this._table;
    }

    public void setTable(MappingTableElement mappingTableElement) throws ModelException {
        MappingTableElement mappingTableElement2 = this.getTable();
        try {
            this.fireVetoableChange("table", mappingTableElement2, mappingTableElement);
            this.setTableInternal(mappingTableElement);
            this.firePropertyChange("table", mappingTableElement2, mappingTableElement);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new ModelVetoException(propertyVetoException);
        }
    }

    private void setTableInternal(MappingTableElement mappingTableElement) throws ModelException {
        if (mappingTableElement == null) {
            throw new ModelException(I18NHelper.getMessage(MappingElementImpl.getMessages(), "mapping.element.null_argument"));
        }
        this._table = mappingTableElement;
        if (null == this.getDeclaringClass()) {
            this._declaringClass = mappingTableElement.getDeclaringClass();
        }
        if (null == this.getName()) {
            this._name = mappingTableElement.getName();
        }
    }

    public TableElement getDeclaringTable() {
        ArrayList arrayList = this.getReferencingKey();
        if (arrayList != null && arrayList.size() > 0) {
            String string = NameUtil.getAbsoluteMemberName(this.getDeclaringClass().getDatabaseRoot(), arrayList.get(0).toString());
            return TableElement.forName(NameUtil.getTableName(string));
        }
        return null;
    }

    public void setDeclaringTable(TableElement tableElement) {
        throw new UnsupportedOperationException();
    }

    public TableElement getReferencedTable() {
        ColumnPairElement[] columnPairElementArray = this.getColumnPairs();
        if (columnPairElementArray != null && columnPairElementArray.length > 0) {
            return columnPairElementArray[0].getReferencedColumn().getDeclaringTable();
        }
        return null;
    }

    private ArrayList getReferencingKey() {
        if (this._referencingKey == null) {
            this._referencingKey = new ArrayList();
        }
        return this._referencingKey;
    }

    public ArrayList getColumnPairNames() {
        ArrayList arrayList = this.getReferencingKey();
        ArrayList arrayList2 = this.getTable().getKey();
        int n = arrayList != null ? arrayList.size() : 0;
        ArrayList<String> arrayList3 = new ArrayList<String>();
        int n2 = 0;
        while (n2 < n) {
            arrayList3.add(arrayList.get(n2) + ";" + arrayList2.get(n2));
            ++n2;
        }
        return arrayList3;
    }

    private int getIndexOfColumnPair(String string) {
        int n;
        ArrayList arrayList = this.getColumnPairNames();
        int n2 = n = arrayList != null ? arrayList.size() : 0;
        if (n > 0) {
            int n3 = 0;
            while (n3 < n) {
                if (arrayList.get(n3).equals(string)) {
                    return n3;
                }
                ++n3;
            }
        }
        return -1;
    }

    private void addKeyColumn(ColumnElement columnElement) throws ModelException {
        ArrayList arrayList = this.getReferencingKey();
        String string = NameUtil.getRelativeMemberName(columnElement.getName().getFullName());
        try {
            this.fireVetoableChange("keyColumns", null, null);
            arrayList.add(string);
            this.firePropertyChange("keyColumns", null, null);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new ModelVetoException(propertyVetoException);
        }
    }

    public ColumnElement[] getLocalColumns() {
        ColumnPairElement[] columnPairElementArray = this.getColumnPairs();
        int n = columnPairElementArray != null ? columnPairElementArray.length : 0;
        ColumnElement[] columnElementArray = new ColumnElement[n];
        int n2 = 0;
        while (n2 < n) {
            columnElementArray[n2] = columnPairElementArray[n2].getLocalColumn();
            ++n2;
        }
        return columnElementArray;
    }

    public ColumnElement[] getReferencedColumns() {
        ColumnPairElement[] columnPairElementArray = this.getColumnPairs();
        int n = columnPairElementArray != null ? columnPairElementArray.length : 0;
        ColumnElement[] columnElementArray = new ColumnElement[n];
        int n2 = 0;
        while (n2 < n) {
            columnElementArray[n2] = columnPairElementArray[n2].getReferencedColumn();
            ++n2;
        }
        return columnElementArray;
    }

    public void removeColumnPair(String string) throws ModelException {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string);
        this.removeColumnPairs(arrayList);
    }

    public void removeColumnPairs(ArrayList arrayList) throws ModelException {
        ArrayList arrayList2 = this.getReferencingKey();
        ArrayList arrayList3 = this.getTable().getKey();
        int n = arrayList != null ? arrayList.size() : 0;
        int n2 = 0;
        while (n2 < n) {
            String string = (String)arrayList.get(n2);
            int n3 = this.getIndexOfColumnPair(string);
            if (string != null) {
                try {
                    Object e = null;
                    Object e2 = null;
                    this.fireVetoableChange("keyColumns", null, null);
                    e = arrayList3.remove(n3);
                    e2 = arrayList2.remove(n3);
                    if (e == null || e2 == null) {
                        if (e != null) {
                            arrayList3.add(n3, e);
                        } else if (e2 != null) {
                            arrayList2.add(n3, e2);
                        }
                        throw new ModelException(I18NHelper.getMessage(MappingElementImpl.getMessages(), "mapping.element.element_not_removed", string));
                    }
                    this.firePropertyChange("keyColumns", null, null);
                }
                catch (PropertyVetoException propertyVetoException) {
                    throw new ModelVetoException(propertyVetoException);
                }
            }
            ++n2;
        }
    }

    public void addColumnPair(ColumnPairElement columnPairElement) throws ModelException {
        this.addColumnPairs(new ColumnPairElement[]{columnPairElement});
    }

    public void addColumnPairs(ColumnPairElement[] columnPairElementArray) throws ModelException {
        MappingTableElementImpl mappingTableElementImpl = (MappingTableElementImpl)this.getTable();
        int n = columnPairElementArray != null ? columnPairElementArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            ColumnPairElement columnPairElement = columnPairElementArray[n2];
            if (columnPairElement != null) {
                if (this.getIndexOfColumnPair(NameUtil.getRelativeMemberName(columnPairElement.getName().getFullName())) == -1) {
                    mappingTableElementImpl.addKeyColumnInternal(columnPairElement.getReferencedColumn());
                    this.addKeyColumn(columnPairElement.getLocalColumn());
                }
            } else {
                throw new ModelException(I18NHelper.getMessage(MappingElementImpl.getMessages(), "mapping.element.null_argument"));
            }
            ++n2;
        }
    }

    public void removeColumnPair(ColumnPairElement columnPairElement) throws ModelException {
        this.removeColumnPairs(new ColumnPairElement[]{columnPairElement});
    }

    public void removeColumnPairs(ColumnPairElement[] columnPairElementArray) throws ModelException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = columnPairElementArray != null ? columnPairElementArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            ColumnPairElement columnPairElement = columnPairElementArray[n2];
            arrayList.add(NameUtil.getRelativeMemberName(columnPairElement.getName().getFullName()));
            ++n2;
        }
        this.removeColumnPairs(arrayList);
    }

    public void setColumnPairs(ColumnPairElement[] columnPairElementArray) throws ModelException {
        this.removeColumnPairs(this.getColumnPairNames());
        this.addColumnPairs(columnPairElementArray);
    }

    public ColumnPairElement[] getColumnPairs() {
        ArrayList arrayList = this.getColumnPairNames();
        TableElement tableElement = this.getDeclaringTable();
        int n = arrayList != null ? arrayList.size() : 0;
        ColumnPairElement[] columnPairElementArray = new ColumnPairElement[n];
        String string = this.getDeclaringClass().getDatabaseRoot();
        int n2 = 0;
        while (n2 < n) {
            String string2 = NameUtil.getAbsoluteMemberName(string, (String)arrayList.get(n2));
            columnPairElementArray[n2] = (ColumnPairElement)tableElement.getMember(DBIdentifier.create(string2));
            ++n2;
        }
        return columnPairElementArray;
    }

    public ColumnPairElement getColumnPair(DBIdentifier dBIdentifier) {
        ColumnPairElement[] columnPairElementArray = this.getColumnPairs();
        int n = columnPairElementArray != null ? columnPairElementArray.length : 0;
        String string = this.getDeclaringClass().getDatabaseRoot();
        if (n > 0) {
            String string2 = NameUtil.getAbsoluteTableName(string, this.getTable().getName());
            ColumnPairElement columnPairElement = (ColumnPairElement)TableElement.forName(string2).getMember(dBIdentifier);
            int n2 = 0;
            while (n2 < n) {
                if (columnPairElementArray[n2].equals(columnPairElement)) {
                    return columnPairElement;
                }
                ++n2;
            }
        }
        return null;
    }

    public void setReferencingKey(ArrayList arrayList) {
        this._referencingKey = arrayList;
    }

    protected void stripSchemaName() {
        this._name = NameUtil.getRelativeTableName(this._name);
        if (this._referencingKey != null) {
            ListIterator<String> listIterator = this._referencingKey.listIterator();
            while (listIterator.hasNext()) {
                listIterator.set(NameUtil.getRelativeMemberName((String)listIterator.next()));
            }
        }
    }
}

