/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model;

import archiver.XMLInputStream;
import archiver.XMLOutputStream;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.model.jdo.impl.PersistenceClassElementImpl;
import com.sun.jdo.api.persistence.model.jdo.impl.PersistenceFieldElementImpl;
import com.sun.jdo.api.persistence.model.jdo.impl.RelationshipElementImpl;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingClassElementImpl;
import com.sun.jdo.api.persistence.model.util.ModelValidator;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.WeakHashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public abstract class Model {
    public static final Model DEVELOPMENT;
    public static final Model RUNTIME;
    public static final Model ENHANCER;
    public final String PROPERTY_MULTIPLE_CLASS_LOADERS = "com.sun.jdo.api.persistence.model.multipleClassLoaders";
    public static final String MULTIPLE_CLASS_LOADERS_IGNORE = "ignore";
    public static final String MULTIPLE_CLASS_LOADERS_RELOAD = "reload";
    public static final String MULTIPLE_CLASS_LOADERS_ERROR = "error";
    public static final String[] EQUALS_ARGS;
    public static final String[] NO_ARGS;
    public static final String[] READ_OBJECT_ARGS;
    public static final String[] WRITE_OBJECT_ARGS;
    private static final Map _classes;
    private static final Set _nonPCClasses;
    private static List _illegalPrefixes;
    private static List _illegalClasses;
    private static List _scoClasses;
    private static List _mutableScoClasses;
    private static List _collectionClasses;
    public static final String messageBase = "com.sun.jdo.api.persistence.model.Bundle";
    private static final ResourceBundle _messages;
    static /* synthetic */ Class class$com$sun$jdo$api$persistence$model$Model;

    protected static Model NewModel(String string, String string2) {
        Class<?> clazz = null;
        Model model = null;
        try {
            if (string != null) {
                Class.forName(string);
            }
            if ((clazz = Class.forName(string2)) != null) {
                model = (Model)clazz.newInstance();
            }
        }
        catch (Exception exception) {}
        return model;
    }

    protected static final ResourceBundle getMessages() {
        return _messages;
    }

    protected abstract BufferedInputStream getInputStreamForResource(String var1, ClassLoader var2, String var3);

    public abstract boolean isInterface(String var1);

    public boolean hasPersistentSuperclass(String string) {
        while ((string = this.getSuperclass(string)) != null) {
            if (!this.isPersistent(string)) continue;
            return true;
        }
        return false;
    }

    protected abstract String findPenultimateSuperclass(String var1);

    protected abstract String getSuperclass(String var1);

    public PersistenceClassElement getPersistenceClass(String string) {
        return this.getPersistenceClass(string, null);
    }

    public PersistenceClassElement getPersistenceClass(String string, ClassLoader classLoader) {
        return this.getPersistenceClass(this.getMappingClass(string, classLoader));
    }

    protected PersistenceClassElement getPersistenceClass(MappingClassElement mappingClassElement) {
        return mappingClassElement == null ? null : ((MappingClassElementImpl)mappingClassElement).getPersistenceElement();
    }

    public MappingClassElement getMappingClass(String string) {
        return this.getMappingClass(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappingClassElement getMappingClass(String string, ClassLoader classLoader) {
        Map map = _classes;
        synchronized (map) {
            MappingClassElement mappingClassElement = (MappingClassElement)_classes.get(string);
            if (mappingClassElement == null) {
                if (_nonPCClasses.contains(string)) {
                    return null;
                }
                try {
                    BufferedInputStream bufferedInputStream = this.getInputStreamForResource(string, classLoader, this.getResourceNameWithExtension(string));
                    if (bufferedInputStream != null) {
                        if (((InputStream)bufferedInputStream).available() > 0) {
                            XMLInputStream xMLInputStream = new XMLInputStream(bufferedInputStream, this.getClass().getClassLoader());
                            mappingClassElement = (MappingClassElement)xMLInputStream.readObject();
                            xMLInputStream.close();
                            mappingClassElement.postUnarchive();
                            _classes.put(string, mappingClassElement);
                            mappingClassElement.setModified(false);
                            this.getPersistenceClass(mappingClassElement).setModified(false);
                        }
                    } else {
                        _nonPCClasses.add(string);
                    }
                }
                catch (ModelException modelException) {
                    System.out.println(modelException.getMessage());
                    return null;
                }
                catch (Exception exception) {
                    System.out.println(I18NHelper.getMessage(Model.getMessages(), "file.cannot_read", string, exception.toString()));
                }
            }
            return mappingClassElement;
        }
    }

    public Map getMappingCache() {
        return Collections.unmodifiableMap(_classes);
    }

    public Map getClassLoaderCache() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromCaches(String string) {
        Map map = _classes;
        synchronized (map) {
            _classes.remove(string);
            _nonPCClasses.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(String string) {
        Map map = _classes;
        synchronized (map) {
            _nonPCClasses.remove(string);
        }
    }

    public void storeMappingClass(MappingClassElement mappingClassElement) throws IOException {
        if (mappingClassElement != null) {
            String string = mappingClassElement.getName();
            BufferedOutputStream bufferedOutputStream = string == null ? null : this.createFile(string, this.getFileName(string), "mapping");
            this.storeMappingClass(mappingClassElement, bufferedOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeMappingClass(MappingClassElement mappingClassElement, OutputStream outputStream) throws IOException {
        String string;
        block7: {
            if (mappingClassElement == null) return;
            string = mappingClassElement.getName();
            if (outputStream == null) throw new IOException(I18NHelper.getMessage(Model.getMessages(), "file.cannot_save", string));
            XMLOutputStream xMLOutputStream = new XMLOutputStream(outputStream);
            try {
                try {
                    mappingClassElement.preArchive();
                    xMLOutputStream.writeObject(mappingClassElement);
                    mappingClassElement.setModified(false);
                    this.getPersistenceClass(mappingClassElement).setModified(false);
                }
                catch (ModelException modelException) {
                    System.out.println(modelException.getMessage());
                    Object var7_6 = null;
                    if (xMLOutputStream != null) {
                        xMLOutputStream.close();
                    }
                    this.unlockFile(outputStream, string);
                    return;
                }
                Object var7_5 = null;
                if (xMLOutputStream == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (xMLOutputStream != null) {
                    xMLOutputStream.close();
                }
                this.unlockFile(outputStream, string);
                throw throwable;
            }
            xMLOutputStream.close();
        }
        this.unlockFile(outputStream, string);
    }

    public void unlockFile(OutputStream outputStream, String string) throws IOException {
        this.unlockFile(string);
        if (outputStream != null) {
            outputStream.close();
        }
    }

    public void lockFile(String string) throws IOException {
    }

    public void unlockFile(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMappingClass(String string) throws IOException {
        MappingClassElement mappingClassElement = null;
        Map map = _classes;
        synchronized (map) {
            mappingClassElement = (MappingClassElement)_classes.get(string);
        }
        this.storeMappingClass(mappingClassElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateKeyForClass(MappingClassElement mappingClassElement, String string) {
        Map map = _classes;
        synchronized (map) {
            if (string != null) {
                _classes.remove(string);
            }
            if (mappingClassElement != null) {
                String string2 = mappingClassElement.getName();
                _classes.put(string2, mappingClassElement);
                _nonPCClasses.remove(string2);
            }
        }
    }

    public boolean isPersistent(String string) {
        return this.isPersistent(string, (ClassLoader)null);
    }

    public boolean isPersistent(String string, ClassLoader classLoader) {
        return this.getPersistenceClass(string, classLoader) != null;
    }

    public boolean isPersistenceCapableAllowed(String string) {
        int n = this.getModifiersForClass(string);
        if (!(Modifier.isStatic(n) || Modifier.isAbstract(n) || this.isInterface(string) || this.hasPersistentSuperclass(string))) {
            String string2;
            String string3 = this.findPenultimateSuperclass(string);
            Iterator iterator = _illegalPrefixes.iterator();
            while (iterator.hasNext()) {
                string2 = iterator.next().toString();
                if (!string3.startsWith(string2)) continue;
                return false;
            }
            iterator = _illegalClasses.iterator();
            while (iterator.hasNext()) {
                string2 = iterator.next().toString();
                if (!string3.equals(string2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected String getResourceNameWithExtension(String string) {
        return this.getResourceName(string) + "." + "mapping";
    }

    protected String getResourceName(String string) {
        return string != null ? string.replace('.', '/') : null;
    }

    protected String getFileNameWithExtension(String string) {
        return this.getFileName(string) + "." + "mapping";
    }

    protected String getFileName(String string) {
        return string != null ? string.replace('.', File.separatorChar) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertToPersistenceCapable(String string, boolean bl) throws IOException {
        Exception exception;
        block12: {
            boolean bl2 = this.isPersistent(string);
            exception = null;
            if (bl && !bl2 && this.isPersistenceCapableAllowed(string)) {
                try {
                    this.createSkeletonMappingClass(string);
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
            }
            if (!bl && bl2 || exception != null) {
                try {
                    this.deleteFile(string, this.getFileNameWithExtension(string));
                    Map map = _classes;
                    synchronized (map) {
                        _classes.remove(string);
                        _nonPCClasses.add(string);
                    }
                }
                catch (Exception exception3) {
                    if (exception != null) break block12;
                    exception = exception3;
                }
            }
        }
        if (exception != null) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
        }
    }

    public void convertToPersistenceCapable(String string) throws IOException {
        this.convertToPersistenceCapable(string, true);
        this.convertDefaultFields(string);
        this.storeMappingClass(string);
    }

    private void createSkeletonMappingClass(String string) {
        PersistenceClassElement persistenceClassElement = new PersistenceClassElement(new PersistenceClassElementImpl(string));
        this.updateKeyForClass(new MappingClassElementImpl(persistenceClassElement), null);
    }

    public void convertDefaultFields(String string) {
        this.convertFields(string, this.getFields(string));
    }

    public void convertFields(String string, List list) {
        PersistenceClassElement persistenceClassElement = this.getPersistenceClass(string);
        if (persistenceClassElement != null) {
            Iterator iterator = list.iterator();
            Object var5_5 = null;
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!this.isPersistentAllowed(string, string2) || !this.shouldBePersistent(string, string2)) continue;
                this.addFieldElement(persistenceClassElement, string2);
            }
        }
    }

    public boolean addFieldElement(PersistenceClassElement persistenceClassElement, String string) {
        String string2 = this.getFieldType(persistenceClassElement.getName(), string);
        boolean bl = this.isCollection(string2);
        try {
            if (this.isPersistent(string2) || bl) {
                RelationshipElement relationshipElement = new RelationshipElement(new RelationshipElementImpl(string), persistenceClassElement);
                if (bl) {
                    relationshipElement.setCollectionClass(this.getDefaultCollectionClass(string2));
                } else {
                    relationshipElement.setUpperBound(1);
                }
                persistenceClassElement.addField(relationshipElement);
            } else {
                persistenceClassElement.addField(new PersistenceFieldElement(new PersistenceFieldElementImpl(string), persistenceClassElement));
            }
            return true;
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public void removeFieldElement(PersistenceFieldElement persistenceFieldElement) throws ModelException {
        if (persistenceFieldElement != null) {
            if (persistenceFieldElement instanceof RelationshipElement) {
                ((RelationshipElement)persistenceFieldElement).setInverseRelationship(null, this);
            }
            persistenceFieldElement.getDeclaringClass().removeField(persistenceFieldElement);
        }
    }

    public String getRelatedClass(RelationshipElement relationshipElement) {
        if (relationshipElement != null) {
            String string = this.getFieldType(relationshipElement.getDeclaringClass().getName(), relationshipElement.getName());
            String string2 = this.isCollection(string) ? relationshipElement.getElementClass() : string;
            return StringHelper.isEmpty(string2) ? null : string2.trim();
        }
        return null;
    }

    public ArrayList getSupportedCollectionClasses(String string) {
        String string2 = "java.util.HashSet";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        return arrayList;
    }

    public String getDefaultCollectionClass(String string) {
        String string2 = "java.util.HashSet";
        return string2;
    }

    protected abstract BufferedOutputStream createFile(String var1, String var2, String var3) throws IOException;

    protected abstract void deleteFile(String var1, String var2) throws IOException;

    public abstract List getFields(String var1);

    public List getAllFields(String string) {
        ArrayList arrayList = new ArrayList();
        while (string != null) {
            arrayList.addAll(this.getFields(string));
            string = this.getSuperclass(string);
        }
        return arrayList;
    }

    public Object getClass(String string) {
        return this.getClass(string, null);
    }

    public abstract Object getClass(String var1, ClassLoader var2);

    public boolean hasClass(String string) {
        return this.hasClass(string, null);
    }

    public boolean hasClass(String string, ClassLoader classLoader) {
        return this.getClass(string, classLoader) != null;
    }

    public abstract boolean implementsInterface(Object var1, String var2);

    public abstract boolean hasConstructor(String var1);

    public abstract Object getConstructor(String var1, String[] var2);

    public abstract Object getMethod(String var1, String var2, String[] var3);

    public abstract String getType(Object var1);

    public abstract Object getField(String var1, String var2);

    public Object getInheritedField(String string, String string2) {
        String string3 = this.getSuperclass(string);
        Object object = null;
        while (string3 != null && (object = this.getField(string3, string2)) == null) {
            string3 = this.getSuperclass(string3);
        }
        return object;
    }

    public boolean hasField(String string, String string2) {
        return this.getField(string, string2) != null;
    }

    public String getFieldType(String string, String string2) {
        return this.getType(this.getField(string, string2));
    }

    public abstract boolean isSerializable(Object var1);

    public boolean isPrimitive(String string, String string2) {
        return this.isPrimitive(this.getFieldType(string, string2));
    }

    protected boolean isPrimitive(String string) {
        return string != null && JavaTypeHelper.getPrimitiveClass(string) != null;
    }

    public abstract boolean isArray(String var1, String var2);

    public boolean isByteArray(String string, String string2) {
        return this.isByteArray(this.getFieldType(string, string2));
    }

    protected boolean isByteArray(String string) {
        return "byte[]".equals(string);
    }

    public boolean isCollection(String string) {
        return _collectionClasses.contains(string);
    }

    public boolean isSecondClassObject(String string) {
        return _scoClasses.contains(string);
    }

    public boolean isMutableSecondClassObject(String string) {
        return _mutableScoClasses.contains(string);
    }

    public abstract int getModifiers(Object var1);

    public int getModifiersForClass(String string) {
        return this.getModifiers(this.getClass(string));
    }

    protected int getModifiers(String string, String string2) {
        return this.getModifiers(this.getField(string, string2));
    }

    public boolean isPersistentAllowed(String string, String string2) {
        return this.isPersistentAllowed(string, null, string2);
    }

    public boolean isPersistentAllowed(String string, ClassLoader classLoader, String string2) {
        int n = this.getModifiers(string, string2);
        if (!Modifier.isStatic(n) && !Modifier.isFinal(n)) {
            return this.isPersistentTypeAllowed(this.getFieldType(string, string2), classLoader);
        }
        return false;
    }

    protected boolean isPersistentTypeAllowed(String string, ClassLoader classLoader) {
        return this.isPrimitive(string) || this.isSecondClassObject(string) || this.isByteArray(string) || this.isPersistent(string, classLoader);
    }

    public boolean shouldBePersistent(String string, String string2) {
        return !Modifier.isVolatile(this.getModifiers(string, string2));
    }

    public PersistenceFieldElement getPersistenceField(String string, String string2) {
        return this.hasField(string, string2) ? this.getPersistenceFieldInternal(string, string2) : null;
    }

    protected PersistenceFieldElement getPersistenceFieldInternal(String string, String string2) {
        PersistenceClassElement persistenceClassElement = this.getPersistenceClass(string);
        return persistenceClassElement != null ? persistenceClassElement.getField(string2) : null;
    }

    public boolean isPersistent(String string, String string2) {
        PersistenceFieldElement persistenceFieldElement = this.getPersistenceField(string, string2);
        if (persistenceFieldElement != null) {
            return 0 == persistenceFieldElement.getPersistenceType();
        }
        return false;
    }

    public boolean isKey(String string, String string2) {
        String string3;
        PersistenceClassElement persistenceClassElement;
        if (this.hasField(string, string2) && (persistenceClassElement = this.getPersistenceClass(string)) != null && (string3 = persistenceClassElement.getKeyClass()) != null) {
            return this.hasField(string3, string2);
        }
        return false;
    }

    public boolean isDefaultFetchGroup(String string, String string2) {
        MappingClassElement mappingClassElement = this.getMappingClass(string);
        try {
            return 1 == mappingClassElement.getField(string2).getFetchGroup();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean parse(String string) {
        return new ModelValidator(this, string, Model.getMessages()).parseCheck();
    }

    public Collection validate(String string, ResourceBundle resourceBundle) {
        return this.validate(string, null, resourceBundle);
    }

    public Collection validate(String string, ClassLoader classLoader, ResourceBundle resourceBundle) {
        return new ModelValidator(this, string, classLoader, resourceBundle == null ? Model.getMessages() : resourceBundle).fullValidationCheck();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        EQUALS_ARGS = new String[]{"java.lang.Object"};
        NO_ARGS = new String[0];
        READ_OBJECT_ARGS = new String[]{"java.io.ObjectInputStream"};
        WRITE_OBJECT_ARGS = new String[]{"java.io.ObjectOutputStream"};
        _classes = new MappingClassCache();
        _nonPCClasses = new WeakHashSet();
        _messages = I18NHelper.loadBundle(class$com$sun$jdo$api$persistence$model$Model == null ? (class$com$sun$jdo$api$persistence$model$Model = Model.class$("com.sun.jdo.api.persistence.model.Model")) : class$com$sun$jdo$api$persistence$model$Model);
        String[] stringArray = new String[]{"java.awt", "java.applet", "javax.swing", "javax.ejb"};
        String[] stringArray2 = new String[]{"java.lang.Throwable"};
        String[] stringArray3 = new String[]{"java.util.Collection", "java.util.AbstractCollection", "java.util.Set", "java.util.AbstractSet", "java.util.HashSet", "com.sun.jdo.spi.persistence.support.sqlstore.sco.HashSet"};
        String[] stringArray4 = new String[]{"java.util.Date", "com.sun.jdo.spi.persistence.support.sqlstore.sco.Date", "java.sql.Date", "com.sun.jdo.spi.persistence.support.sqlstore.sco.SqlDate", "java.sql.Time", "com.sun.jdo.spi.persistence.support.sqlstore.sco.SqlTime", "java.sql.Timestamp", "com.sun.jdo.spi.persistence.support.sqlstore.sco.SqlTimestamp"};
        String[] stringArray5 = new String[]{"java.lang.String", "java.lang.Character", "java.lang.Boolean", "java.lang.Long", "java.lang.Number", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Float", "java.lang.Double", "java.math.BigDecimal", "java.math.BigInteger"};
        _illegalPrefixes = Arrays.asList(stringArray);
        _illegalClasses = Arrays.asList(stringArray2);
        _collectionClasses = Arrays.asList(stringArray3);
        _mutableScoClasses = new ArrayList<String>(Arrays.asList(stringArray4));
        _mutableScoClasses.addAll(_collectionClasses);
        _scoClasses = new ArrayList<String>(Arrays.asList(stringArray5));
        _scoClasses.addAll(_mutableScoClasses);
        DEVELOPMENT = Model.NewModel("org.openide.src.MemberElement", "com.sun.jdo.api.persistence.model.DevelopmentModel");
        RUNTIME = Model.NewModel(null, "com.sun.jdo.api.persistence.model.RuntimeModel");
        ENHANCER = Model.NewModel(null, "com.sun.jdo.api.persistence.model.EnhancerModel");
    }

    private static final class MappingClassCache
    extends HashMap {
        ReferenceQueue queue = new ReferenceQueue();

        private MappingClassCache() {
        }

        public final Object put(Object object, Object object2) {
            this.processQueue();
            return this.getReferenceObject(super.put(object, new WeakValue(object, object2, this.queue)));
        }

        public final Object get(Object object) {
            return this.getReferenceObject((WeakReference)super.get(object));
        }

        public final Object remove(Object object) {
            return this.getReferenceObject((WeakReference)super.remove(object));
        }

        private final Object getReferenceObject(WeakReference weakReference) {
            return weakReference != null ? weakReference.get() : null;
        }

        private final void processQueue() {
            WeakValue weakValue = null;
            while ((weakValue = (WeakValue)this.queue.poll()) != null) {
                super.remove(weakValue.key);
            }
        }

        private static final class WeakValue
        extends WeakReference {
            private Object key;

            WeakValue(Object object, Object object2, ReferenceQueue referenceQueue) {
                super(object2, referenceQueue);
                this.key = object;
            }

            public boolean equals(Object object) {
                Object t;
                if (this == object) {
                    return true;
                }
                if (!(object instanceof WeakValue)) {
                    return false;
                }
                Object t2 = this.get();
                if (t2 == (t = ((WeakValue)object).get())) {
                    return true;
                }
                if (t2 == null || t == null) {
                    return false;
                }
                return t2.equals(t);
            }

            public int hashCode() {
                Object t = this.get();
                return t != null ? t.hashCode() : 0;
            }
        }
    }
}

