/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.util;

import com.sun.jdo.api.persistence.enhancer.util.ClassFileSource;
import com.sun.jdo.api.persistence.enhancer.util.DirectoryClassPathElement;
import com.sun.jdo.api.persistence.enhancer.util.ZipFileClassPathElement;
import java.io.File;
import java.util.Enumeration;

abstract class ClassPathElement {
    private ClassPathElement next;

    public abstract ClassFileSource sourceOf(String var1);

    public abstract Enumeration classesInPackage(String var1);

    abstract boolean matches(File var1);

    ClassPathElement next() {
        return this.next;
    }

    void setNext(ClassPathElement classPathElement) {
        this.next = classPathElement;
    }

    ClassPathElement() {
    }

    static ClassPathElement create(String string) {
        File file = new File(string);
        if (!file.isDirectory() && ClassPathElement.looksLikeZipName(string)) {
            return new ZipFileClassPathElement(file);
        }
        return new DirectoryClassPathElement(file);
    }

    void append(ClassPathElement classPathElement) {
        ClassPathElement classPathElement2 = this;
        while (classPathElement2.next() != null) {
            classPathElement2 = classPathElement2.next();
        }
        classPathElement2.next = classPathElement;
    }

    protected static boolean looksLikeZipName(String string) {
        return string.length() > 4 && (string.regionMatches(true, string.length() - 4, ".zip", 0, 4) || string.regionMatches(true, string.length() - 4, ".jar", 0, 4));
    }
}

