/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.Insn;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnError;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnReadEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTarget;
import java.io.PrintStream;

public class InsnTableSwitch
extends Insn {
    private int lowOp;
    private InsnTarget defaultOp;
    private InsnTarget[] targetsOp;

    public int nStackArgs() {
        return 1;
    }

    public int nStackResults() {
        return 0;
    }

    public String argTypes() {
        return "I";
    }

    public String resultTypes() {
        return "";
    }

    public boolean branches() {
        return true;
    }

    public void markTargets() {
        this.defaultOp.setBranchTarget();
        int n = 0;
        while (n < this.targetsOp.length) {
            this.targetsOp[n].setBranchTarget();
            ++n;
        }
    }

    public int lowCase() {
        return this.lowOp;
    }

    public InsnTarget defaultTarget() {
        return this.defaultOp;
    }

    public InsnTarget[] switchTargets() {
        return this.targetsOp;
    }

    public InsnTableSwitch(int n, InsnTarget insnTarget, InsnTarget[] insnTargetArray) {
        this(n, insnTarget, insnTargetArray, -1);
    }

    void print(PrintStream printStream, int n) {
        ClassPrint.spaces(printStream, n);
        printStream.println(this.offset() + "  opc_tableswitch  ");
        int n2 = 0;
        while (n2 < this.targetsOp.length) {
            int n3 = n2 + this.lowOp;
            if (this.targetsOp[n2].offset() != this.defaultOp.offset()) {
                ClassPrint.spaces(printStream, n + 2);
                printStream.println(n3 + " -> " + this.targetsOp[n2].offset());
            }
            ++n2;
        }
        ClassPrint.spaces(printStream, n + 2);
        printStream.println("default -> " + this.defaultOp.offset());
    }

    int store(byte[] byArray, int n) {
        byArray[n++] = (byte)this.opcode();
        n = n + 3 & 0xFFFFFFFC;
        n = Insn.storeInt(byArray, n, this.defaultOp.offset() - this.offset());
        n = Insn.storeInt(byArray, n, this.lowOp);
        n = Insn.storeInt(byArray, n, this.lowOp + this.targetsOp.length - 1);
        int n2 = 0;
        while (n2 < this.targetsOp.length) {
            n = Insn.storeInt(byArray, n, this.targetsOp[n2].offset() - this.offset());
            ++n2;
        }
        return n;
    }

    int size() {
        int n = (this.offset() + 4 & 0xFFFFFFFC) - this.offset() + 12;
        return n + this.targetsOp.length * 4;
    }

    InsnTableSwitch(int n, InsnTarget insnTarget, InsnTarget[] insnTargetArray, int n2) {
        super(170, n2);
        this.lowOp = n;
        this.defaultOp = insnTarget;
        this.targetsOp = insnTargetArray;
        if (insnTarget == null || insnTargetArray == null) {
            throw new InsnError("attempt to create an opc_tableswitch with invalid operands");
        }
    }

    static InsnTableSwitch read(InsnReadEnv insnReadEnv, int n) {
        int n2 = n + 1;
        int n3 = (n2 + 3 & 0xFFFFFFFC) - n2;
        while (n3 > 0) {
            insnReadEnv.getByte();
            --n3;
        }
        InsnTarget insnTarget = insnReadEnv.getTarget(insnReadEnv.getInt() + n);
        int n4 = insnReadEnv.getInt();
        int n5 = insnReadEnv.getInt();
        InsnTarget[] insnTargetArray = new InsnTarget[n5 - n4 + 1];
        int n6 = 0;
        while (n6 < insnTargetArray.length) {
            insnTargetArray[n6] = insnReadEnv.getTarget(insnReadEnv.getInt() + n);
            ++n6;
        }
        return new InsnTableSwitch(n4, insnTarget, insnTargetArray, n);
    }
}

