/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte4j.modules.dbmodel.nodes;

import com.sun.forte4j.modules.dbmodel.SchemaElement;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.DBschemaDataObject;
import com.sun.forte4j.modules.dbmodel.nodes.DBElementNodeFactory;
import com.sun.forte4j.modules.dbmodel.nodes.SchemaElementFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;

public class SchemaRootChildren
extends Children.Keys {
    static final Object NOT_KEY = new Object();
    static final Object ERROR_KEY = new Object();
    protected SchemaElement element;
    protected DBElementNodeFactory factory;
    private PropertyChangeListener wPropL;
    private DBElementListener propL;
    private boolean nodesInited = false;
    private String schemaPackage;
    private boolean parseStatus = false;
    private DBschemaDataObject obj;

    public SchemaRootChildren(DBElementNodeFactory dBElementNodeFactory, DBschemaDataObject dBschemaDataObject) {
        this.factory = dBElementNodeFactory;
        this.obj = dBschemaDataObject;
        this.schemaPackage = dBschemaDataObject.getPrimaryFile().getPackageName('.') + ".dbschema..";
    }

    protected void addNotify() {
        SchemaElement schemaElement = this.getElement();
        if (schemaElement != null) {
            if (this.wPropL == null) {
                this.propL = new DBElementListener();
                this.wPropL = WeakListener.propertyChange((PropertyChangeListener)this.propL, (Object)schemaElement);
            }
            schemaElement.addPropertyChangeListener(this.wPropL);
        }
        this.refreshKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.nodesInited = false;
    }

    protected Node[] createNodes(Object object) {
        if (object instanceof SchemaElement) {
            return new Node[]{this.factory.createSchemaNode((SchemaElement)object)};
        }
        if (NOT_KEY.equals(object)) {
            return new Node[]{this.factory.createWaitNode()};
        }
        return new Node[]{this.factory.createErrorNode()};
    }

    public SchemaElement getElement() {
        if (this.element == null && !this.parseStatus) {
            this.refreshKeys2();
            RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    SchemaRootChildren.this.nodesInited = true;
                    SchemaRootChildren.this.setElement(SchemaRootChildren.this.obj.getSchema());
                    SchemaRootChildren.this.parseStatus = true;
                }
            }, (int)0);
        }
        return this.element;
    }

    public void setElement(SchemaElement schemaElement) {
        if (this.element != null) {
            this.element.removePropertyChangeListener(this.wPropL);
        }
        this.element = schemaElement;
        if (this.element != null) {
            if (this.wPropL == null) {
                this.propL = new DBElementListener();
                this.wPropL = WeakListener.propertyChange((PropertyChangeListener)this.propL, (Object)this.element);
            }
            this.element.addPropertyChangeListener(this.wPropL);
        }
        if (this.nodesInited) {
            this.refreshKeys();
        }
    }

    public void refreshKeys() {
        SchemaElement schemaElement = this.getElement();
        int n = this.parseStatus ? (schemaElement == null ? 1 : schemaElement.getStatus()) : (schemaElement == null ? 0 : schemaElement.getStatus());
        switch (n) {
            case 0: {
                this.setKeys(new Object[]{NOT_KEY});
                break;
            }
            case 1: {
                this.setKeys(new Object[]{ERROR_KEY});
                break;
            }
            case 2: 
            case 3: {
                this.refreshAllKeys();
            }
        }
    }

    private void refreshKeys2() {
        this.setKeys(new Object[]{NOT_KEY});
    }

    private void refreshAllKeys() {
        int[] nArray = SchemaElementFilter.DEFAULT_ORDER;
        final LinkedList linkedList = new LinkedList();
        int n = 0;
        while (n < nArray.length) {
            this.addKeysOfType(linkedList, nArray[n]);
            ++n;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SchemaRootChildren.this.setKeys2(linkedList);
            }
        });
    }

    private void addKeysOfType(Collection collection, int n) {
        SchemaElement schemaElement = this.getElement();
        if (n != 0) {
            collection.add(schemaElement);
        }
    }

    private void setKeys2(Collection collection) {
        this.setKeys(collection);
    }

    private final class DBElementListener
    implements PropertyChangeListener {
        private DBElementListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = "schema".equals(propertyChangeEvent.getPropertyName());
            if (!bl && "status".equals(propertyChangeEvent.getPropertyName())) {
                Integer n = (Integer)propertyChangeEvent.getNewValue();
                boolean bl2 = bl = n == null || n != 0;
            }
            if (bl) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ DBElementListener this$1;
                    {
                        this.this$1 = dBElementListener;
                    }

                    public void run() {
                        DBElementListener.access$500(this.this$1).refreshKeys();
                    }
                });
            }
        }

        static /* synthetic */ SchemaRootChildren access$500(DBElementListener dBElementListener) {
            return dBElementListener.SchemaRootChildren.this;
        }
    }
}

