/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.i18n;

import com.iplanet.ias.tools.forte.i18n.DirectoryModel;
import com.iplanet.ias.tools.forte.i18n.FileType;
import com.iplanet.ias.tools.forte.i18n.FilterFileType;
import com.iplanet.ias.tools.forte.i18n.MDirList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class FileSelectionPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    JLabel mLabTitle;
    JButton mUpButton;
    JTextField mDirField;
    JTextField mFilterField;
    MDirList mDirPane;
    private DirectoryModel dm = null;

    public FileSelectionPanel(String title) {
        this.createControls(title);
    }

    void createControls(String title) {
        TitledBorder fileselBorder = new TitledBorder(null, title, 1, 2, null);
        this.setBorder(fileselBorder);
        this.setLayout(new BorderLayout());
        this.dm = new DirectoryModel();
        this.mDirPane = new MDirList(this.dm);
        this.mDirPane.setDoubleClickCommand("double-click");
        ((DirectoryModel)this.mDirPane.getModel()).addPropertyChangeListener(this);
        JScrollPane scroller = new JScrollPane(this.mDirPane);
        scroller.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add("Center", scroller);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout(10, 8));
        topPanel.add("West", new JLabel(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("lbLookIn")));
        topPanel.add("South", Box.createVerticalStrut(5));
        this.mDirField = new JTextField(((DirectoryModel)this.mDirPane.getModel()).getCurrentDirectory().getAbsolutePath());
        this.mDirField.setToolTipText(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("enterDirToExpand"));
        this.mDirField.getAccessibleContext().setAccessibleName("Directoryname");
        this.mDirField.addActionListener(this);
        topPanel.add("Center", this.mDirField);
        ImageIcon upFolderIcon = new ImageIcon(this.getClass().getResource("/com/iplanet/ias/tools/forte/i18n/resources/updir.gif"));
        this.mUpButton = new JButton(upFolderIcon);
        this.mUpButton.setMargin(new Insets(0, 0, 0, 0));
        this.mUpButton.setFocusPainted(false);
        this.mUpButton.setToolTipText(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("upOneLevel"));
        this.mUpButton.getAccessibleContext().setAccessibleName("Up");
        this.mUpButton.setActionCommand("Go up");
        this.mUpButton.addActionListener(this);
        topPanel.add("East", this.mUpButton);
        this.checkButton();
        this.add("North", topPanel);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout(10, 8));
        bottomPanel.add("West", new JLabel(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("lbFilter")));
        bottomPanel.add("South", Box.createVerticalStrut(5));
        bottomPanel.add("North", Box.createVerticalStrut(5));
        bottomPanel.add("East", Box.createHorizontalStrut(10));
        String strFilter = "*.jsp";
        this.mFilterField = new JTextField(strFilter);
        this.mFilterField.setToolTipText(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("enterFilterExpr"));
        this.mFilterField.getAccessibleContext().setAccessibleName("FilterExpression");
        this.mFilterField.addActionListener(this);
        bottomPanel.add("Center", this.mFilterField);
        this.add("South", bottomPanel);
        FileType[] types = new FileType[]{FileType.SharedFolder, new FilterFileType(strFilter)};
        this.dm.setKnownFileTypes(types);
        this.dm.setShownType(types[1]);
    }

    private void checkButton() {
        if (((DirectoryModel)this.mDirPane.getModel()).canGoUp()) {
            this.mUpButton.setEnabled(true);
        } else {
            this.mUpButton.setEnabled(false);
        }
    }

    public String getFilterPattern() {
        return this.mFilterField.getText();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == null) {
            command = "";
        }
        if (e.getSource() == this.mDirField) {
            File newDir = new File(this.mDirField.getText());
            if (newDir.isDirectory()) {
                ((DirectoryModel)this.mDirPane.getModel()).setCurrentDirectory(newDir);
            } else {
                this.mDirField.setText(((DirectoryModel)this.mDirPane.getModel()).getCurrentDirectory().getAbsolutePath());
            }
        } else {
            DirectoryModel dm;
            if (e.getSource() == this.mFilterField) {
                String filter = this.mFilterField.getText();
                if (filter == null || filter.length() <= 0) {
                    FileType[] types = new FileType[]{FileType.SharedFolder, new FilterFileType("*.jsp")};
                    this.mFilterField.setText("*.jsp");
                    this.dm.setKnownFileTypes(types);
                    this.dm.setShownType(types[1]);
                    return;
                }
                FileType[] types = new FileType[]{FileType.SharedFolder, new FilterFileType(filter)};
                this.dm.setKnownFileTypes(types);
                this.dm.setShownType(types[1]);
                return;
            }
            if (command.equals("Go up") && (dm = (DirectoryModel)this.mDirPane.getModel()).canGoUp()) {
                this.mDirPane.clearSelection();
                dm.goUp();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("currentDirectory")) {
            this.checkButton();
            this.mDirField.setText(((DirectoryModel)this.mDirPane.getModel()).getCurrentDirectory().getAbsolutePath());
        }
    }

    public File[] getSelectedFiles() {
        return this.mDirPane.getSelectedFiles();
    }

    public static void main(String[] args) {
        try {
            String vers = System.getProperty("java.version");
            if (vers.compareTo("1.1.2") < 0) {
                System.out.println(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("msgFSPtestWarning"));
            }
            JFrame frame = new JFrame();
            frame.setTitle(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("titleFSPtestFrame"));
            frame.setBackground(Color.lightGray);
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add("Center", new FileSelectionPanel(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("labelFSPselect")));
            frame.addWindowListener(new AppCloser());
            frame.pack();
            frame.setSize(400, 550);
            frame.setVisible(true);
        }
        catch (Throwable t) {
            System.out.println(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("msgFSPtestErr") + t);
            t.printStackTrace();
        }
    }

    protected static final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
}

