/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.ejb.cmp.transform;

import com.iplanet.ias.tools.common.j2eedd.ejb.CmpField;
import com.iplanet.ias.tools.common.j2eedd.ejb.CmrField;
import com.iplanet.ias.tools.common.j2eedd.ejb.EjbJar;
import com.iplanet.ias.tools.common.j2eedd.ejb.EjbRelation;
import com.iplanet.ias.tools.common.j2eedd.ejb.EjbRelationshipRole;
import com.iplanet.ias.tools.common.j2eedd.ejb.EnterpriseBeans;
import com.iplanet.ias.tools.common.j2eedd.ejb.Entity;
import com.iplanet.ias.tools.common.j2eedd.ejb.Relationships;
import com.iplanet.ias.tools.forte.ejb.cmp.transform.ConversionHelper;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class EjbJarConversionHelper
implements ConversionHelper {
    private static ResourceBundle bundle = null;
    private static String CONTAINER = null;
    private static String DOT = ".";
    private Map j2eeRelations = new HashMap();
    private Map j2eeBeans = new HashMap();
    private Map fieldsMap = new HashMap();
    private static final String GENERATED_CMR_FIELD_PREFIX = "thisRelationshipFieldWasGeneratedByTheConversionHelper";
    private boolean strict;

    public EjbJarConversionHelper(InputStream in, boolean strict) {
        this.strict = strict;
        EjbJar tmp = EjbJar.createGraph(in);
        this.init(tmp);
    }

    public EjbJarConversionHelper(EjbJar jar, boolean strict) {
        this.strict = strict;
        this.init(jar);
    }

    protected EjbJarConversionHelper() {
    }

    private void init(EjbJar jar) {
        EnterpriseBeans beans = jar.getEnterpriseBeans();
        Entity aBean = null;
        int i = 0;
        i = 0;
        while (i < beans.sizeEntity()) {
            aBean = beans.getEntity(i);
            if (aBean.getPersistenceType().equals(CONTAINER)) {
                this.j2eeBeans.put(aBean.getEjbName(), aBean);
                HashMap<String, Boolean> foo2 = new HashMap<String, Boolean>();
                int q = 0;
                while (q < aBean.sizeCmpField()) {
                    CmpField oneField = aBean.getCmpField(q);
                    foo2.put(oneField.getFieldName(), new Boolean(true));
                    ++q;
                }
                this.fieldsMap.put(aBean.getEjbName(), foo2);
            }
            ++i;
        }
        int counter = 0;
        Relationships relations = jar.getRelationships();
        int len = 0;
        if (null != relations) {
            len = relations.sizeEjbRelation();
        }
        i = 0;
        while (i < len) {
            EjbRelation aRelation = relations.getEjbRelation(i);
            int j = 0;
            while (j < 2) {
                EjbRelationshipRole roleOne = aRelation.getEjbRelationshipRole(j);
                String sourceEjb = roleOne.getRelationshipRoleSource().getEjbName();
                CmrField fieldDef = roleOne.getCmrField();
                String fieldName = null;
                if (null == fieldDef && this.ensureCompleteRoles()) {
                    fieldDef = new CmrField();
                    fieldDef.setCmrFieldName(GENERATED_CMR_FIELD_PREFIX + counter++);
                    fieldDef.setCmrFieldType(bundle.getString("java.util.Collection_IMPL"));
                    roleOne.setCmrField(fieldDef);
                }
                if (null != fieldDef) {
                    fieldName = fieldDef.getCmrFieldName();
                    HashMap<String, Boolean> fieldsOnBean = (HashMap<String, Boolean>)this.fieldsMap.get(sourceEjb);
                    if (null == fieldsOnBean) {
                        fieldsOnBean = new HashMap<String, Boolean>();
                        this.fieldsMap.put(sourceEjb, fieldsOnBean);
                    }
                    fieldsOnBean.put(fieldName, new Boolean(true));
                    String fullName = sourceEjb + "." + fieldName;
                    this.j2eeRelations.put(fullName, aRelation);
                }
                ++j;
            }
            ++i;
        }
        System.out.println(jar.dumpBeanNode());
    }

    public String getMappedClassName(String beanName) {
        Entity j2ee = (Entity)((Object)this.j2eeBeans.get(beanName));
        return j2ee.getEjbClass() + "_" + beanName + "_JDOState";
    }

    public boolean isKey(String beanName, String fieldName, boolean candidate) {
        boolean retVal = candidate;
        Entity j2ee = (Entity)((Object)this.j2eeBeans.get(beanName));
        String j2eeKey = j2ee.getPrimkeyField();
        if (null != j2eeKey && !j2eeKey.equals("")) {
            retVal = j2eeKey.equals(fieldName);
        }
        return retVal;
    }

    public String getRelationshipFieldContent(String ejbName, String fieldName) {
        EjbRelation aRel = (EjbRelation)((Object)this.j2eeRelations.get(ejbName + DOT + fieldName));
        EjbRelationshipRole otherRole = this.getOtherRole(aRel, ejbName, fieldName);
        String beanInField = otherRole.getRelationshipRoleSource().getEjbName();
        return beanInField;
    }

    public String getMultiplicity(String ejbName, String fieldName) {
        EjbRelation aRel = (EjbRelation)((Object)this.j2eeRelations.get(ejbName + DOT + fieldName));
        EjbRelationshipRole otherRole = this.getOtherRole(aRel, ejbName, fieldName);
        return otherRole.getMultiplicity();
    }

    public String getRelationshipFieldType(String ejbName, String fieldName) {
        EjbRelation aRel = (EjbRelation)((Object)this.j2eeRelations.get(ejbName + DOT + fieldName));
        EjbRelationshipRole myRole = this.getMyRole(aRel, ejbName, fieldName);
        return myRole.getCmrField().getCmrFieldType();
    }

    public String getInverseFieldName(String ejbName, String fieldName) {
        EjbRelation aRel = (EjbRelation)((Object)this.j2eeRelations.get(ejbName + DOT + fieldName));
        EjbRelationshipRole otherRole = this.getOtherRole(aRel, ejbName, fieldName);
        CmrField foo2 = otherRole.getCmrField();
        String retVal = null;
        if (null != foo2) {
            retVal = foo2.getCmrFieldName();
        }
        return retVal;
    }

    private EjbRelationshipRole getMyRole(EjbRelation root, String ejbName, String fieldName) {
        return this.findRelationshipRole(root, ejbName, fieldName, true);
    }

    private EjbRelationshipRole getOtherRole(EjbRelation root, String ejbName, String fieldName) {
        return this.findRelationshipRole(root, ejbName, fieldName, false);
    }

    private EjbRelationshipRole findRelationshipRole(EjbRelation root, String ejbName, String fieldName, boolean match) {
        Object retVal = null;
        EjbRelationshipRole one = root.getEjbRelationshipRole(0);
        EjbRelationshipRole two = root.getEjbRelationshipRole(1);
        String oneBean = one.getRelationshipRoleSource().getEjbName();
        String oneField = "";
        try {
            oneField = one.getCmrField().getCmrFieldName();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (oneBean.equals(ejbName) && oneField.equals(fieldName)) {
            if (match) {
                return one;
            }
            return two;
        }
        if (match) {
            return two;
        }
        return one;
    }

    public boolean applyDefaultUnknownPKClassStratgey(String ejbName) {
        boolean retVal = false;
        Entity bean = (Entity)((Object)this.j2eeBeans.get(ejbName));
        String pkclass = bean.getPrimKeyClass();
        if (null != pkclass) {
            retVal = pkclass.equals(bundle.getString("CONST_j_l_O"));
        }
        return retVal;
    }

    public boolean hasField(String beanName, String fieldName) {
        Map fieldsOnBean = (Map)this.fieldsMap.get(beanName);
        Object foo2 = fieldsOnBean.get(fieldName);
        return null != foo2;
    }

    public Object[] getFields(String beanName) {
        Map fieldsOnBean = (Map)this.fieldsMap.get(beanName);
        return fieldsOnBean.keySet().toArray();
    }

    public boolean relatedObjectsAreDeleted(String ejbName, String fieldName) {
        EjbRelation aRel = (EjbRelation)((Object)this.j2eeRelations.get(ejbName + DOT + fieldName));
        EjbRelationshipRole otherRole = this.getOtherRole(aRel, ejbName, fieldName);
        return otherRole.isCascadeDelete();
    }

    public boolean ensureCompleteRoles() {
        return this.strict;
    }

    public boolean isPseudoCMRField(String ejbName, String fieldName) {
        return fieldName.startsWith(GENERATED_CMR_FIELD_PREFIX);
    }

    static {
        bundle = ResourceBundle.getBundle("com.iplanet.ias.tools.forte.ejb.cmp.transform.Bundle");
        CONTAINER = bundle.getString("CONTAINER_CONST");
    }
}

