/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte;

import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.common.util.diagnostics.StackTrace;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

public class ShadowFileManager {
    private static FileSystem hiddenSystem = null;
    private static HashMap prefixMap = new HashMap();
    private static Map replacementPackages;

    protected ShadowFileManager() {
    }

    public static FileSystem getHiddenSystem() {
        return hiddenSystem;
    }

    public static FileObject getFileObject(String modulePrefix, FileObject fo, String suffix, String ext) {
        Reporter.assertIt(fo, "nothing casts no shadow");
        FileObject shadow = null;
        String hiddenPrefix = null;
        Object localSystem = null;
        FileSystem key = null;
        String nameToShadow = null;
        try {
            key = fo.getFileSystem();
            Reporter.info(key);
            hiddenPrefix = (String)prefixMap.get(key);
            Reporter.info(hiddenPrefix);
            if (null == hiddenPrefix) {
                hiddenPrefix = "pcImpl" + prefixMap.size() + "/";
                prefixMap.put(key, hiddenPrefix);
            }
            nameToShadow = ShadowFileManager.cleansePackageName(fo.getPackageName('/'));
            if (null != modulePrefix && modulePrefix.trim().length() > 0) {
                hiddenPrefix = hiddenPrefix + modulePrefix + "/";
            }
            if (null != suffix) {
                nameToShadow = nameToShadow + suffix;
            }
            nameToShadow = hiddenPrefix + nameToShadow;
            shadow = hiddenSystem.findResource(nameToShadow = nameToShadow + "." + ext);
            if (null == shadow) {
                shadow = FileUtil.createData((FileObject)hiddenSystem.getRoot(), (String)nameToShadow);
            }
        }
        catch (Throwable t) {
            Reporter.critical(fo);
            Reporter.critical(fo.getPackageName(File.separatorChar));
            Reporter.critical(suffix);
            Reporter.critical(ext);
            Reporter.critical(nameToShadow);
            Reporter.critical(nameToShadow.replace('/', File.separatorChar));
            Reporter.critical(new StackTrace(t));
        }
        Reporter.info("exit: " + hiddenSystem + "/" + shadow);
        return shadow;
    }

    private static String cleansePackageName(String candidate) {
        StringTokenizer toker = new StringTokenizer(candidate, "/");
        String token = null;
        StringBuffer retVal = new StringBuffer();
        while (toker.hasMoreTokens()) {
            token = toker.nextToken();
            char[] tokenChars = new char[token.length()];
            token.getChars(0, token.length() - 1, tokenChars, 0);
            boolean testResult = true;
            int k = 0;
            while (testResult && k < tokenChars.length) {
                testResult = 0 == k ? Character.isJavaIdentifierStart(tokenChars[k]) : Character.isJavaIdentifierPart(tokenChars[k]);
                ++k;
            }
            if (!testResult) {
                retVal.append(ShadowFileManager.getValidPackageComponent(token));
            } else {
                retVal.append(token);
            }
            retVal.append('/');
        }
        retVal.deleteCharAt(retVal.length() - 1);
        return retVal.toString();
    }

    private static String getValidPackageComponent(String token) {
        String retVal = (String)replacementPackages.get(token);
        if (null == retVal) {
            retVal = "validPackageComponentID" + replacementPackages.size();
            replacementPackages.put(token, retVal);
        }
        return retVal;
    }

    public static void releaseFileSystems() {
        Repository rep = TopManager.getDefault().getRepository();
        rep.removeFileSystem(hiddenSystem);
        FileObject fso = hiddenSystem.getRoot();
        try {
            ShadowFileManager.cleanContents(fso);
        }
        catch (Throwable t) {
            Reporter.critical(new StackTrace(t));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void cleanContents(FileObject root) {
        FileObject[] files = root.getChildren();
        try {
            int i = 0;
            while (null != files) {
                if (i >= files.length) {
                    return;
                }
                files[i].delete(files[i].lock());
                ++i;
            }
            return;
        }
        catch (IOException ioe) {
            Reporter.critical(new StackTrace(ioe));
            return;
        }
    }

    static {
        Repository rep = TopManager.getDefault().getRepository();
        LocalFileSystem localSystem = null;
        localSystem = new LocalFileSystem();
        String front = System.getProperty("java.io.tmpdir");
        String fs = File.separator;
        File f = new File(front + fs + "ShadowDir" + prefixMap.size());
        Reporter.info(f);
        f.mkdirs();
        f.deleteOnExit();
        try {
            localSystem.setRootDirectory(f);
        }
        catch (Throwable t) {
            Reporter.critical(new StackTrace(t));
        }
        Reporter.info(hiddenSystem);
        FileSystem other = rep.findFileSystem(localSystem.getSystemName());
        if (null != other) {
            hiddenSystem = other;
        } else {
            hiddenSystem = localSystem;
            rep.addFileSystem(hiddenSystem);
        }
        ShadowFileManager.cleanContents(hiddenSystem.getRoot());
        hiddenSystem.setHidden(true);
        Reporter.verbose(new Exposer(hiddenSystem));
        replacementPackages = new HashMap();
    }

    static class Exposer {
        private FileSystem fs;

        Exposer(FileSystem fs) {
            this.fs = fs;
        }

        public String toString() {
            this.fs.setHidden(false);
            return NbBundle.getMessage(this.getClass(), (String)"Msg_exposer", (Object[])new Object[]{this.fs});
        }
    }
}

