/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.common.properties;

import com.iplanet.ias.tools.common.properties.PrincipalTableModel;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.openide.util.HelpCtx;

public class PrincipalsEditor
implements TableCellEditor {
    private Vector model;
    private transient Vector listeners = new Vector();
    private transient Vector originalValue;
    private JTable principalsTable;
    private JButton button;
    private JDialog d;
    private JFrame frame;
    private static ResourceBundle bundle = ResourceBundle.getBundle("com.iplanet.ias.tools.common.properties.Bundle");
    static final ResourceBundle helpBundle = ResourceBundle.getBundle("com.iplanet.ias.tools.common.HelpIDBundle");

    public PrincipalsEditor(JFrame f) {
        this.frame = f;
        this.button = new JButton();
        this.button.setBackground(Color.white);
        this.button.setBorderPainted(false);
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PrincipalsEditor.this.d == null) {
                    PrincipalsEditor.this.createDialog();
                }
                PrincipalsEditor.this.d.setVisible(true);
            }
        });
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value == null) {
            this.model = new Vector();
        } else if (value instanceof String && ((String)value).length() == 0) {
            this.model = new Vector();
        } else if (value instanceof Vector) {
            this.model = (Vector)value;
        } else {
            Reporter.error(value);
        }
        if (this.principalsTable == null) {
            this.createDialog();
        }
        this.principalsTable.setModel(new PrincipalTableModel(this.model));
        this.originalValue = this.model;
        table.setRowSelectionInterval(row, row);
        table.setColumnSelectionInterval(column, column);
        return this.button;
    }

    public void createDialog() {
        JPanel pane = new JPanel();
        this.principalsTable = new JTable();
        JScrollPane sp = new JScrollPane(this.principalsTable);
        this.d = new JDialog(this.frame, bundle.getString("PRIN_TITLE"), true);
        this.d.setSize(500, 300);
        this.d.getContentPane().setLayout(new BorderLayout());
        pane.setLayout(new BorderLayout());
        pane.add((Component)sp, "Center");
        JButton okButton = new JButton(bundle.getString("OK_BUTTON_LABEL"));
        JButton cancelButton = new JButton(bundle.getString("CANCEL_BUTTON_LABEL"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PrincipalsEditor.this.stopCellEditing();
                PrincipalsEditor.this.d.setVisible(false);
                PrincipalsEditor.this.d.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PrincipalsEditor.this.cancelCellEditing();
                PrincipalsEditor.this.d.setVisible(false);
                PrincipalsEditor.this.d.dispose();
            }
        });
        JPanel buttonsPane = new JPanel();
        buttonsPane.add(okButton);
        buttonsPane.add(cancelButton);
        HelpCtx.setHelpIDString((JComponent)pane, (String)helpBundle.getString("role_map_principal_editor"));
        pane.add((Component)buttonsPane, "South");
        this.d.getContentPane().add((Component)pane, "Center");
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.addElement(cellEditorListener);
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public Object getCellEditorValue() {
        return this.model;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.removeElement(cellEditorListener);
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        TableCellEditor cell;
        if (this.principalsTable != null && (cell = this.principalsTable.getCellEditor()) != null) {
            cell.stopCellEditing();
        }
        this.model = ((PrincipalTableModel)this.principalsTable.getModel()).getPrincipals();
        this.fireEditingStopped();
        return true;
    }

    private void fireEditingCanceled() {
        ChangeEvent ce = new ChangeEvent(this);
        int i = this.listeners.size() - 1;
        while (i >= 0) {
            ((CellEditorListener)this.listeners.elementAt(i)).editingCanceled(ce);
            --i;
        }
    }

    private void fireEditingStopped() {
        ChangeEvent ce = new ChangeEvent(this);
        int i = this.listeners.size() - 1;
        while (i >= 0) {
            ((CellEditorListener)this.listeners.elementAt(i)).editingStopped(ce);
            --i;
        }
    }
}

