/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.util;

import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.IOutput;
import com.iplanet.ias.admin.util.NullOutput;
import com.iplanet.ias.admin.util.Output;
import com.iplanet.ias.admin.util.ThrowableToString;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class Debug {
    public static final int LOW = 1;
    public static final int MEDIUM = 2;
    public static final int HIGH = 3;
    public static final int kDefaultSeverity = 1;
    private static int sDebugLevel = 1;
    private static IOutput sOutput = new NullOutput();
    private static boolean sEnabled;

    private static Output createOutput(OutputStream outputStream, boolean closeWhenDone) throws Exception {
        Output newOutput = new Output(outputStream, closeWhenDone);
        Debug.cleanup();
        sOutput = newOutput;
        return newOutput;
    }

    private static IOutput createDefaultOutput() {
        IOutput output = null;
        try {
            output = Debug.createOutput(System.err, false);
        }
        catch (Exception e) {
            ExceptionUtil.ignoreException(e);
            output = new NullOutput();
        }
        return output;
    }

    private static String getSeverityString(int severity) {
        Assert.assertit(Debug.isValidSeverity(severity), "illegal severity");
        String s = null;
        switch (severity) {
            case 1: {
                s = "LOW";
                break;
            }
            case 2: {
                s = "MEDIUM";
                break;
            }
            case 3: {
                s = "HIGH";
            }
        }
        return s;
    }

    private static String getPrefixString(int severity) {
        return "DEBUG: severity " + Debug.getSeverityString(severity) + ": ";
    }

    private static boolean testSeverity(int severity) {
        return severity >= sDebugLevel;
    }

    private static void flush() throws Exception {
        sOutput.flush();
    }

    private static void internalPrintWithException(Object msg, int severity, boolean newline) throws Exception {
        Assert.assertit(msg != null, "null msg");
        if (Debug.testSeverity(severity)) {
            String maybeNewline = newline ? "\n" : "";
            String wholeMsg = Debug.getPrefixString(severity) + msg.toString();
            if (newline) {
                sOutput.println(wholeMsg);
            } else {
                sOutput.print(wholeMsg);
            }
        }
    }

    private static void internalPrint(Object msg, int severity, boolean newline) {
        block2: {
            Assert.assertit(Debug.isValidSeverity(severity), "illegal severity");
            if (!sEnabled) break block2;
            try {
                Debug.internalPrintWithException(msg, severity, newline);
            }
            catch (Exception e) {
                ExceptionUtil.ignoreException(e);
            }
        }
    }

    public static void setFile(String name) throws Exception {
        FileOutputStream outputStream = new FileOutputStream(name);
        sOutput = Debug.createOutput(outputStream, true);
    }

    public static void setDefaultOutput() {
        Debug.createDefaultOutput();
    }

    public static boolean getEnabled() {
        return sEnabled;
    }

    public static void setEnabled(boolean enabled) {
        sEnabled = enabled;
    }

    private static boolean isValidSeverity(int severity) {
        return severity == 1 || severity == 2 || severity == 3;
    }

    public static void setDebugLevel(int severity) {
        Assert.assertit(Debug.isValidSeverity(severity), "illegal severity");
        sDebugLevel = severity;
    }

    public static int getDebugLevel() {
        return sDebugLevel;
    }

    public static void print(Object msg, int severity) {
        Debug.internalPrint(msg, severity, false);
    }

    public static void println(Object msg, int severity) {
        Debug.internalPrint(msg, severity, true);
    }

    public static void print(Object msg) {
        Debug.internalPrint(msg, 1, false);
    }

    public static void println(Object msg) {
        Debug.internalPrint(msg, 1, true);
    }

    public static void printStackTrace(Throwable e) {
        Assert.assertit(e != null, "null exception");
        Debug.internalPrint(new ThrowableToString(e), 3, false);
    }

    public static void cleanup() {
        sOutput.close();
        sOutput = new NullOutput();
    }

    static {
        sOutput = Debug.createDefaultOutput();
        sEnabled = false;
    }
}

