/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.smarticket.ejb.movieinfo;

import com.sun.j2ee.blueprints.smarticket.ejb.movieinfo.Location;
import com.sun.j2ee.blueprints.smarticket.ejb.movieinfo.Movie;
import com.sun.j2ee.blueprints.smarticket.ejb.movieinfo.Showtime;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class MovieInfoEJB
implements SessionBean {
    protected static final String MOVIEINFO_DB = "java:comp/env/jdbc/MovieInfoDataSource";
    protected DataSource dataSource;

    public void setSessionContext(SessionContext sessionContext) {
        try {
            InitialContext initialContext = new InitialContext();
            this.dataSource = (DataSource)initialContext.lookup(MOVIEINFO_DB);
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    private List getMovies() {
        try {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("select movie_id, title, rating, poster_url from movies");
            resultSet = preparedStatement.executeQuery();
            ArrayList<Movie> arrayList = new ArrayList<Movie>();
            while (resultSet.next()) {
                arrayList.add(new Movie(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4)));
            }
            resultSet.close();
            preparedStatement.close();
            connection.close();
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new EJBException(sQLException.getMessage());
        }
    }

    public List getMovies(String string) {
        try {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("select distinct m.movie_id, title, rating, poster_url from movies m, locations l, shows s where l.zipcode = ? and s.location_id = l.location_id and s.movie_id = m.movie_id");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            List<Movie> list = new ArrayList<Movie>();
            while (resultSet.next()) {
                list.add(new Movie(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4)));
            }
            resultSet.close();
            preparedStatement.close();
            connection.close();
            if (list.isEmpty()) {
                list = this.getMovies();
            }
            return list;
        }
        catch (SQLException sQLException) {
            throw new EJBException(sQLException.getMessage());
        }
    }

    private List getLocations(int n) {
        try {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("select distinct l.location_id, l.location from locations l, shows s where s.movie_id = ? and l.location_id = s.location_id");
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            ArrayList<Location> arrayList = new ArrayList<Location>();
            while (resultSet.next()) {
                arrayList.add(new Location(resultSet.getInt(1), resultSet.getString(2)));
            }
            resultSet.close();
            preparedStatement.close();
            connection.close();
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new EJBException(sQLException.getMessage());
        }
    }

    public List getLocations(String string, int n) {
        try {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("select distinct l.location_id, l.location from locations l, shows s where s.movie_id = ? and l.zipcode = ? and l.location_id = s.location_id");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            List<Location> list = new ArrayList<Location>();
            while (resultSet.next()) {
                list.add(new Location(resultSet.getInt(1), resultSet.getString(2)));
            }
            resultSet.close();
            preparedStatement.close();
            connection.close();
            if (list.isEmpty()) {
                list = this.getLocations(n);
            }
            return list;
        }
        catch (SQLException sQLException) {
            throw new EJBException(sQLException.getMessage());
        }
    }

    public List getShowtimes(int n, int n2) {
        try {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("select distinct s.show_id, s.showtime from shows s, locations l where s.movie_id = ? and s.location_id = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            resultSet = preparedStatement.executeQuery();
            ArrayList<Showtime> arrayList = new ArrayList<Showtime>();
            while (resultSet.next()) {
                arrayList.add(new Showtime(resultSet.getInt(1), resultSet.getString(2)));
            }
            resultSet.close();
            preparedStatement.close();
            connection.close();
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new EJBException(sQLException.getMessage());
        }
    }
}

