/*
 * Decompiled with CFR 0.152.
 */
package samples.connectors.simple;

import java.io.PrintWriter;
import java.io.Serializable;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import samples.connectors.simple.CometConnectionManager;
import samples.connectors.simple.CometConnectionRequestInfo;
import samples.connectors.simple.CometConnectionSpec;
import samples.connectors.simple.CometRecordFactory;
import samples.connectors.simple.CometResourceAdapterMetaData;

public class CometConnectionFactory
implements ConnectionFactory,
Serializable,
Referenceable {
    private ManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Reference reference;
    private transient PrintWriter out;
    private transient int milliseconds;

    public CometConnectionFactory() {
    }

    public CometConnectionFactory(ManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager) {
        System.out.println(" 2. In CometConnectionFactory ctor, mcf=" + managedConnectionFactory + " cm=" + connectionManager);
        this.mcf = managedConnectionFactory;
        this.cm = connectionManager == null ? new CometConnectionManager() : connectionManager;
    }

    public Connection getConnection() throws ResourceException {
        Connection connection = null;
        System.out.println("In getConnection---before allocateConnection");
        connection = (Connection)this.cm.allocateConnection(this.mcf, null);
        System.out.println("In getConnection---after allocateConnection");
        return connection;
    }

    public Connection getConnection(ConnectionSpec connectionSpec) throws ResourceException {
        Connection connection = null;
        CometConnectionRequestInfo cometConnectionRequestInfo = new CometConnectionRequestInfo(((CometConnectionSpec)connectionSpec).getUser(), ((CometConnectionSpec)connectionSpec).getPassword());
        connection = (Connection)this.cm.allocateConnection(this.mcf, (ConnectionRequestInfo)cometConnectionRequestInfo);
        return connection;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.out;
    }

    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        return new CometResourceAdapterMetaData();
    }

    public RecordFactory getRecordFactory() throws ResourceException {
        return new CometRecordFactory();
    }

    public Reference getReference() {
        System.out.println("In CometConnectionFactory::getReference");
        return this.reference;
    }

    public int getTimeout() throws ResourceException {
        return this.milliseconds;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.out = printWriter;
    }

    public void setReference(Reference reference) {
        System.out.println("In CometConnectionFactory::setReference");
        this.reference = reference;
    }

    public void setTimeout(int n) throws ResourceException {
        this.milliseconds = n;
    }
}

