/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sun.appserv;

import java.io.File;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class SunJspc
extends MatchingTask {
    private File destDir = null;
    private File srcDir;
    private String packageName;
    private String verboseLevel;
    private File uriRoot;
    private File uriBase;
    private Path classPath;
    private int compileListLength;
    private boolean failOnError = true;
    private File webAppBaseDir;
    private File sunoneHome;
    private static final String[] CLASSPATH_ELEMENTS = new String[]{"lib/appserv-rt.jar", "lib/appserv-ext.jar"};

    public void setSunonehome(File file) {
        this.sunoneHome = file;
    }

    public File getSunonehome() {
        String string;
        if (this.sunoneHome == null && (string = this.getProject().getProperty("sunone.home")) != null) {
            return new File(string);
        }
        return this.sunoneHome;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setSrcdir(File file) {
        this.srcDir = file;
    }

    public File getSrcdir() {
        return this.srcDir;
    }

    public void setPackage(String string) {
        this.packageName = string;
    }

    public String getPackage() {
        return this.packageName;
    }

    public void setVerbose(String string) {
        this.verboseLevel = string;
    }

    public String getVerbose() {
        return this.verboseLevel;
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void setUribase(File file) {
        this.uriBase = file;
    }

    public File getUribase() {
        if (this.uriBase != null) {
            return this.uriBase;
        }
        return this.uriRoot;
    }

    public void setUriroot(File file) {
        this.uriRoot = file;
    }

    public File getUriroot() {
        return this.uriRoot;
    }

    public void setClasspath(Path path) {
        if (this.classPath == null) {
            this.classPath = path;
        } else {
            this.classPath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classPath == null) {
            this.classPath = new Path(this.project);
        }
        return this.classPath.createPath();
    }

    public void setClasspathref(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setWebapp(File file) {
        this.webAppBaseDir = file;
    }

    public File getWebapp() {
        return this.webAppBaseDir;
    }

    public void execute() throws BuildException {
        if (this.webAppBaseDir == null) {
            if (this.srcDir == null) {
                throw new BuildException("Source Directory has to be provided", this.location);
            }
            if (!this.srcDir.exists() || !this.srcDir.isDirectory()) {
                throw new BuildException("Source directory " + this.srcDir.getAbsolutePath() + " does not exist or is not a " + " directory", this.location);
            }
        } else if (!this.webAppBaseDir.exists() || !this.webAppBaseDir.isDirectory()) {
            throw new BuildException("WebApp directory " + this.webAppBaseDir.getAbsolutePath() + " does not exist or is not a " + " directory", this.location);
        }
        if (this.destDir != null) {
            if (!this.destDir.exists()) {
                throw new BuildException("Destination Directory " + this.destDir + " does not exist");
            }
            if (!this.destDir.isDirectory()) {
                throw new BuildException(this.destDir + " is not a directory");
            }
        } else {
            throw new BuildException("Destination Directory has to be provided");
        }
        String[] stringArray = this.getCommandString();
        if (this.srcDir != null) {
            this.log("pre-compiling " + this.compileListLength + " JSP files to " + this.destDir.getAbsolutePath());
        }
        if (!this.doCompilation(stringArray)) {
            throw new BuildException("Compilation Failed...");
        }
    }

    protected boolean doCompilation(String[] stringArray) {
        try {
            Java java = (Java)this.project.createTask("java");
            java.setClasspath(this.constructPath());
            java.setClassname("org.apache.jasper.JspC");
            int n = 0;
            while (n < stringArray.length) {
                java.createArg().setValue(stringArray[n]);
                ++n;
            }
            java.setFailonerror(this.failOnError);
            java.setFork(true);
            this.log("Executing Jasper Compiler");
            int n2 = java.executeJava();
            if (n2 == 1) {
                this.log("Compilation of JSPs failed. Set verbosity level to 4-9 to see the cause.");
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            this.log("Exception : " + exception.toString());
            return false;
        }
    }

    protected String[] getCommandString() {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-d");
        arrayList.add(this.destDir.getAbsolutePath());
        if (this.packageName != null && this.packageName.length() > 0) {
            arrayList.add("-p");
            arrayList.add(this.packageName);
        }
        if (this.verboseLevel != null) {
            arrayList.add("-v".concat(this.verboseLevel));
        }
        if (this.uriRoot != null && this.uriRoot.exists()) {
            arrayList.add("-uriroot");
            arrayList.add(this.uriRoot.getAbsolutePath());
        }
        if (this.uriBase != null && this.uriBase.exists()) {
            arrayList.add("-uribase");
            arrayList.add(this.uriBase.getAbsolutePath());
        } else if (this.uriRoot != null && this.uriRoot.exists()) {
            arrayList.add("-uribase");
            arrayList.add(this.uriRoot.getAbsolutePath());
        }
        arrayList.add("-die1");
        if (this.webAppBaseDir != null) {
            arrayList.add("-webapp");
            arrayList.add(this.webAppBaseDir.getAbsolutePath());
        } else {
            stringArray = super.getDirectoryScanner(this.srcDir);
            String[] stringArray2 = stringArray.getIncludedFiles();
            this.compileListLength = stringArray2.length;
            int n = 0;
            while (n < stringArray2.length) {
                File file = new File(this.srcDir, stringArray2[n]);
                arrayList.add(file.getAbsolutePath());
                ++n;
            }
        }
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        return stringArray;
    }

    private Path constructPath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getSunonehome() != null) {
            int n = 0;
            while (n < CLASSPATH_ELEMENTS.length) {
                stringBuffer.append(new File(this.getSunonehome(), CLASSPATH_ELEMENTS[n]).getPath());
                stringBuffer.append(":");
                ++n;
            }
        }
        if (this.classPath != null) {
            stringBuffer.append(this.classPath);
            stringBuffer.append(":");
        }
        stringBuffer.append(Path.systemClasspath);
        return new Path(this.getProject(), stringBuffer.toString());
    }
}

