/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sun.appserv;

import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.AppServerAdmin;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.ComponentAdmin;

public class ComponentTask
extends ComponentAdmin {
    private String action;
    private static final String ACTION_ENABLE = "enable";
    private static final String ACTION_DISABLE = "disable";
    private static final Map ACTION_MAP = new HashMap(2);

    public void setAction(String string) {
        this.action = string;
    }

    protected void checkComponentConfig(AppServerAdmin.Server server, ComponentAdmin.Component component) throws BuildException {
        super.checkComponentConfig(server, component);
        if (this.action == null) {
            String string = "The action command must be specified.";
            throw new BuildException(string, this.getLocation());
        }
        if (!ACTION_MAP.containsKey(this.action)) {
            String string = "The action command (\"" + this.action + "\") is invalid.";
            throw new BuildException(string, this.getLocation());
        }
        String string = component.getName();
        if (string == null || string.length() == 0) {
            String string2 = "The component name (\"" + string + "\") is not valid";
            throw new BuildException(string2, this.getLocation());
        }
    }

    protected String getCommandString(AppServerAdmin.Server server, ComponentAdmin.Component component) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ACTION_MAP.get(this.action));
        stringBuffer.append(server.getCommandParameters(true));
        if (component.getType() != null) {
            stringBuffer.append(" --type ").append(component.getType());
        }
        stringBuffer.append(" ").append(component.getName());
        return stringBuffer.toString();
    }

    static {
        ACTION_MAP.put(ACTION_ENABLE, ACTION_ENABLE);
        ACTION_MAP.put(ACTION_DISABLE, ACTION_DISABLE);
    }
}

