/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.AuthDb;
import com.iplanet.ias.admin.servermodel.beans.HttpServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.VirtualServer;
import com.iplanet.ias.admin.servermodel.beans.VirtualServerClass;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Option;

public class ListAuthDBsCommand
extends BaseOtherCommand {
    private static final String VS_CLASS_ID = "defaultclass";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        try {
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            AppServerInstance appServerInstance = serverInstanceManager.getServerInstance(this.getInstanceOperand(0));
            String string = this.getVirtualServerOption();
            HttpServiceComponentBean httpServiceComponentBean = appServerInstance.getHttpService();
            VirtualServerClass virtualServerClass = httpServiceComponentBean.getVirtualServerClass(VS_CLASS_ID);
            VirtualServer virtualServer = virtualServerClass.getVirtualServer(string);
            ServerModelIterator serverModelIterator = virtualServer.getAuthDbs();
            if (serverModelIterator.hasNext()) {
                while (serverModelIterator.hasNext()) {
                    AuthDb authDb = (AuthDb)serverModelIterator.next();
                    this.printMessage(authDb);
                }
            } else {
                this.printMessage(this.getLocalizedString("NoAuthDBs"));
            }
            Debug.println(this.getClass().getName() + " : Command executed");
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotListAuthDBs"));
            throw new CommandException(exception.getLocalizedMessage());
        }
    }

    private String getVirtualServerOption() {
        Option option = this.findOption("virtualserver");
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        return string;
    }
}

