/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.license.IASLicense;
import com.iplanet.ias.license.LicenseManager;
import com.iplanet.ias.tools.cli.BaseLifeCycleCommand;
import com.iplanet.ias.tools.cli.PromptStream;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class InstallLicenseCommand
extends BaseLifeCycleCommand {
    private static final String LICENSE_TXT = "LICENSE.txt";
    private static final int row = 22;
    private static final int col = 79;

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        try {
            PromptStream promptStream = new PromptStream(System.in, System.out);
            BufferedReader bufferedReader = this.getLicenseTxtReader();
            this.PrintLicenseText(bufferedReader);
            if (!this.checkAgreement()) {
                return;
            }
            String string = promptStream.readln(this.getLocalizedString("LicenseKey") + " ");
            LicenseManager.upgradeLicenseKey((String)string.trim());
            IASLicense.reinit();
            this.printMessage(this.getLocalizedString("InstalledLicense"));
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CouldNotInstallLicense"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private void checkIfServersAreRunning() throws CommandException {
        String[] stringArray = this.getAllDomains();
        int n = 0;
        while (n < stringArray.length) {
            if (this.isAnyInstanceInDomainStarted(stringArray[n])) {
                this.printError(this.getLocalizedString("CouldNotInstallLicense"));
                throw new CommandException(this.getLocalizedString("InstancesInDomainRunning"));
            }
            ++n;
        }
    }

    private BufferedReader getLicenseTxtReader() throws CommandException {
        BufferedReader bufferedReader = null;
        try {
            File file = new File(System.getProperty("com.sun.aas.installRoot"), LICENSE_TXT);
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CommandException(fileNotFoundException.getLocalizedMessage());
        }
        return bufferedReader;
    }

    /*
     * Unable to fully structure code
     */
    private void PrintLicenseText(BufferedReader var1_1) throws CommandException {
        var2_2 = null;
        var3_3 = 0;
lbl3:
        // 2 sources

        try {
            while ((var2_2 = var1_1.readLine()) != null) {
                block5: {
                    if (var2_2.length() <= 79) break block5;
                    var4_4 = "";
                    var5_6 = 0;
                    var6_7 = new StringTokenizer(var2_2, " ");
                    while (var6_7.hasMoreTokens()) {
                        var7_8 = var6_7.nextToken();
                        var8_9 = 0;
                        while (var8_9 < var7_8.length()) {
                            var5_6 = var7_8.charAt(var8_9) == '\t' ? (var5_6 += 5) : ++var5_6;
                            ++var8_9;
                        }
                        var4_4 = var4_4 + " " + var7_8;
                        if (++var5_6 <= 79) continue;
                        this.printMessage(var4_4);
                        var3_3 = this.checkRows(var3_3);
                        var5_6 = 0;
                        var4_4 = "";
                    }
                    ** GOTO lbl3
                }
                this.printMessage(var2_2);
                var3_3 = this.checkRows(var3_3);
            }
        }
        catch (IOException var4_5) {
            Debug.printStackTrace(var4_5);
            this.printError(this.getLocalizedString("CouldNotReadLicenseTxt"));
            throw new CommandException(var4_5.getLocalizedMessage());
        }
    }

    private int checkRows(int n) {
        if (n == 22) {
            this.printPrompt(this.getLocalizedString("PressEnterToContinue"));
            try {
                while (System.in.read() != 10) {
                }
            }
            catch (IOException iOException) {
                this.printMessage(iOException.getMessage());
            }
            return 0;
        }
        return n + 1;
    }

    private boolean checkAgreement() throws CommandException {
        try {
            String string = "";
            PromptStream promptStream = new PromptStream(System.in, System.out);
            String string2 = "\n\n" + this.getLocalizedString("LicenseAgreement", new Object[]{this.getLocalizedString("YESNOString") + " "});
            while (!((string = promptStream.readln(string2)).equalsIgnoreCase(this.getLocalizedString("YesString")) || string.equalsIgnoreCase(this.getLocalizedString("NoString")) || string.equalsIgnoreCase(this.getLocalizedString("NCharacter")) || string.equalsIgnoreCase(this.getLocalizedString("YCharacter")))) {
            }
            return !string.equalsIgnoreCase(this.getLocalizedString("NoString")) && !string.equalsIgnoreCase(this.getLocalizedString("NCharacter"));
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CouldNotReadInput"));
            throw new CommandException(exception.getLocalizedMessage());
        }
    }
}

