/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.common.domains.registry;

import com.iplanet.ias.admin.common.domains.registry.ContactDataSet;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class DomainEntry
implements Cloneable,
Serializable {
    private String name;
    private File root;
    private String path;
    private ContactDataSet contactData;

    public DomainEntry(String string, File file, ContactDataSet contactDataSet) throws NullPointerException {
        if (string == null || file == null || contactDataSet == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.root = file;
        try {
            this.path = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            this.path = file.getAbsolutePath();
        }
        this.contactData = contactDataSet;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private boolean equals(DomainEntry domainEntry) {
        return domainEntry != null && this == domainEntry || this.name.equals(domainEntry.name) && this.root.equals(domainEntry.root);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof DomainEntry && this.equals((DomainEntry)object);
    }

    public ContactDataSet getContactData() {
        return this.contactData;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public File getRoot() {
        return this.root;
    }

    public int hashcode() {
        String string = String.valueOf(this.name) + this.root.toString();
        return string.hashCode();
    }
}

