/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.comm;

import com.iplanet.ias.admin.comm.AFConnectionException;
import com.iplanet.ias.admin.comm.ConnectionFactory;
import com.iplanet.ias.admin.comm.ConnectorClient;
import com.iplanet.ias.admin.comm.HttpConnectorAddress;
import com.iplanet.ias.admin.comm.IConnection;
import com.iplanet.ias.admin.common.AdminRequest;
import com.iplanet.ias.admin.common.AdminRequestConfigurator;
import com.iplanet.ias.admin.common.AdminResponse;
import com.iplanet.ias.admin.common.AdminResponseConfigurator;
import com.iplanet.ias.admin.common.exception.AFRuntimeException;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import java.io.IOException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;

public class AdminConnectorClient
implements ConnectorClient {
    private final HttpConnectorAddress connectorAddress;
    private static final String ADMIN_CLIENT_VERSION = "1.1";

    public AdminConnectorClient(HttpConnectorAddress httpConnectorAddress) {
        this.connectorAddress = httpConnectorAddress;
        Debug.println("AdminConnectorClient.<init> : host = " + httpConnectorAddress.getHost() + " port = " + httpConnectorAddress.getPort() + " user = " + httpConnectorAddress.getAuthenticationInfo().getUser());
    }

    public String getClientVersion() {
        return ADMIN_CLIENT_VERSION;
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Object object = null;
        AdminRequest adminRequest = new AdminRequest("invoke");
        AdminRequestConfigurator adminRequestConfigurator = new AdminRequestConfigurator(adminRequest);
        adminRequestConfigurator.setObjectName(objectName);
        adminRequestConfigurator.setOperationName(string);
        adminRequestConfigurator.setOperationParams(objectArray);
        adminRequestConfigurator.setOperationSignature(stringArray);
        adminRequestConfigurator.setClientVersion(ADMIN_CLIENT_VERSION);
        AdminResponse adminResponse = this.sendRequest(adminRequest);
        AdminResponseConfigurator adminResponseConfigurator = new AdminResponseConfigurator(adminResponse);
        if (adminResponseConfigurator.hasException()) {
            Throwable throwable = adminResponseConfigurator.getException();
            if (throwable instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)throwable;
            }
            if (throwable instanceof MBeanException) {
                throw (MBeanException)throwable;
            }
            if (throwable instanceof ReflectionException) {
                throw (ReflectionException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable);
            }
        } else {
            object = adminResponseConfigurator.getReturnValue();
        }
        return object;
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        Object object = null;
        AdminRequest adminRequest = new AdminRequest("getAttribute");
        AdminRequestConfigurator adminRequestConfigurator = new AdminRequestConfigurator(adminRequest);
        adminRequestConfigurator.setObjectName(objectName);
        adminRequestConfigurator.setAttributeName(string);
        adminRequestConfigurator.setClientVersion(ADMIN_CLIENT_VERSION);
        AdminResponse adminResponse = this.sendRequest(adminRequest);
        AdminResponseConfigurator adminResponseConfigurator = new AdminResponseConfigurator(adminResponse);
        if (adminResponseConfigurator.hasException()) {
            Throwable throwable = adminResponseConfigurator.getException();
            if (throwable instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)throwable;
            }
            if (throwable instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)throwable;
            }
            if (throwable instanceof MBeanException) {
                throw (MBeanException)throwable;
            }
            if (throwable instanceof ReflectionException) {
                throw (ReflectionException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable);
            }
        } else {
            object = adminResponseConfigurator.getReturnValue();
        }
        return object;
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        AdminRequest adminRequest = new AdminRequest("setAttribute");
        AdminRequestConfigurator adminRequestConfigurator = new AdminRequestConfigurator(adminRequest);
        adminRequestConfigurator.setObjectName(objectName);
        adminRequestConfigurator.setAttribute(attribute);
        adminRequestConfigurator.setClientVersion(ADMIN_CLIENT_VERSION);
        AdminResponse adminResponse = this.sendRequest(adminRequest);
        AdminResponseConfigurator adminResponseConfigurator = new AdminResponseConfigurator(adminResponse);
        if (adminResponseConfigurator.hasException()) {
            Throwable throwable = adminResponseConfigurator.getException();
            if (throwable instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)throwable;
            }
            if (throwable instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)throwable;
            }
            if (throwable instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)throwable;
            }
            if (throwable instanceof MBeanException) {
                throw (MBeanException)throwable;
            }
            if (throwable instanceof ReflectionException) {
                throw (ReflectionException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable);
            }
        }
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        AttributeList attributeList = null;
        AdminRequest adminRequest = new AdminRequest("getAttributes");
        AdminRequestConfigurator adminRequestConfigurator = new AdminRequestConfigurator(adminRequest);
        adminRequestConfigurator.setObjectName(objectName);
        adminRequestConfigurator.setAttributeNames(stringArray);
        adminRequestConfigurator.setClientVersion(ADMIN_CLIENT_VERSION);
        AdminResponse adminResponse = this.sendRequest(adminRequest);
        AdminResponseConfigurator adminResponseConfigurator = new AdminResponseConfigurator(adminResponse);
        if (adminResponseConfigurator.hasException()) {
            Throwable throwable = adminResponseConfigurator.getException();
            if (throwable instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)throwable;
            }
            if (throwable instanceof ReflectionException) {
                throw (ReflectionException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable);
            }
        } else {
            attributeList = (AttributeList)adminResponseConfigurator.getReturnValue();
        }
        return attributeList;
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        AttributeList attributeList2 = null;
        AdminRequest adminRequest = new AdminRequest("setAttributes");
        AdminRequestConfigurator adminRequestConfigurator = new AdminRequestConfigurator(adminRequest);
        adminRequestConfigurator.setObjectName(objectName);
        adminRequestConfigurator.setAttributeList(attributeList);
        adminRequestConfigurator.setClientVersion(ADMIN_CLIENT_VERSION);
        AdminResponse adminResponse = this.sendRequest(adminRequest);
        AdminResponseConfigurator adminResponseConfigurator = new AdminResponseConfigurator(adminResponse);
        if (adminResponseConfigurator.hasException()) {
            Throwable throwable = adminResponseConfigurator.getException();
            if (throwable instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)throwable;
            }
            if (throwable instanceof ReflectionException) {
                throw (ReflectionException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable);
            }
        } else {
            attributeList2 = (AttributeList)adminResponseConfigurator.getReturnValue();
        }
        return attributeList2;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AdminResponse sendRequest(AdminRequest adminRequest) throws AFConnectionException, AFRuntimeException {
        AdminResponse adminResponse = null;
        IConnection iConnection = null;
        iConnection = ConnectionFactory.createConnection(this.connectorAddress);
        iConnection.send(adminRequest);
        adminResponse = (AdminResponse)iConnection.receive();
        Object var8_4 = null;
        if (iConnection == null) return adminResponse;
        try {
            iConnection.close();
            return adminResponse;
        }
        catch (Exception exception) {
            ExceptionUtil.ignoreException(exception);
        }
        return adminResponse;
        {
            catch (IOException iOException) {
                Debug.printStackTrace(iOException);
                throw new AFConnectionException(iOException.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AFRuntimeException(classNotFoundException.toString());
            }
            catch (Exception exception) {
                throw new AFRuntimeException(exception.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            if (iConnection == null) throw throwable;
            try {
                iConnection.close();
                throw throwable;
            }
            catch (Exception exception) {
                ExceptionUtil.ignoreException(exception);
            }
            throw throwable;
        }
    }
}

