/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.util;

import java.io.CharConversionException;
import java.io.Serializable;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.PasswordCallback;
import org.mozilla.jss.util.PasswordCallbackInfo;
import org.mozilla.jss.util.UTF8Converter;

public class Password
implements PasswordCallback,
Cloneable,
Serializable {
    private char[] password;
    private boolean cleared;

    private Password() {
        this.cleared = true;
    }

    public Password(char[] cArray) {
        int n = cArray.length;
        this.cleared = false;
        this.password = new char[n];
        int n2 = 0;
        while (n2 < n) {
            this.password[n2] = cArray[n2];
            cArray[n2] = '\u0000';
            ++n2;
        }
    }

    public static byte[] charToByte(char[] cArray) {
        byte[] byArray;
        Assert.assert(cArray != null);
        try {
            try {
                byArray = UTF8Converter.UnicodeToUTF8NullTerm(cArray);
            }
            catch (CharConversionException charConversionException) {
                Assert.notReached("Password could not be converted from Unicode");
                byArray = new byte[1];
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Password.wipeChars(cArray);
            throw throwable;
        }
        Password.wipeChars(cArray);
        return byArray;
    }

    public synchronized void clear() {
        int n = this.password.length;
        int n2 = 0;
        while (n2 < n) {
            this.password[n2] = '\u0000';
            ++n2;
        }
        this.cleared = true;
    }

    public synchronized Object clone() {
        Password password = new Password();
        password.password = (char[])this.password.clone();
        password.cleared = this.cleared;
        return password;
    }

    public synchronized boolean equals(Object object) {
        if (object == null || !(object instanceof Password)) {
            return false;
        }
        Password password = (Password)object;
        if (password.password == null || this.password == null) {
            return false;
        }
        if (password.password.length != this.password.length) {
            return false;
        }
        int n = 0;
        while (n < this.password.length) {
            if (password.password[n] != this.password[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        this.clear();
    }

    synchronized byte[] getByteCopy() {
        return Password.charToByte((char[])this.password.clone());
    }

    public synchronized char[] getCharCopy() {
        return (char[])this.password.clone();
    }

    public synchronized char[] getChars() {
        return this.password;
    }

    public synchronized Password getPasswordAgain(PasswordCallbackInfo passwordCallbackInfo) throws PasswordCallback.GiveUpException {
        throw new PasswordCallback.GiveUpException();
    }

    public synchronized Password getPasswordFirstAttempt(PasswordCallbackInfo passwordCallbackInfo) throws PasswordCallback.GiveUpException {
        if (this.cleared) {
            throw new PasswordCallback.GiveUpException();
        }
        return (Password)this.clone();
    }

    public static synchronized native Password readPasswordFromConsole() throws PasswordCallback.GiveUpException;

    public static void wipeBytes(byte[] byArray) {
        Assert.assert(byArray != null);
        UTF8Converter.wipeBytes(byArray);
    }

    public static void wipeChars(char[] cArray) {
        Assert.assert(cArray != null);
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = '\u0000';
            ++n;
        }
    }
}

