/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class POPOSigningKey
implements ASN1Value {
    private ANY poposkInput;
    private AlgorithmIdentifier algorithmIdentifier;
    private BIT_STRING signature;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private POPOSigningKey() {
    }

    public POPOSigningKey(ANY aNY, AlgorithmIdentifier algorithmIdentifier, BIT_STRING bIT_STRING) {
        if (algorithmIdentifier == null || bIT_STRING == null) {
            throw new IllegalArgumentException("parameter to POPOSigningKey constructor is null");
        }
        this.poposkInput = aNY;
        this.algorithmIdentifier = algorithmIdentifier;
        this.signature = bIT_STRING;
        this.sequence = new SEQUENCE();
        this.sequence.addElement(Tag.get(0L), aNY);
        this.sequence.addElement(algorithmIdentifier);
        this.sequence.addElement(bIT_STRING);
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.sequence.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    public ANY getPoposkInput() {
        return this.poposkInput;
    }

    public BIT_STRING getSignature() {
        return this.signature;
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addOptionalElement(new EXPLICIT.Template(Tag.get(0L), ANY.getTemplate()));
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(BIT_STRING.getTemplate());
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new POPOSigningKey((ANY)sEQUENCE.elementAt(0), (AlgorithmIdentifier)sEQUENCE.elementAt(1), (BIT_STRING)sEQUENCE.elementAt(2));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }
    }
}

