/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.crmf.CertTemplate;
import org.mozilla.jss.pkix.primitive.AVA;

public class CertRequest
implements ASN1Value {
    private INTEGER certReqId;
    private CertTemplate certTemplate;
    private SEQUENCE controls;
    public static final Tag TAG = SEQUENCE.TAG;

    private CertRequest() {
    }

    CertRequest(INTEGER iNTEGER, CertTemplate certTemplate, SEQUENCE sEQUENCE) {
        this.certReqId = iNTEGER;
        this.certTemplate = certTemplate;
        this.controls = sEQUENCE;
    }

    public AVA controlAt(int n) {
        if (this.controls == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (AVA)this.controls.elementAt(n);
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.getTag(), outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(this.certReqId);
        sEQUENCE.addElement(this.certTemplate);
        if (this.controls != null) {
            sEQUENCE.addElement(this.controls);
        }
        sEQUENCE.encode(tag, outputStream);
    }

    public INTEGER getCertReqId() {
        return this.certReqId;
    }

    public CertTemplate getCertTemplate() {
        return this.certTemplate;
    }

    public Tag getTag() {
        return TAG;
    }

    public int numControls() {
        if (this.controls == null) {
            return 0;
        }
        return this.controls.size();
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqTemplate = new SEQUENCE.Template();

        public Template() {
            this.seqTemplate.addElement(new INTEGER.Template());
            this.seqTemplate.addElement(new CertTemplate.Template());
            this.seqTemplate.addOptionalElement(new SEQUENCE.OF_Template(new AVA.Template()));
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqTemplate.decode(tag, inputStream);
            return new CertRequest((INTEGER)sEQUENCE.elementAt(0), (CertTemplate)sEQUENCE.elementAt(1), (SEQUENCE)sEQUENCE.elementAt(2));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }
    }
}

