/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import org.apache.naming.ContextAccessController;
import org.apache.naming.NameParserImpl;
import org.apache.naming.NamingContextBindingsEnumeration;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.StringManager;

public class NamingContext
implements Context {
    protected static final NameParser nameParser = new NameParserImpl();
    protected Hashtable env;
    protected StringManager sm = StringManager.getManager("org.apache.naming");
    protected Hashtable bindings = new Hashtable();
    protected String name;

    public NamingContext(Hashtable hashtable, String string) throws NamingException {
        this.env = new Hashtable();
        this.name = string;
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                this.addToEnvironment(string2, hashtable.get(string2));
            }
        }
    }

    public NamingContext(Hashtable hashtable, String string, Hashtable hashtable2) throws NamingException {
        this(hashtable, string);
        this.bindings = hashtable2;
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name, true);
    }

    public Object lookup(String string) throws NamingException {
        return this.lookup(new CompositeName(string), true);
    }

    public void bind(Name name, Object object) throws NamingException {
        this.bind(name, object, false);
    }

    public void bind(String string, Object object) throws NamingException {
        this.bind(new CompositeName(string), object);
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.bind(name, object, true);
    }

    public void rebind(String string, Object object) throws NamingException {
        this.rebind(new CompositeName(string), object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unbind(Name name) throws NamingException {
        this.checkWritable();
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            throw new NamingException(this.sm.getString("namingContext.invalidName"));
        }
        NamingEntry namingEntry = (NamingEntry)this.bindings.get(name.get(0));
        if (namingEntry == null) {
            throw new NameNotFoundException(this.sm.getString("namingContext.nameNotBound", name.get(0)));
        }
        if (name.size() > 1) {
            if (namingEntry.type != 10) throw new NamingException(this.sm.getString("namingContext.contextExpected"));
            ((Context)namingEntry.value).unbind(name.getSuffix(1));
            return;
        } else {
            this.bindings.remove(name.get(0));
        }
    }

    public void unbind(String string) throws NamingException {
        this.unbind(new CompositeName(string));
    }

    public void rename(Name name, Name name2) throws NamingException {
        Object object = this.lookup(name);
        this.bind(name2, object);
        this.unbind(name);
    }

    public void rename(String string, String string2) throws NamingException {
        this.rename(new CompositeName(string), new CompositeName(string2));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return new NamingContextEnumeration(this.bindings.elements());
        }
        NamingEntry namingEntry = (NamingEntry)this.bindings.get(name.get(0));
        if (namingEntry == null) {
            throw new NameNotFoundException(this.sm.getString("namingContext.nameNotBound", name.get(0)));
        }
        if (namingEntry.type != 10) {
            throw new NamingException(this.sm.getString("namingContext.contextExpected"));
        }
        return ((Context)namingEntry.value).list(name.getSuffix(1));
    }

    public NamingEnumeration list(String string) throws NamingException {
        return this.list(new CompositeName(string));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return new NamingContextBindingsEnumeration(this.bindings.elements());
        }
        NamingEntry namingEntry = (NamingEntry)this.bindings.get(name.get(0));
        if (namingEntry == null) {
            throw new NameNotFoundException(this.sm.getString("namingContext.nameNotBound", name.get(0)));
        }
        if (namingEntry.type != 10) {
            throw new NamingException(this.sm.getString("namingContext.contextExpected"));
        }
        return ((Context)namingEntry.value).listBindings(name.getSuffix(1));
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return this.listBindings(new CompositeName(string));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void destroySubcontext(Name name) throws NamingException {
        this.checkWritable();
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            throw new NamingException(this.sm.getString("namingContext.invalidName"));
        }
        NamingEntry namingEntry = (NamingEntry)this.bindings.get(name.get(0));
        if (namingEntry == null) {
            throw new NameNotFoundException(this.sm.getString("namingContext.nameNotBound", name.get(0)));
        }
        if (name.size() > 1) {
            if (namingEntry.type != 10) throw new NamingException(this.sm.getString("namingContext.contextExpected"));
            ((Context)namingEntry.value).unbind(name.getSuffix(1));
            return;
        } else {
            if (namingEntry.type != 10) throw new NotContextException(this.sm.getString("namingContext.contextExpected"));
            ((Context)namingEntry.value).close();
            this.bindings.remove(name.get(0));
        }
    }

    public void destroySubcontext(String string) throws NamingException {
        this.destroySubcontext(new CompositeName(string));
    }

    public Context createSubcontext(Name name) throws NamingException {
        this.checkWritable();
        NamingContext namingContext = new NamingContext(this.env, this.name);
        this.bind(name, (Object)namingContext);
        return namingContext;
    }

    public Context createSubcontext(String string) throws NamingException {
        return this.createSubcontext(new CompositeName(string));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name, false);
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookup(new CompositeName(string), false);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return nameParser;
        }
        if (name.size() > 1) {
            Object v = this.bindings.get(name.get(0));
            if (v instanceof Context) {
                return ((Context)v).getNameParser(name.getSuffix(1));
            }
            throw new NotContextException(this.sm.getString("namingContext.contextExpected"));
        }
        return nameParser;
    }

    public NameParser getNameParser(String string) throws NamingException {
        return this.getNameParser(new CompositeName(string));
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        name2 = (Name)name.clone();
        return name2.addAll(name);
    }

    public String composeName(String string, String string2) throws NamingException {
        return string2 + "/" + string;
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.env.put(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        return this.env.remove(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    public void close() throws NamingException {
        this.env.clear();
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException(this.sm.getString("namingContext.noAbsoluteName"));
    }

    protected Object lookup(Name name, boolean bl) throws NamingException {
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return new NamingContext(this.env, this.name, this.bindings);
        }
        NamingEntry namingEntry = (NamingEntry)this.bindings.get(name.get(0));
        if (namingEntry == null) {
            throw new NameNotFoundException(this.sm.getString("namingContext.nameNotBound", name.get(0)));
        }
        if (name.size() > 1) {
            if (namingEntry.type != 10) {
                throw new NamingException(this.sm.getString("namingContext.contextExpected"));
            }
            return ((Context)namingEntry.value).lookup(name.getSuffix(1));
        }
        if (bl && namingEntry.type == 1) {
            String string = ((LinkRef)namingEntry.value).getLinkName();
            if (string.startsWith(".")) {
                return this.lookup(string.substring(1));
            }
            return new InitialContext(this.env).lookup(string);
        }
        if (namingEntry.type == 2) {
            try {
                Object object = NamingManager.getObjectInstance(namingEntry.value, name, this, this.env);
                if (object != null) {
                    namingEntry.value = object;
                    namingEntry.type = 0;
                }
                return object;
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (Exception exception) {
                throw new NamingException(exception.getMessage());
            }
        }
        return namingEntry.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void bind(Name name, Object object, boolean bl) throws NamingException {
        this.checkWritable();
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            throw new NamingException(this.sm.getString("namingContext.invalidName"));
        }
        NamingEntry namingEntry = (NamingEntry)this.bindings.get(name.get(0));
        if (name.size() > 1) {
            if (namingEntry == null) {
                throw new NameNotFoundException(this.sm.getString("namingContext.nameNotBound", name.get(0)));
            }
            if (namingEntry.type != 10) throw new NamingException(this.sm.getString("namingContext.contextExpected"));
            if (bl) {
                ((Context)namingEntry.value).rebind(name.getSuffix(1), object);
                return;
            } else {
                ((Context)namingEntry.value).bind(name.getSuffix(1), object);
            }
            return;
        } else {
            if (!bl && namingEntry != null) {
                throw new NamingException(this.sm.getString("namingContext.alreadyBound", name.get(0)));
            }
            Object object2 = NamingManager.getStateToBind(object, name, this, this.env);
            if (object2 instanceof Context) {
                namingEntry = new NamingEntry(name.get(0), object2, 10);
            } else if (object2 instanceof LinkRef) {
                namingEntry = new NamingEntry(name.get(0), object2, 1);
            } else if (object2 instanceof Reference) {
                namingEntry = new NamingEntry(name.get(0), object2, 2);
            } else if (object2 instanceof Referenceable) {
                object2 = ((Referenceable)object2).getReference();
                namingEntry = new NamingEntry(name.get(0), object2, 2);
            } else {
                namingEntry = new NamingEntry(name.get(0), object2, 0);
            }
            this.bindings.put(name.get(0), namingEntry);
        }
    }

    protected boolean isWritable() {
        return ContextAccessController.isWritable(this.name);
    }

    protected void checkWritable() throws NamingException {
        if (!this.isWritable()) {
            throw new NamingException(this.sm.getString("namingContext.readOnly"));
        }
    }
}

