/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class ProcessEnvironment {
    private ServletContext context = null;
    private String webAppRootDir = null;
    private String contextPath = null;
    protected String pathInfo = null;
    private String servletPath = null;
    protected Hashtable env = null;
    protected String command = null;
    protected boolean valid = false;
    protected int debug = 0;
    protected File workingDirectory = null;

    public ProcessEnvironment(HttpServletRequest httpServletRequest, ServletContext servletContext) {
        this(httpServletRequest, servletContext, 0);
    }

    public ProcessEnvironment(HttpServletRequest httpServletRequest, ServletContext servletContext, int n) {
        this.debug = n;
        this.setupFromContext(servletContext);
        this.setupFromRequest(httpServletRequest);
        this.valid = this.deriveProcessEnvironment(httpServletRequest);
        this.log(this.getClass().getName() + "() ctor, debug level " + n);
    }

    protected void setupFromContext(ServletContext servletContext) {
        this.context = servletContext;
        this.webAppRootDir = servletContext.getRealPath("/");
    }

    protected void setupFromRequest(HttpServletRequest httpServletRequest) {
        this.contextPath = httpServletRequest.getContextPath();
        this.pathInfo = httpServletRequest.getPathInfo();
        this.servletPath = httpServletRequest.getServletPath();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<TABLE border=2>");
        stringBuffer.append("<tr><th colspan=2 bgcolor=grey>");
        stringBuffer.append("ProcessEnvironment Info</th></tr>");
        stringBuffer.append("<tr><td>Debug Level</td><td>");
        stringBuffer.append(this.debug);
        stringBuffer.append("</td></tr>");
        stringBuffer.append("<tr><td>Validity:</td><td>");
        stringBuffer.append(this.isValid());
        stringBuffer.append("</td></tr>");
        if (this.isValid()) {
            Enumeration enumeration = this.env.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("<tr><td>");
                stringBuffer.append(string);
                stringBuffer.append("</td><td>");
                stringBuffer.append(this.blanksToString((String)this.env.get(string), "[will be set to blank]"));
                stringBuffer.append("</td></tr>");
            }
        }
        stringBuffer.append("<tr><td colspan=2><HR></td></tr>");
        stringBuffer.append("<tr><td>Derived Command</td><td>");
        stringBuffer.append(this.nullsToBlanks(this.command));
        stringBuffer.append("</td></tr>");
        stringBuffer.append("<tr><td>Working Directory</td><td>");
        if (this.workingDirectory != null) {
            stringBuffer.append(this.workingDirectory.toString());
        }
        stringBuffer.append("</td></tr>");
        stringBuffer.append("</TABLE><p>end.");
        return stringBuffer.toString();
    }

    public String getCommand() {
        return this.command;
    }

    protected String setCommand(String string) {
        return string;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Hashtable getEnvironment() {
        return this.env;
    }

    public Hashtable setEnvironment(Hashtable hashtable) {
        this.env = hashtable;
        return this.env;
    }

    public boolean isValid() {
        return this.valid;
    }

    protected String nullsToBlanks(String string) {
        return this.nullsToString(string, "");
    }

    protected String nullsToString(String string, String string2) {
        return string == null ? string2 : string;
    }

    protected String blanksToString(String string, String string2) {
        return "".equals(string) || string == null ? string2 : string;
    }

    protected void log(String string) {
        System.out.println(string);
    }

    protected boolean deriveProcessEnvironment(HttpServletRequest httpServletRequest) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        this.command = this.getCommand();
        if (this.command != null) {
            this.workingDirectory = new File(this.command.substring(0, this.command.lastIndexOf(File.separator)));
            hashtable.put("X_TOMCAT_COMMAND_PATH", this.command);
        }
        this.env = hashtable;
        return true;
    }

    public String getWebAppRootDir() {
        return this.webAppRootDir;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ServletContext getContext() {
        return this.context;
    }

    public String getServletPath() {
        return this.servletPath;
    }
}

